/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.Stack;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerUtilRt {
    @NotNull
    public static <K, V> java.util.HashMap<K, V> newHashMap() {
        HashMap hashMap = new HashMap();
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashMap"));
        }
        return hashMap;
    }

    @NotNull
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        TreeMap treeMap = new TreeMap();
        if (treeMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newTreeMap"));
        }
        return treeMap;
    }

    @NotNull
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = new ArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    public static <T> ArrayList<T> newArrayList(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ContainerUtilRt", "newArrayList"));
        }
        ArrayList<T> list = ContainerUtilRt.newArrayListWithCapacity(elements.length);
        Collections.addAll(list, elements);
        ArrayList<T> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    public static <T> ArrayList<T> newArrayList(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ContainerUtilRt", "newArrayList"));
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            ArrayList arrayList = new ArrayList(collection);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newArrayList"));
            }
            return arrayList;
        }
        ArrayList<T> arrayList = ContainerUtilRt.copy(ContainerUtilRt.<T>newArrayList(), elements);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newArrayList"));
        }
        return arrayList;
    }

    @NotNull
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        ArrayList arrayList = new ArrayList(size);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newArrayListWithCapacity"));
        }
        return arrayList;
    }

    @NotNull
    private static <T, C extends Collection<T>> C copy(@NotNull C collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ContainerUtilRt", "copy"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ContainerUtilRt", "copy"));
        }
        for (T element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "copy"));
        }
        return c;
    }

    @NotNull
    public static <T> java.util.HashSet<T> newHashSet() {
        HashSet hashSet = new HashSet();
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    public static <T> java.util.HashSet<T> newHashSet(int initialCapacity) {
        HashSet hashSet = new HashSet(initialCapacity);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    public static <T> java.util.HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
        }
        HashSet<T> hashSet = new HashSet<T>(Arrays.asList(elements));
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    public static <T> java.util.HashSet<T> newHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
        }
        if (elements instanceof Collection) {
            Collection collection = (Collection)elements;
            HashSet hashSet = new HashSet(collection);
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
            }
            return hashSet;
        }
        java.util.HashSet<? extends T> hashSet = ContainerUtilRt.newHashSet(elements.iterator());
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    public static <T> java.util.HashSet<T> newHashSet(@NotNull Iterator<? extends T> iterator2) {
        if (iterator2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
        }
        java.util.HashSet<T> set = ContainerUtilRt.newHashSet();
        while (iterator2.hasNext()) {
            set.add(iterator2.next());
        }
        java.util.HashSet<T> hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newHashSet"));
        }
        return hashSet;
    }

    @NotNull
    public static <T> Stack<T> newStack() {
        Stack stack = new Stack();
        if (stack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "newStack"));
        }
        return stack;
    }

    @NotNull
    public static <T> List<T> emptyList() {
        EmptyList emptyList = EmptyList.INSTANCE;
        if (emptyList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "emptyList"));
        }
        return emptyList;
    }

    public static <T> void addIfNotNull(@Nullable T element, @NotNull Collection<T> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ContainerUtilRt", "addIfNotNull"));
        }
        if (element != null) {
            result.add(element);
        }
    }

    public static <T> void addIfNotNull(@NotNull Collection<T> result, @Nullable T element) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ContainerUtilRt", "addIfNotNull"));
        }
        if (element != null) {
            result.add(element);
        }
    }

    @NotNull
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ContainerUtilRt", "map2List"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ContainerUtilRt", "map2List"));
        }
        if (collection.isEmpty()) {
            List<T> list = ContainerUtilRt.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "map2List"));
            }
            return list;
        }
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapper.fun(t));
        }
        ArrayList<V> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "map2List"));
        }
        return arrayList;
    }

    @NotNull
    public static <T> T[] toArray(@NotNull Collection<T> c, @NotNull T[] sample) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ContainerUtilRt", "toArray"));
        }
        if (sample == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ContainerUtilRt", "toArray"));
        }
        int size = c.size();
        if (size == sample.length && size < 20) {
            int i = 0;
            for (T t : c) {
                sample[i++] = t;
            }
            if (sample == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "toArray"));
            }
            return sample;
        }
        T[] TArray = c.toArray(sample);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt", "toArray"));
        }
        return TArray;
    }

    private static class EmptyList<T>
    extends AbstractList<T>
    implements Serializable,
    RandomAccess {
        private static final EmptyList INSTANCE = new EmptyList();

        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        @NotNull
        public Object[] toArray() {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt$EmptyList", "toArray"));
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            if (a == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ContainerUtilRt$EmptyList", "toArray"));
            }
            if (a.length != 0) {
                a[0] = null;
            }
            if (a == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt$EmptyList", "toArray"));
            }
            return a;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            EmptyIterator emptyIterator = EmptyIterator.getInstance();
            if (emptyIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtilRt$EmptyList", "iterator"));
            }
            return emptyIterator;
        }
    }
}

