/*
 * Decompiled with CFR 0.152.
 */
package kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.FilterIterator;
import kotlin.FilterNotNullIterator;
import kotlin.FlatMapIterator;
import kotlin.Function1;
import kotlin.Function2;
import kotlin.IndexIterator;
import kotlin.KotlinPackage$filterNot$1;
import kotlin.KotlinPackage$requireNoNulls$1;
import kotlin.KotlinPackage$sortBy$sortBy$9;
import kotlin.KotlinPackage$take$1;
import kotlin.KotlinPackage-IterablesSpecial-4ef8751f;
import kotlin.KotlinPackage-Iterators-7137b0f2;
import kotlin.KotlinPackage-OrderingJVM-c145938a;
import kotlin.MapIterator;
import kotlin.Pair;
import kotlin.SingleIterator;
import kotlin.TakeWhileIterator;
import kotlin.Unit;
import kotlin.inline;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinSyntheticClass(abiVersion=15, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class KotlinPackage-_Iterators-4fce5703 {
    @inline
    public static final <T> boolean all(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            if (!(predicate.invoke(element) == false)) continue;
            return false;
        }
        return true;
    }

    @inline
    public static final <T> boolean any(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            if (!predicate.invoke(element).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static final <T> void appendString(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="buffer") @NotNull Appendable buffer, @JetValueParameter(name="separator") @NotNull String separator, @JetValueParameter(name="prefix") @NotNull String prefix, @JetValueParameter(name="postfix") @NotNull String postfix, @JetValueParameter(name="limit") int limit, @JetValueParameter(name="truncated") @NotNull String truncated) {
        buffer.append(prefix);
        int count = 0;
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            if (++count > 1) {
                buffer.append(separator);
            }
            boolean bl = !(limit < 0) ? count <= limit : true;
            if (!bl) break;
            boolean bl2 = true;
            if (element != null) {
                bl2 = false;
            }
            String text = bl2 ? "null" : element.toString();
            buffer.append(text);
        }
        boolean bl = limit >= 0 ? count > limit : false;
        if (bl) {
            buffer.append(truncated);
        }
        buffer.append(postfix);
    }

    public static void appendString$default(Iterator iterator2, Appendable appendable, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 2) != 0) {
            string = ", ";
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            string4 = "...";
        }
        KotlinPackage-_Iterators-4fce5703.appendString(iterator2, appendable, string, string2, string3, n, string4);
    }

    @inline
    public static final <T> int count(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        int count = 0;
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext()) {
            Object object2;
            T element = iterator2.next();
            if (predicate.invoke(element).booleanValue()) {
                object2 = count;
                ++count;
                continue;
            }
            object2 = Unit.VALUE;
        }
        return count;
    }

    @NotNull
    public static final <T> List<T> drop(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="n") int n) {
        Iterator<? extends T> iterator2 = $receiver;
        Function1 function1 = KotlinPackage-IterablesSpecial-4ef8751f.countTo(n);
        Iterator<? extends T> iterator3 = iterator2;
        List list = new ArrayList();
        boolean bl = true;
        Iterator<T> iterator4 = KotlinPackage-Iterators-7137b0f2.iterator(iterator3);
        while (iterator4.hasNext()) {
            Object object2;
            T t = iterator4.next();
            if (!(bl ? function1.invoke(t) : false)) {
                bl = false;
                object2 = list.add(t);
                continue;
            }
            object2 = Unit.VALUE;
        }
        return (ArrayList)list;
    }

    @inline
    @NotNull
    public static final <T> List<T> dropWhile(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        Iterator<? extends T> iterator2 = $receiver;
        List list = new ArrayList();
        boolean bl = true;
        Iterator<T> iterator3 = KotlinPackage-Iterators-7137b0f2.iterator(iterator2);
        while (iterator3.hasNext()) {
            Object object2;
            T t = iterator3.next();
            if (!(bl ? predicate.invoke(t) : false)) {
                bl = false;
                object2 = list.add(t);
                continue;
            }
            object2 = Unit.VALUE;
        }
        return (ArrayList)list;
    }

    @inline
    @NotNull
    public static final <T, L extends List<? super T>> L dropWhileTo(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") @NotNull L result, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        int start = 1;
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext()) {
            Object object2;
            T element = iterator2.next();
            if (!(start != 0 ? predicate.invoke(element) : false)) {
                start = 0;
                object2 = result.add(element);
                continue;
            }
            object2 = Unit.VALUE;
        }
        return result;
    }

    @NotNull
    public static final <T> Iterator<T> filter(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        return new FilterIterator<T>($receiver, predicate);
    }

    @inline
    @NotNull
    public static final <T> Iterator<T> filterNot(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        return KotlinPackage-_Iterators-4fce5703.filter($receiver, new KotlinPackage$filterNot$1(predicate));
    }

    @NotNull
    public static final <T> Iterator<T> filterNotNull(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver) {
        return new FilterNotNullIterator<T>($receiver);
    }

    @NotNull
    public static final <T, C extends Collection<? super T>> C filterNotNullTo(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result) {
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            boolean bl = true;
            if (element == null) {
                bl = false;
            }
            Object object2 = bl ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @inline
    @NotNull
    public static final <T, C extends Collection<? super T>> C filterNotTo(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            Object object2 = predicate.invoke(element) == false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @inline
    @NotNull
    public static final <T, C extends Collection<? super T>> C filterTo(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            Object object2 = predicate.invoke(element) != false ? Boolean.valueOf(result.add(element)) : Unit.VALUE;
        }
        return result;
    }

    @inline
    @Nullable
    public static final <T> T find(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            if (!predicate.invoke(element).booleanValue()) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public static final <T, R> Iterator<R> flatMap(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="transform") @NotNull Function1<? super T, ? extends Iterator<? extends R>> transform) {
        return new FlatMapIterator($receiver, transform);
    }

    @inline
    @NotNull
    public static final <T, R, C extends Collection<? super R>> C flatMapTo(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="transform") @NotNull Function1<? super T, ? extends Iterable<? extends R>> transform) {
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            Iterable<R> list = transform.invoke(element);
            for (R r : list) {
                result.add(r);
            }
        }
        return result;
    }

    @inline
    public static final <T, R> R fold(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="initial") R initial, @JetValueParameter(name="operation") @NotNull Function2<? super R, ? super T, ? extends R> operation) {
        R answer = initial;
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            answer = operation.invoke(answer, element);
        }
        return answer;
    }

    @inline
    @NotNull
    public static final <T> void forEach(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="operation") @NotNull Function1<? super T, ? extends Unit> operation) {
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            operation.invoke(element);
        }
    }

    @inline
    @NotNull
    public static final <T, K> Map<K, List<? extends T>> groupBy(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="toKey") @NotNull Function1<? super T, ? extends K> toKey) {
        Iterator<? extends T> iterator2 = $receiver;
        Map map = new HashMap();
        Iterator<T> iterator3 = KotlinPackage-Iterators-7137b0f2.iterator(iterator2);
        while (iterator3.hasNext()) {
            Object object2;
            Map map2 = map;
            T t = iterator3.next();
            K k = toKey.invoke(t);
            if (map2.containsKey(k)) {
                object2 = map2.get(k);
            } else {
                ArrayList arrayList = new ArrayList();
                map2.put(k, arrayList);
                object2 = arrayList;
            }
            List list = (List)object2;
            list.add(t);
        }
        return map;
    }

    @inline
    @NotNull
    public static final <T, K> Map<K, List<T>> groupByTo(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") @NotNull Map<K, List<T>> result, @JetValueParameter(name="toKey") @NotNull Function1<? super T, ? extends K> toKey) {
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext()) {
            ArrayList arrayList;
            Map<K, List<T>> map = result;
            T element = iterator2.next();
            K key = toKey.invoke(element);
            if (map.containsKey(key)) {
                arrayList = (ArrayList)map.get(key);
            } else {
                ArrayList arrayList2 = new ArrayList();
                map.put(key, arrayList2);
                arrayList = arrayList2;
            }
            List list = arrayList;
            list.add(element);
        }
        return result;
    }

    @NotNull
    public static final <T> String makeString(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="separator") @NotNull String separator, @JetValueParameter(name="prefix") @NotNull String prefix, @JetValueParameter(name="postfix") @NotNull String postfix, @JetValueParameter(name="limit") int limit, @JetValueParameter(name="truncated") @NotNull String truncated) {
        StringBuilder buffer = new StringBuilder();
        KotlinPackage-_Iterators-4fce5703.appendString($receiver, buffer, separator, prefix, postfix, limit, truncated);
        return buffer.toString();
    }

    public static String makeString$default(Iterator iterator2, String string, String string2, String string3, int n, String string4, int n2) {
        if ((n2 & 1) != 0) {
            string = ", ";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "...";
        }
        return KotlinPackage-_Iterators-4fce5703.makeString(iterator2, string, string2, string3, n, string4);
    }

    @NotNull
    public static final <T, R> Iterator<R> map(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="transform") @NotNull Function1<? super T, ? extends R> transform) {
        return new MapIterator<T, R>($receiver, transform);
    }

    @inline
    @NotNull
    public static final <T, R, C extends Collection<? super R>> C mapTo(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="transform") @NotNull Function1<? super T, ? extends R> transform) {
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            result.add(transform.invoke(item));
        }
        return result;
    }

    @Nullable
    public static final <T extends Comparable<? super T>> T max(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver) {
        if (!$receiver.hasNext()) {
            return (T)((Comparable)null);
        }
        Comparable max = (Comparable)$receiver.next();
        while ($receiver.hasNext()) {
            Comparable e = (Comparable)$receiver.next();
            if (max.compareTo(e) >= 0) continue;
            max = e;
        }
        return (T)max;
    }

    @inline
    @Nullable
    public static final <R extends Comparable<? super R>, T> T maxBy(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="f") @NotNull Function1<? super T, ? extends R> f) {
        if (!$receiver.hasNext()) {
            return null;
        }
        T maxElem = $receiver.next();
        Comparable maxValue = (Comparable)f.invoke(maxElem);
        while ($receiver.hasNext()) {
            T e = $receiver.next();
            Comparable v = (Comparable)f.invoke(e);
            if (maxValue.compareTo(v) >= 0) continue;
            maxElem = e;
            maxValue = v;
        }
        return maxElem;
    }

    @Nullable
    public static final <T extends Comparable<? super T>> T min(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver) {
        if (!$receiver.hasNext()) {
            return (T)((Comparable)null);
        }
        Comparable min = (Comparable)$receiver.next();
        while ($receiver.hasNext()) {
            Comparable e = (Comparable)$receiver.next();
            if (min.compareTo(e) <= 0) continue;
            min = e;
        }
        return (T)min;
    }

    @inline
    @Nullable
    public static final <R extends Comparable<? super R>, T> T minBy(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="f") @NotNull Function1<? super T, ? extends R> f) {
        if (!$receiver.hasNext()) {
            return null;
        }
        T minElem = $receiver.next();
        Comparable minValue = (Comparable)f.invoke(minElem);
        while ($receiver.hasNext()) {
            T e = $receiver.next();
            Comparable v = (Comparable)f.invoke(e);
            if (minValue.compareTo(v) <= 0) continue;
            minElem = e;
            minValue = v;
        }
        return minElem;
    }

    @inline
    @NotNull
    public static final <T> Pair<List<? extends T>, List<? extends T>> partition(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        ArrayList<T> first = new ArrayList<T>();
        ArrayList<T> second = new ArrayList<T>();
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            boolean bl = predicate.invoke(element) != false ? first.add(element) : second.add(element);
        }
        return new Pair<List<? extends T>, List<? extends T>>(first, second);
    }

    @NotNull
    public static final <T> Iterator<T> plus(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="collection") @NotNull Iterable<? extends T> collection) {
        return KotlinPackage-_Iterators-4fce5703.plus($receiver, collection.iterator());
    }

    @NotNull
    public static final <T> Iterator<T> plus(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="element") T element) {
        return KotlinPackage-Iterators-7137b0f2.CompositeIterator($receiver, new SingleIterator<T>(element));
    }

    @NotNull
    public static final <T> Iterator<T> plus(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="iterator") @NotNull Iterator<? extends T> iterator2) {
        return KotlinPackage-Iterators-7137b0f2.CompositeIterator($receiver, iterator2);
    }

    @inline
    public static final <T> T reduce(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="operation") @NotNull Function2<? super T, ? super T, ? extends T> operation) {
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        if (!iterator2.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced");
        }
        T result = iterator2.next();
        while (iterator2.hasNext()) {
            result = operation.invoke(result, iterator2.next());
        }
        return result;
    }

    @NotNull
    public static final <T> Iterator<T> requireNoNulls(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver) {
        return KotlinPackage-_Iterators-4fce5703.map($receiver, new KotlinPackage$requireNoNulls$1($receiver));
    }

    @NotNull
    public static final <T> List<T> reverse(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver) {
        ArrayList list = (ArrayList)KotlinPackage-_Iterators-4fce5703.toCollection($receiver, (Collection)new ArrayList());
        Collections.reverse(list);
        return list;
    }

    @inline
    @NotNull
    public static final <T, R extends Comparable<? super R>> List<T> sortBy(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="f") @NotNull Function1<? super T, ? extends R> f) {
        ArrayList sortedList = (ArrayList)KotlinPackage-_Iterators-4fce5703.toCollection($receiver, (Collection)new ArrayList());
        Comparator sortBy2 = KotlinPackage-OrderingJVM-c145938a.comparator(new KotlinPackage$sortBy$sortBy$9(f));
        Collections.sort(sortedList, sortBy2);
        return sortedList;
    }

    @NotNull
    public static final <T> Iterator<T> take(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="n") int n) {
        Ref.IntRef count = new Ref.IntRef();
        count.element = n;
        return KotlinPackage-_Iterators-4fce5703.takeWhile($receiver, new KotlinPackage$take$1(count));
    }

    @NotNull
    public static final <T> Iterator<T> takeWhile(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        return new TakeWhileIterator<T>($receiver, predicate);
    }

    @inline
    @NotNull
    public static final <T, C extends Collection<? super T>> C takeWhileTo(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result, @JetValueParameter(name="predicate") @NotNull Function1<? super T, ? extends Boolean> predicate) {
        T element;
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext() && predicate.invoke(element = iterator2.next()).booleanValue()) {
            result.add(element);
        }
        return result;
    }

    @NotNull
    public static final <T, C extends Collection<? super T>> C toCollection(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver, @JetValueParameter(name="result") @NotNull C result) {
        Iterator<T> iterator2 = KotlinPackage-Iterators-7137b0f2.iterator($receiver);
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            result.add(element);
        }
        return result;
    }

    @NotNull
    public static final <T> LinkedList<T> toLinkedList(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver) {
        return (LinkedList)KotlinPackage-_Iterators-4fce5703.toCollection($receiver, (Collection)new LinkedList());
    }

    @NotNull
    public static final <T> List<T> toList(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver) {
        return (ArrayList)KotlinPackage-_Iterators-4fce5703.toCollection($receiver, (Collection)new ArrayList());
    }

    @NotNull
    public static final <T> Set<T> toSet(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver) {
        return (LinkedHashSet)KotlinPackage-_Iterators-4fce5703.toCollection($receiver, (Collection)new LinkedHashSet());
    }

    @NotNull
    public static final <T> SortedSet<T> toSortedSet(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver) {
        return (TreeSet)KotlinPackage-_Iterators-4fce5703.toCollection($receiver, (Collection)new TreeSet());
    }

    @NotNull
    public static final <T> Iterator<Pair<? extends Integer, ? extends T>> withIndices(@JetValueParameter(name="$receiver") Iterator<? extends T> $receiver) {
        return new IndexIterator<T>(KotlinPackage-Iterators-7137b0f2.iterator($receiver));
    }
}

