/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetDeclarationImpl;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetWithExpressionInitializer;
import org.jetbrains.jet.lexer.JetTokens;

public class JetPropertyAccessor
extends JetDeclarationImpl
implements JetDeclarationWithBody,
JetModifierListOwner,
JetWithExpressionInitializer {
    public JetPropertyAccessor(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetPropertyAccessor", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetPropertyAccessor", "accept"));
        }
        return visitor.visitPropertyAccessor(this, data2);
    }

    public boolean isSetter() {
        return this.findChildByType(JetTokens.SET_KEYWORD) != null;
    }

    public boolean isGetter() {
        return this.findChildByType(JetTokens.GET_KEYWORD) != null;
    }

    @Nullable
    public JetParameter getParameter() {
        JetParameterList parameterList = (JetParameterList)this.findChildByType(JetNodeTypes.VALUE_PARAMETER_LIST);
        if (parameterList == null) {
            return null;
        }
        List<JetParameter> parameters = parameterList.getParameters();
        if (parameters.isEmpty()) {
            return null;
        }
        return parameters.get(0);
    }

    @Override
    @NotNull
    public List<JetParameter> getValueParameters() {
        JetParameter parameter = this.getParameter();
        if (parameter == null) {
            List<JetParameter> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPropertyAccessor", "getValueParameters"));
            }
            return list;
        }
        List<JetParameter> list = Collections.singletonList(parameter);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPropertyAccessor", "getValueParameters"));
        }
        return list;
    }

    @Override
    @Nullable
    public JetExpression getBodyExpression() {
        return this.findChildByClass(JetExpression.class);
    }

    @Override
    public boolean hasBlockBody() {
        return this.findChildByType(JetTokens.EQ) == null;
    }

    @Override
    public boolean hasDeclaredReturnType() {
        return true;
    }

    @Override
    @NotNull
    public JetElement asElement() {
        JetPropertyAccessor jetPropertyAccessor = this;
        if (jetPropertyAccessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPropertyAccessor", "asElement"));
        }
        return jetPropertyAccessor;
    }

    @Nullable
    public JetTypeReference getReturnTypeReference() {
        return this.findChildByClass(JetTypeReference.class);
    }

    @NotNull
    public PsiElement getNamePlaceholder() {
        PsiElement get2 = this.findChildByType(JetTokens.GET_KEYWORD);
        if (get2 != null) {
            PsiElement psiElement = get2;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPropertyAccessor", "getNamePlaceholder"));
            }
            return psiElement;
        }
        PsiElement psiElement = this.findChildByType(JetTokens.SET_KEYWORD);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetPropertyAccessor", "getNamePlaceholder"));
        }
        return psiElement;
    }

    @Override
    @Nullable
    public JetExpression getInitializer() {
        return PsiTreeUtil.getNextSiblingOfType(this.findChildByType(JetTokens.EQ), JetExpression.class);
    }
}

