/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.autocasts;

import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetRootPackageExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.JetModuleUtil;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.autocasts.Nullability;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ScriptReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class DataFlowValueFactory {
    private static final IdentifierInfo NO_IDENTIFIER_INFO = new IdentifierInfo(null, false, false){

        public String toString() {
            return "NO_IDENTIFIER_INFO";
        }
    };

    private DataFlowValueFactory() {
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull JetExpression expression, @NotNull JetType type, @NotNull BindingContext bindingContext) {
        JetConstantExpression constantExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (expression instanceof JetConstantExpression && (constantExpression = (JetConstantExpression)expression).getNode().getElementType() == JetNodeTypes.NULL) {
            DataFlowValue dataFlowValue = DataFlowValue.NULL;
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (TypeUtils.equalTypes(type, KotlinBuiltIns.getInstance().getNullableNothingType())) {
            DataFlowValue dataFlowValue = DataFlowValue.NULL;
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        IdentifierInfo result = DataFlowValueFactory.getIdForStableIdentifier(expression, bindingContext);
        DataFlowValue dataFlowValue = new DataFlowValue(result == NO_IDENTIFIER_INFO ? expression : result.id, type, result.isStable, DataFlowValueFactory.getImmanentNullability(type));
        if (dataFlowValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        return dataFlowValue;
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull ThisReceiver receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        JetType type = receiver.getType();
        DataFlowValue dataFlowValue = new DataFlowValue(receiver, type, true, DataFlowValueFactory.getImmanentNullability(type));
        if (dataFlowValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        return dataFlowValue;
    }

    @NotNull
    public static DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull BindingContext bindingContext) {
        if (receiverValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "createDataFlowValue"));
        }
        if (receiverValue instanceof TransientReceiver || receiverValue instanceof ScriptReceiver) {
            JetType type = receiverValue.getType();
            boolean nullable = type.isNullable() || TypeUtils.hasNullableSuperType(type);
            DataFlowValue dataFlowValue = new DataFlowValue(receiverValue, type, nullable, Nullability.NOT_NULL);
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (receiverValue instanceof ClassReceiver || receiverValue instanceof ExtensionReceiver) {
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue((ThisReceiver)receiverValue);
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (receiverValue instanceof ExpressionReceiver) {
            DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(((ExpressionReceiver)receiverValue).getExpression(), receiverValue.getType(), bindingContext);
            if (dataFlowValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "createDataFlowValue"));
            }
            return dataFlowValue;
        }
        if (receiverValue == ReceiverValue.NO_RECEIVER) {
            throw new IllegalArgumentException("No DataFlowValue exists for ReceiverValue.NO_RECEIVER");
        }
        throw new UnsupportedOperationException("Unsupported receiver value: " + receiverValue.getClass().getName());
    }

    @NotNull
    private static Nullability getImmanentNullability(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getImmanentNullability"));
        }
        Nullability nullability = type.isNullable() || TypeUtils.hasNullableSuperType(type) ? Nullability.UNKNOWN : Nullability.NOT_NULL;
        if (nullability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getImmanentNullability"));
        }
        return nullability;
    }

    @NotNull
    private static IdentifierInfo createInfo(Object id, boolean isStable) {
        IdentifierInfo identifierInfo = new IdentifierInfo(id, isStable, false);
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "createInfo"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo createPackageInfo(Object id) {
        IdentifierInfo identifierInfo = new IdentifierInfo(id, true, true);
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "createPackageInfo"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo combineInfo(@Nullable IdentifierInfo receiverInfo, @NotNull IdentifierInfo selectorInfo) {
        if (selectorInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorInfo", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "combineInfo"));
        }
        if (selectorInfo.id == null) {
            IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "combineInfo"));
            }
            return identifierInfo;
        }
        if (receiverInfo == null || receiverInfo == NO_IDENTIFIER_INFO || receiverInfo.isPackage) {
            IdentifierInfo identifierInfo = selectorInfo;
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "combineInfo"));
            }
            return identifierInfo;
        }
        IdentifierInfo identifierInfo = DataFlowValueFactory.createInfo(Pair.create(receiverInfo.id, selectorInfo.id), receiverInfo.isStable && selectorInfo.isStable);
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "combineInfo"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo getIdForStableIdentifier(@Nullable JetExpression expression, @NotNull BindingContext bindingContext) {
        JetExpression deparenthesized;
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getIdForStableIdentifier"));
        }
        if (expression != null && expression != (deparenthesized = JetPsiUtil.deparenthesize(expression))) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.getIdForStableIdentifier(deparenthesized, bindingContext);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        if (expression instanceof JetQualifiedExpression) {
            JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)expression;
            JetExpression receiverExpression = qualifiedExpression.getReceiverExpression();
            JetExpression selectorExpression = qualifiedExpression.getSelectorExpression();
            IdentifierInfo receiverId = DataFlowValueFactory.getIdForStableIdentifier(receiverExpression, bindingContext);
            IdentifierInfo selectorId = DataFlowValueFactory.getIdForStableIdentifier(selectorExpression, bindingContext);
            IdentifierInfo identifierInfo = DataFlowValueFactory.combineInfo(receiverId, selectorId);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        if (expression instanceof JetSimpleNameExpression) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.getIdForSimpleNameExpression((JetSimpleNameExpression)expression, bindingContext);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        if (expression instanceof JetThisExpression) {
            JetThisExpression thisExpression = (JetThisExpression)expression;
            DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, thisExpression.getInstanceReference());
            IdentifierInfo identifierInfo = DataFlowValueFactory.getIdForThisReceiver(declarationDescriptor);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        if (expression instanceof JetRootPackageExpression) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.createPackageInfo(JetModuleUtil.getRootPackageType(expression));
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getIdForStableIdentifier"));
            }
            return identifierInfo;
        }
        IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getIdForStableIdentifier"));
        }
        return identifierInfo;
    }

    @NotNull
    private static IdentifierInfo getIdForSimpleNameExpression(@NotNull JetSimpleNameExpression simpleNameExpression, @NotNull BindingContext bindingContext) {
        if (simpleNameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleNameExpression", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
        }
        DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, simpleNameExpression);
        if (declarationDescriptor instanceof VariableDescriptor) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall = bindingContext.get(BindingContext.RESOLVED_CALL, simpleNameExpression);
            IdentifierInfo receiverInfo = resolvedCall != null ? DataFlowValueFactory.getIdForImplicitReceiver(resolvedCall.getThisObject(), simpleNameExpression) : null;
            VariableDescriptor variableDescriptor = (VariableDescriptor)declarationDescriptor;
            IdentifierInfo identifierInfo = DataFlowValueFactory.combineInfo(receiverInfo, DataFlowValueFactory.createInfo(variableDescriptor, DataFlowValueFactory.isStableVariable(variableDescriptor)));
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
            }
            return identifierInfo;
        }
        if (declarationDescriptor instanceof PackageViewDescriptor) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.createPackageInfo(declarationDescriptor);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
            }
            return identifierInfo;
        }
        IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getIdForSimpleNameExpression"));
        }
        return identifierInfo;
    }

    @Nullable
    private static IdentifierInfo getIdForImplicitReceiver(@NotNull ReceiverValue receiverValue, @Nullable JetExpression expression) {
        if (receiverValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getIdForImplicitReceiver"));
        }
        if (receiverValue instanceof ThisReceiver) {
            return DataFlowValueFactory.getIdForThisReceiver(((ThisReceiver)receiverValue).getDeclarationDescriptor());
        }
        assert (!(receiverValue instanceof TransientReceiver)) : "Transient receiver is implicit for an explicit expression: " + expression + ". Receiver: " + receiverValue;
        return null;
    }

    @NotNull
    private static IdentifierInfo getIdForThisReceiver(@Nullable DeclarationDescriptor descriptorOfThisReceiver) {
        if (descriptorOfThisReceiver instanceof CallableDescriptor) {
            ReceiverParameterDescriptor receiverParameter = ((CallableDescriptor)descriptorOfThisReceiver).getReceiverParameter();
            assert (receiverParameter != null) : "'This' refers to the callable member without a receiver parameter: " + descriptorOfThisReceiver;
            IdentifierInfo identifierInfo = DataFlowValueFactory.createInfo(receiverParameter.getValue(), true);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getIdForThisReceiver"));
            }
            return identifierInfo;
        }
        if (descriptorOfThisReceiver instanceof ClassDescriptor) {
            IdentifierInfo identifierInfo = DataFlowValueFactory.createInfo(((ClassDescriptor)descriptorOfThisReceiver).getThisAsReceiverParameter().getValue(), true);
            if (identifierInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getIdForThisReceiver"));
            }
            return identifierInfo;
        }
        IdentifierInfo identifierInfo = NO_IDENTIFIER_INFO;
        if (identifierInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "getIdForThisReceiver"));
        }
        return identifierInfo;
    }

    public static boolean isStableVariable(@NotNull VariableDescriptor variableDescriptor) {
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "isStableVariable"));
        }
        if (variableDescriptor.isVar()) {
            return false;
        }
        if (variableDescriptor instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
            if (!DataFlowValueFactory.invisibleFromOtherModules(propertyDescriptor)) {
                return false;
            }
            if (!DataFlowValueFactory.isFinal(propertyDescriptor)) {
                return false;
            }
            if (!DataFlowValueFactory.hasDefaultGetter(propertyDescriptor)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isFinal(PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            if (classDescriptor.getModality().isOverridable() && propertyDescriptor.getModality().isOverridable()) {
                return false;
            }
        } else if (propertyDescriptor.getModality().isOverridable()) {
            throw new IllegalStateException("Property outside a class must not be overridable: " + propertyDescriptor.getName());
        }
        return true;
    }

    private static boolean invisibleFromOtherModules(@NotNull DeclarationDescriptorWithVisibility descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/autocasts/DataFlowValueFactory", "invisibleFromOtherModules"));
        }
        if (Visibilities.INVISIBLE_FROM_OTHER_MODULES.contains(descriptor.getVisibility())) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (!(containingDeclaration instanceof DeclarationDescriptorWithVisibility)) {
            return false;
        }
        return DataFlowValueFactory.invisibleFromOtherModules((DeclarationDescriptorWithVisibility)containingDeclaration);
    }

    private static boolean hasDefaultGetter(PropertyDescriptor propertyDescriptor) {
        PropertyGetterDescriptor getter = propertyDescriptor.getGetter();
        return getter == null || getter.isDefault();
    }

    private static class IdentifierInfo {
        public final Object id;
        public final boolean isStable;
        public final boolean isPackage;

        private IdentifierInfo(Object id, boolean isStable, boolean isPackage) {
            this.id = id;
            this.isStable = isStable;
            this.isPackage = isPackage;
        }
    }
}

