/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.extension;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.FunctionAnalyzerExtension;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.InlineUtil;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class InlineAnalyzerExtension
implements FunctionAnalyzerExtension.AnalyzerExtension {
    public static final InlineAnalyzerExtension INSTANCE = new InlineAnalyzerExtension();

    private InlineAnalyzerExtension() {
    }

    @Override
    public void process(final @NotNull FunctionDescriptor descriptor, @NotNull JetNamedFunction function, final @NotNull BindingTrace trace) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension", "process"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension", "process"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension", "process"));
        }
        assert (descriptor instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)descriptor).getInlineStrategy().isInline()) : "This method should be invoced on inline function: " + descriptor;
        InlineAnalyzerExtension.checkDefaults(descriptor, function, trace);
        InlineAnalyzerExtension.checkNotVirtual(descriptor, function, trace);
        InlineAnalyzerExtension.checkHasInlinableAndNullability(descriptor, function, trace);
        JetVisitorVoid visitor = new JetVisitorVoid(){

            @Override
            public void visitJetElement(@NotNull JetElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension$1", "visitJetElement"));
                }
                super.visitJetElement(element);
                element.acceptChildren(this);
            }

            @Override
            public void visitClass(@NotNull JetClass klass) {
                if (klass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension$1", "visitClass"));
                }
                trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on(klass, klass, descriptor));
            }

            @Override
            public void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration) {
                if (declaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension$1", "visitObjectDeclaration"));
                }
                trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on(declaration, declaration, descriptor));
            }

            @Override
            public void visitNamedFunction(@NotNull JetNamedFunction function) {
                if (function == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension$1", "visitNamedFunction"));
                }
                trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on(function, function, descriptor));
            }
        };
        function.acceptChildren(visitor);
    }

    private static void checkDefaults(@NotNull FunctionDescriptor functionDescriptor, @NotNull JetFunction function, @NotNull BindingTrace trace) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension", "checkDefaults"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension", "checkDefaults"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension", "checkDefaults"));
        }
        int index = 0;
        List<JetParameter> jetParameters = function.getValueParameters();
        for (ValueParameterDescriptor parameter : functionDescriptor.getValueParameters()) {
            if (parameter.hasDefaultValue()) {
                JetParameter jetParameter = jetParameters.get(index);
                trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on(jetParameter, jetParameter, functionDescriptor));
            }
            ++index;
        }
    }

    private static void checkNotVirtual(@NotNull FunctionDescriptor functionDescriptor, @NotNull JetFunction function, @NotNull BindingTrace trace) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension", "checkNotVirtual"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension", "checkNotVirtual"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension", "checkNotVirtual"));
        }
        if (functionDescriptor.getVisibility() == Visibilities.PRIVATE || functionDescriptor.getModality() == Modality.FINAL) {
            return;
        }
        if (functionDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor) {
            return;
        }
        trace.report(Errors.DECLARATION_CANT_BE_INLINED.on(function));
    }

    private static void checkHasInlinableAndNullability(@NotNull FunctionDescriptor functionDescriptor, @NotNull JetFunction function, @NotNull BindingTrace trace) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension", "checkHasInlinableAndNullability"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension", "checkHasInlinableAndNullability"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension", "checkHasInlinableAndNullability"));
        }
        boolean hasInlinable = false;
        List<ValueParameterDescriptor> parameters = functionDescriptor.getValueParameters();
        int index = 0;
        for (ValueParameterDescriptor parameter : parameters) {
            hasInlinable |= InlineAnalyzerExtension.checkInlinableParameter(parameter, function.getValueParameters().get(index++), functionDescriptor, trace);
        }
        ReceiverParameterDescriptor receiverParameter = functionDescriptor.getReceiverParameter();
        if (receiverParameter != null) {
            JetTypeReference receiver = function.getReceiverTypeRef();
            assert (receiver != null) : "Descriptor has a receiver but psi doesn't " + function.getText();
            hasInlinable |= InlineAnalyzerExtension.checkInlinableParameter(receiverParameter, receiver, functionDescriptor, trace);
        }
        if (!hasInlinable) {
            trace.report(Errors.NOTHING_TO_INLINE.on(function, functionDescriptor));
        }
    }

    private static boolean checkInlinableParameter(@NotNull CallableDescriptor parameter, @NotNull JetElement expression, @NotNull FunctionDescriptor functionDescriptor, @NotNull BindingTrace trace) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension", "checkInlinableParameter"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension", "checkInlinableParameter"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension", "checkInlinableParameter"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/extension/InlineAnalyzerExtension", "checkInlinableParameter"));
        }
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        JetType type = parameter.getReturnType();
        if (type != null && builtIns.isExactFunctionOrExtensionFunctionType(type) && !InlineUtil.hasNoinlineAnnotation(parameter)) {
            if (type.isNullable()) {
                trace.report(Errors.NULLABLE_INLINE_PARAMETER.on(expression, expression, functionDescriptor));
            } else {
                return true;
            }
        }
        return false;
    }
}

