/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.OrderedSet;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public final class UsageTracker {
    @Nullable
    private final ClassDescriptor trackedClassDescriptor;
    @NotNull
    private final MemberDescriptor memberDescriptor;
    @Nullable
    private List<UsageTracker> children;
    private boolean used;
    @Nullable
    private Set<CallableDescriptor> capturedVariables;
    private ClassDescriptor outerClassDescriptor;

    public UsageTracker(@NotNull MemberDescriptor memberDescriptor, @Nullable UsageTracker parent, @Nullable ClassDescriptor trackedClassDescriptor) {
        if (memberDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberDescriptor", "org/jetbrains/k2js/translate/context/UsageTracker", "<init>"));
        }
        this.memberDescriptor = memberDescriptor;
        this.trackedClassDescriptor = trackedClassDescriptor;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public boolean isUsed() {
        return this.used;
    }

    private void addChild(UsageTracker child) {
        if (this.children == null) {
            this.children = new SmartList<UsageTracker>();
        }
        this.children.add(child);
    }

    private void addCapturedMember(CallableDescriptor descriptor) {
        if (this.capturedVariables == null) {
            this.capturedVariables = new OrderedSet<CallableDescriptor>();
        }
        this.capturedVariables.add(descriptor);
    }

    public void triggerUsed(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/UsageTracker", "triggerUsed"));
        }
        if (descriptor instanceof PropertyDescriptor || descriptor instanceof PropertyAccessorDescriptor) {
            this.checkOuterClass(descriptor);
        } else if (descriptor instanceof VariableDescriptor) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor;
            if (!(this.capturedVariables != null && this.capturedVariables.contains(variableDescriptor) || UsageTracker.isAncestor(this.memberDescriptor, variableDescriptor))) {
                this.addCapturedMember(variableDescriptor);
            }
        } else if (descriptor instanceof SimpleFunctionDescriptor) {
            CallableDescriptor callableDescriptor = (CallableDescriptor)descriptor;
            if (JsDescriptorUtils.isExtension(callableDescriptor)) {
                return;
            }
            DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
            if (containingDeclaration instanceof ClassDescriptor) {
                if (this.outerClassDescriptor == null && (callableDescriptor.getExpectedThisObject() == null || UsageTracker.isAncestor(containingDeclaration, this.memberDescriptor))) {
                    this.outerClassDescriptor = (ClassDescriptor)containingDeclaration;
                }
                return;
            }
            if (!(containingDeclaration instanceof ClassOrPackageFragmentDescriptor) && !UsageTracker.isAncestor(this.memberDescriptor, descriptor)) {
                this.addCapturedMember(callableDescriptor);
            }
        } else if (descriptor instanceof ClassDescriptor && this.trackedClassDescriptor == descriptor) {
            this.used = true;
        }
    }

    private void checkOuterClass(DeclarationDescriptor descriptor) {
        DeclarationDescriptor containingDeclaration;
        if (this.outerClassDescriptor == null && (containingDeclaration = descriptor.getContainingDeclaration()) instanceof ClassDescriptor) {
            this.outerClassDescriptor = (ClassDescriptor)containingDeclaration;
        }
    }

    @Nullable
    public ClassDescriptor getOuterClassDescriptor() {
        if (this.outerClassDescriptor != null || this.children == null) {
            return this.outerClassDescriptor;
        }
        for (UsageTracker child : this.children) {
            ClassDescriptor childOuterClassDescriptor = child.getOuterClassDescriptor();
            if (childOuterClassDescriptor == null) continue;
            return childOuterClassDescriptor;
        }
        return null;
    }

    public void forEachCaptured(Consumer<CallableDescriptor> consumer) {
        this.forEachCaptured(consumer, this.memberDescriptor, this.children == null ? null : new THashSet());
    }

    private void forEachCaptured(Consumer<CallableDescriptor> consumer, MemberDescriptor requestorDescriptor, @Nullable THashSet<CallableDescriptor> visited) {
        if (this.capturedVariables != null) {
            for (CallableDescriptor callableDescriptor : this.capturedVariables) {
                if (UsageTracker.isAncestor(requestorDescriptor, callableDescriptor) || visited != null && !visited.add(callableDescriptor)) continue;
                consumer.consume(callableDescriptor);
            }
        }
        if (this.children != null) {
            for (UsageTracker child : this.children) {
                child.forEachCaptured(consumer, requestorDescriptor, visited);
            }
        }
    }

    public boolean hasCaptured() {
        if (this.capturedVariables != null) {
            assert (!this.capturedVariables.isEmpty());
            return true;
        }
        if (this.children != null) {
            for (UsageTracker child : this.children) {
                if (!child.hasCaptured()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCaptured(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/context/UsageTracker", "isCaptured"));
        }
        if (this.capturedVariables != null && this.capturedVariables.contains(descriptor)) {
            return true;
        }
        if (this.children != null) {
            for (UsageTracker child : this.children) {
                if (!child.isCaptured(descriptor)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAncestor(@NotNull DeclarationDescriptor ancestor, @NotNull DeclarationDescriptor declarationDescriptor) {
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "org/jetbrains/k2js/translate/context/UsageTracker", "isAncestor"));
        }
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/k2js/translate/context/UsageTracker", "isAncestor"));
        }
        for (DeclarationDescriptor descriptor = declarationDescriptor.getContainingDeclaration(); descriptor != null && !(descriptor instanceof PackageFragmentDescriptor); descriptor = descriptor.getContainingDeclaration()) {
            if (ancestor != descriptor) continue;
            return true;
        }
        return false;
    }
}

