/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.k2js.translate.context.AliasingContext;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.context.UsageTracker;
import org.jetbrains.k2js.translate.declaration.ClassTranslator;
import org.jetbrains.k2js.translate.expression.FunctionTranslator;
import org.jetbrains.k2js.translate.expression.InnerFunctionTranslator;
import org.jetbrains.k2js.translate.expression.InnerObjectTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public class LiteralFunctionTranslator
extends AbstractTranslator {
    private final JetDeclarationWithBody declaration;
    private final FunctionDescriptor descriptor;
    private final JsFunction jsFunction;
    private final TranslationContext functionContext;
    private final boolean inConstructorOrTopLevel;
    private final ClassDescriptor outerClass;
    private final JsName receiverName;
    private JsNameRef tempRef;

    private LiteralFunctionTranslator(@NotNull JetDeclarationWithBody declaration, @NotNull TranslationContext context) {
        AliasingContext aliasingContext;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "<init>"));
        }
        super(context);
        this.tempRef = null;
        this.declaration = declaration;
        this.descriptor = BindingUtils.getFunctionDescriptor(this.context().bindingContext(), declaration);
        DeclarationDescriptor receiverDescriptor = JsDescriptorUtils.getExpectedReceiverDescriptor(this.descriptor);
        this.jsFunction = new JsFunction(this.context().scope(), new JsBlock());
        if (receiverDescriptor == null) {
            this.receiverName = null;
            aliasingContext = null;
        } else {
            this.receiverName = this.jsFunction.getScope().declareName(Namer.getReceiverParameterName());
            aliasingContext = this.context().aliasingContext().inner(receiverDescriptor, this.receiverName.makeRef());
        }
        if (this.descriptor.getContainingDeclaration() instanceof ConstructorDescriptor) {
            this.inConstructorOrTopLevel = true;
            this.jsFunction.setName(this.jsFunction.getScope().declareName("$fun"));
            this.outerClass = (ClassDescriptor)this.descriptor.getContainingDeclaration().getContainingDeclaration();
            assert (this.outerClass != null);
            if (aliasingContext == null) {
                aliasingContext = this.context().aliasingContext();
            }
            aliasingContext = aliasingContext.notShareableThisAliased(this.outerClass, new JsNameRef("o", (JsExpression)this.jsFunction.getName().makeRef()));
        } else {
            this.outerClass = null;
            this.inConstructorOrTopLevel = DescriptorUtils.isTopLevelDeclaration(this.descriptor);
        }
        UsageTracker funTracker = new UsageTracker(this.descriptor, this.context().usageTracker(), this.outerClass);
        this.functionContext = this.context().newFunctionBody(this.jsFunction, aliasingContext, funTracker);
    }

    private void translateBody() {
        JsBlock functionBody = FunctionBodyTranslator.translateFunctionBody(this.descriptor, this.declaration, this.functionContext);
        this.jsFunction.getBody().getStatements().addAll(functionBody.getStatements());
    }

    @NotNull
    private JsExpression finish() {
        JsExpression result;
        if (this.inConstructorOrTopLevel) {
            result = this.jsFunction;
            if (this.outerClass != null) {
                UsageTracker usageTracker = this.functionContext.usageTracker();
                assert (usageTracker != null);
                if (usageTracker.isUsed()) {
                    result = new JsInvocation(this.context().namer().kotlin("assignOwner"), this.jsFunction, JsLiteral.THIS);
                } else {
                    this.jsFunction.setName(null);
                }
            }
        } else {
            JsNameRef funReference = this.context().define(LiteralFunctionTranslator.getSuggestedName(this.functionContext, this.descriptor), this.jsFunction);
            InnerFunctionTranslator innerTranslator = new InnerFunctionTranslator(this.descriptor, this.functionContext, this.jsFunction, this.tempRef);
            result = innerTranslator.translate(funReference, this.context());
        }
        LiteralFunctionTranslator.addRegularParameters(this.descriptor, this.jsFunction, this.functionContext, this.receiverName);
        JsFunction jsFunction = result;
        if (jsFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "finish"));
        }
        return jsFunction;
    }

    @NotNull
    private JsExpression translate() {
        this.translateBody();
        JsExpression jsExpression = this.finish();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        return jsExpression;
    }

    @NotNull
    public JsVars translateLocalNamedFunction() {
        JsName temp;
        JsName funName = this.functionContext.getNameForDescriptor(this.descriptor);
        JsNameRef alias = new JsNameRef("v", (JsExpression)funName.makeRef());
        this.functionContext.aliasingContext().registerAlias(this.descriptor, alias);
        this.translateBody();
        UsageTracker funTracker = this.functionContext.usageTracker();
        assert (funTracker != null);
        boolean funIsCaptured = funTracker.isCaptured(this.descriptor);
        if (funIsCaptured) {
            assert (!this.inConstructorOrTopLevel) : "A recursive closure in constructor is unsupported.";
            temp = this.context().scope().declareTemporary();
            this.tempRef = temp.makeRef();
        } else {
            temp = null;
        }
        JsExpression result = this.finish();
        SmartList<JsVars.JsVar> vars = new SmartList<JsVars.JsVar>();
        if (funIsCaptured) {
            JsVars.JsVar tempVar = new JsVars.JsVar(temp, new JsObjectLiteral());
            vars.add(tempVar);
            result = JsAstUtils.assignment(new JsNameRef("v", (JsExpression)temp.makeRef()), result);
        }
        JsVars.JsVar fun = new JsVars.JsVar(funName, result);
        vars.add(fun);
        JsVars jsVars = new JsVars(vars, false);
        if (jsVars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translateLocalNamedFunction"));
        }
        return jsVars;
    }

    private static void addRegularParameters(@NotNull FunctionDescriptor descriptor, @NotNull JsFunction fun, @NotNull TranslationContext funContext, @Nullable JsName receiverName) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "addRegularParameters"));
        }
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "addRegularParameters"));
        }
        if (funContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "funContext", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "addRegularParameters"));
        }
        if (receiverName != null) {
            fun.getParameters().add(new JsParameter(receiverName));
        }
        FunctionTranslator.addParameters(fun.getParameters(), descriptor, funContext);
    }

    private static String getSuggestedName(TranslationContext context, DeclarationDescriptor descriptor) {
        String suggestedName = "";
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration != null && !(containingDeclaration instanceof ClassOrPackageFragmentDescriptor) && !(containingDeclaration instanceof AnonymousFunctionDescriptor)) {
            suggestedName = context.getNameForDescriptor(containingDeclaration).getIdent();
        }
        if (!suggestedName.isEmpty() && !suggestedName.endsWith("$")) {
            suggestedName = suggestedName + "$";
        }
        suggestedName = descriptor.getName().isSpecial() ? suggestedName + "f" : suggestedName + context.getNameForDescriptor(descriptor).getIdent();
        return suggestedName;
    }

    @NotNull
    public static JsVars translateLocalNamedFunction(@NotNull JetDeclarationWithBody declaration, @NotNull TranslationContext outerContext) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translateLocalNamedFunction"));
        }
        if (outerContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerContext", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translateLocalNamedFunction"));
        }
        JsVars jsVars = new LiteralFunctionTranslator(declaration, outerContext).translateLocalNamedFunction();
        if (jsVars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translateLocalNamedFunction"));
        }
        return jsVars;
    }

    @NotNull
    public static JsExpression translate(@NotNull JetDeclarationWithBody declaration, @NotNull TranslationContext outerContext) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        if (outerContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerContext", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        JsExpression jsExpression = new LiteralFunctionTranslator(declaration, outerContext).translate();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translate(@NotNull ClassDescriptor outerClass, @NotNull TranslationContext outerClassContext, @NotNull JetClassOrObject declaration, @NotNull ClassDescriptor descriptor, @NotNull ClassTranslator classTranslator) {
        if (outerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerClass", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        if (outerClassContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerClassContext", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        if (classTranslator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classTranslator", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        JsFunction fun = new JsFunction(outerClassContext.scope(), new JsBlock());
        JsNameRef outerClassRef = fun.getScope().declareName("$outer").makeRef();
        UsageTracker usageTracker = new UsageTracker(descriptor, outerClassContext.usageTracker(), outerClass);
        AliasingContext aliasingContext = outerClassContext.aliasingContext().inner(outerClass, outerClassRef);
        TranslationContext funContext = outerClassContext.newFunctionBody(fun, aliasingContext, usageTracker);
        fun.getBody().getStatements().add(new JsReturn(classTranslator.translate(funContext)));
        JetClassBody body = declaration.getBody();
        assert (body != null);
        JsNameRef define = funContext.define(LiteralFunctionTranslator.getSuggestedName(funContext, descriptor), fun);
        JsExpression jsExpression = new InnerObjectTranslator(funContext, fun).translate(define, usageTracker.isUsed() ? outerClassRef : null);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/LiteralFunctionTranslator", "translate"));
        }
        return jsExpression;
    }
}

