/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Disposer {
    private static final ObjectTree<Disposable> ourTree;
    private static final ObjectTreeAction<Disposable> ourDisposeAction;
    private static boolean ourDebugMode;
    private static final Map<String, Disposable> ourKeyDisposables;

    private Disposer() {
    }

    @NotNull
    public static Disposable newDisposable() {
        Disposable disposable = new Disposable(){

            @Override
            public void dispose() {
            }
        };
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/Disposer", "newDisposable"));
        }
        return disposable;
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/Disposer", "register"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/Disposer", "register"));
        }
        Disposer.register(parent, child, null);
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child, final @NonNls @Nullable String key) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/Disposer", "register"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/Disposer", "register"));
        }
        assert (parent != child) : " Cannot register to itself";
        ourTree.register(parent, child);
        if (key != null) {
            assert (Disposer.get(key) == null);
            ourKeyDisposables.put(key, child);
            Disposer.register(child, new Disposable(){

                @Override
                public void dispose() {
                    ourKeyDisposables.remove(key);
                }
            });
        }
    }

    public static Disposable get(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/Disposer", "get"));
        }
        return ourKeyDisposables.get(key);
    }

    public static void dispose(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/Disposer", "dispose"));
        }
        Disposer.dispose(disposable, true);
    }

    public static void dispose(@NotNull Disposable disposable, boolean processUnregistered) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/Disposer", "dispose"));
        }
        ourTree.executeAll(disposable, true, ourDisposeAction, processUnregistered);
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    static {
        try {
            ourTree = new ObjectTree();
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("loader=" + Disposer.class.getClassLoader(), e);
        }
        ourDisposeAction = new ObjectTreeAction<Disposable>(){

            @Override
            public void execute(@NotNull Disposable each) {
                if (each == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/Disposer$1", "execute"));
                }
                each.dispose();
            }

            @Override
            public void beforeTreeExecution(@NotNull Disposable parent) {
                if (parent == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/Disposer$1", "beforeTreeExecution"));
                }
                if (parent instanceof Disposable.Parent) {
                    ((Disposable.Parent)parent).beforeTreeDispose();
                }
            }
        };
        ourKeyDisposables = new ConcurrentWeakHashMap<String, Disposable>();
    }
}

