/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VFileMoveEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final VirtualFile myOldParent;
    private final VirtualFile myNewParent;

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileMoveEvent", "getFile"));
        }
        return virtualFile;
    }

    public VirtualFile getNewParent() {
        return this.myNewParent;
    }

    public VirtualFile getOldParent() {
        return this.myOldParent;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[move " + this.myFile.getName() + " from " + this.myOldParent + " to " + this.myNewParent + "]";
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileMoveEvent", "getFileSystem"));
        }
        return virtualFileSystem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileMoveEvent event = (VFileMoveEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewParent.equals(event.myNewParent)) {
            return false;
        }
        return this.myOldParent.equals(event.myOldParent);
    }

    public int hashCode() {
        int result2 = this.myFile.hashCode();
        result2 = 31 * result2 + this.myOldParent.hashCode();
        result2 = 31 * result2 + this.myNewParent.hashCode();
        return result2;
    }
}

