/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiMethodStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.PsiAnnotationMethodImpl;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.AnnotationMethodElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JavaMethodElementType
extends JavaStubElementType<PsiMethodStub, PsiMethod> {
    public JavaMethodElementType(@NonNls String name) {
        super(name);
    }

    @Override
    public PsiMethod createPsi(@NotNull PsiMethodStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/java/stubs/JavaMethodElementType", "createPsi"));
        }
        return this.getPsiFactory(stub).createMethod(stub);
    }

    @Override
    public PsiMethod createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/java/stubs/JavaMethodElementType", "createPsi"));
        }
        if (node instanceof AnnotationMethodElement) {
            return new PsiAnnotationMethodImpl(node);
        }
        return new PsiMethodImpl(node);
    }

    @Override
    public PsiMethodStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String name = null;
        boolean isConstructor = true;
        boolean isVarArgs = false;
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        String defValueText = null;
        boolean expectingDef = false;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type = child.getTokenType();
            if (type == JavaDocElementType.DOC_COMMENT) {
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment(tree, child);
                continue;
            }
            if (type == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation(tree, child);
                continue;
            }
            if (type == JavaElementType.TYPE) {
                isConstructor = false;
                continue;
            }
            if (type == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (type == JavaElementType.PARAMETER_LIST) {
                LighterASTNode pType;
                List<LighterASTNode> params = LightTreeUtil.getChildrenOfType(tree, child, JavaElementType.PARAMETER);
                if (params.isEmpty() || (pType = LightTreeUtil.firstChildOfType(tree, params.get(params.size() - 1), JavaElementType.TYPE)) == null) continue;
                isVarArgs = LightTreeUtil.firstChildOfType(tree, pType, JavaTokenType.ELLIPSIS) != null;
                continue;
            }
            if (type == JavaTokenType.DEFAULT_KEYWORD) {
                expectingDef = true;
                continue;
            }
            if (!expectingDef || ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type) || type == JavaTokenType.SEMICOLON || type == JavaElementType.CODE_BLOCK) continue;
            defValueText = LightTreeUtil.toFilteredString(tree, child, null);
            break;
        }
        TypeInfo typeInfo = isConstructor ? TypeInfo.createConstructorType() : TypeInfo.create(tree, node, parentStub);
        boolean isAnno = node.getTokenType() == JavaElementType.ANNOTATION_METHOD;
        byte flags = PsiMethodStubImpl.packFlags(isConstructor, isAnno, isVarArgs, isDeprecatedByComment, hasDeprecatedAnnotation);
        return new PsiMethodStubImpl(parentStub, StringRef.fromString(name), typeInfo, flags, StringRef.fromString(defValueText));
    }

    @Override
    public void serialize(@NotNull PsiMethodStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/java/stubs/JavaMethodElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/java/stubs/JavaMethodElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE(dataStream, stub.getReturnTypeText(false));
        dataStream.writeByte(((PsiMethodStubImpl)stub).getFlags());
        if (stub.isAnnotationMethod()) {
            dataStream.writeName(stub.getDefaultValueText());
        }
    }

    @Override
    @NotNull
    public PsiMethodStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/java/stubs/JavaMethodElementType", "deserialize"));
        }
        StringRef name = dataStream.readName();
        TypeInfo type = TypeInfo.readTYPE(dataStream);
        byte flags = dataStream.readByte();
        StringRef defaultMethodValue = PsiMethodStubImpl.isAnnotationMethod(flags) ? dataStream.readName() : null;
        PsiMethodStubImpl psiMethodStubImpl = new PsiMethodStubImpl(parentStub, name, type, flags, defaultMethodValue);
        if (psiMethodStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/stubs/JavaMethodElementType", "deserialize"));
        }
        return psiMethodStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiMethodStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/java/stubs/JavaMethodElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/java/stubs/JavaMethodElementType", "indexStub"));
        }
        String name = stub.getName();
        if (name != null) {
            sink.occurrence(JavaStubIndexKeys.METHODS, name);
            if (RecordUtil.isStaticNonPrivateMember(stub)) {
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_NAMES, name);
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_TYPES, stub.getReturnTypeText(false).getShortTypeText());
            }
        }
        for (StubElement stubElement : stub.getChildrenStubs()) {
            if (!(stubElement instanceof PsiParameterListStub)) continue;
            for (StubElement paramStub : ((PsiParameterListStub)stubElement).getChildrenStubs()) {
                if (!(paramStub instanceof PsiParameterStub)) continue;
                sink.occurrence(JavaStubIndexKeys.METHOD_TYPES, ((PsiParameterStub)paramStub).getType(false).getShortTypeText());
            }
        }
    }
}

