/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.smartPointers.FileElementInfo;
import com.intellij.psi.impl.smartPointers.InjectedSelfElementInfo;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import org.jetbrains.annotations.NotNull;

class SmartPsiFileRangePointerImpl
extends SmartPsiElementPointerImpl<PsiFile>
implements SmartPsiFileRange {
    SmartPsiFileRangePointerImpl(@NotNull PsiFile containingFile, @NotNull ProperTextRange range) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "<init>"));
        }
        super(containingFile, SmartPsiFileRangePointerImpl.createElementInfo(containingFile, range), PsiFile.class);
    }

    @NotNull
    private static SmartPointerElementInfo createElementInfo(@NotNull PsiFile containingFile, @NotNull ProperTextRange range) {
        PsiLanguageInjectionHost host;
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "createElementInfo"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "createElementInfo"));
        }
        Project project = containingFile.getProject();
        if (containingFile.getViewProvider() instanceof FreeThreadedFileViewProvider && (host = InjectedLanguageManager.getInstance(project).getInjectionHost(containingFile)) != null) {
            InjectedSelfElementInfo injectedSelfElementInfo = new InjectedSelfElementInfo(project, containingFile, range, containingFile, host);
            if (injectedSelfElementInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "createElementInfo"));
            }
            return injectedSelfElementInfo;
        }
        if (range.equals(containingFile.getTextRange())) {
            FileElementInfo fileElementInfo = new FileElementInfo(containingFile);
            if (fileElementInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "createElementInfo"));
            }
            return fileElementInfo;
        }
        SelfElementInfo selfElementInfo = new SelfElementInfo(project, range, PsiElement.class, containingFile, containingFile.getLanguage());
        if (selfElementInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/SmartPsiFileRangePointerImpl", "createElementInfo"));
        }
        return selfElementInfo;
    }

    @Override
    public PsiFile getElement() {
        if (this.getRange() == null) {
            return null;
        }
        return this.getContainingFile();
    }
}

