/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.zip.ZipShort;
import gnu.trove.THashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.Nullable;
import sun.misc.Resource;

public class JarMemoryLoader {
    private final Map<String, Resource> myResources = new THashMap<String, Resource>();

    public Resource getResource(String entryName) {
        return this.myResources.remove(entryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static JarMemoryLoader load(File file, URL baseUrl) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            JarMemoryLoader loader;
            JarMemoryLoader jarMemoryLoader = loader = JarMemoryLoader.load(inputStream, baseUrl);
            return jarMemoryLoader;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static JarMemoryLoader load(InputStream inputStream, URL baseUrl) throws IOException {
        ZipInputStream zipStream = new ZipInputStream(inputStream);
        try {
            ZipEntry sizeEntry = zipStream.getNextEntry();
            if (sizeEntry == null || !sizeEntry.getName().equals("META-INF/jb/$$size$$")) {
                JarMemoryLoader jarMemoryLoader = null;
                return jarMemoryLoader;
            }
            byte[] bytes = FileUtil.loadBytes(zipStream, 2);
            int size = ZipShort.getValue(bytes);
            JarMemoryLoader loader = new JarMemoryLoader();
            for (int i = 0; i < size; ++i) {
                ZipEntry entry = zipStream.getNextEntry();
                if (entry == null) {
                    JarMemoryLoader jarMemoryLoader = loader;
                    return jarMemoryLoader;
                }
                byte[] content = FileUtil.loadBytes(zipStream, (int)entry.getSize());
                MyResource resource = new MyResource(entry.getName(), new URL(baseUrl, entry.getName()), content);
                loader.myResources.put(entry.getName(), resource);
            }
            JarMemoryLoader jarMemoryLoader = loader;
            return jarMemoryLoader;
        }
        finally {
            zipStream.close();
        }
    }

    private static class MyResource
    extends Resource {
        private String myName;
        private URL myUrl;
        private final byte[] myContent;

        public MyResource(String name, URL url, byte[] content) {
            this.myName = name;
            this.myUrl = url;
            this.myContent = content;
        }

        public String getName() {
            return this.myName;
        }

        public URL getURL() {
            return this.myUrl;
        }

        public URL getCodeSourceURL() {
            return this.myUrl;
        }

        public InputStream getInputStream() throws IOException {
            return new UnsyncByteArrayInputStream(this.myContent);
        }

        public int getContentLength() throws IOException {
            return this.myContent.length;
        }
    }
}

