/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.ClassPath;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Resource;

public class UrlClassLoader
extends ClassLoader {
    private final List<URL> myURLs;
    private final ClassPath myClassPath;

    public static Builder build() {
        return new Builder();
    }

    protected UrlClassLoader(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/lang/UrlClassLoader", "<init>"));
        }
        super(builder.myParent);
        this.myURLs = ContainerUtil.map(builder.myURLs, new Function<URL, URL>(){

            @Override
            public URL fun(URL url) {
                return UrlClassLoader.internProtocol(url);
            }
        });
        this.myClassPath = new ClassPath(this.myURLs, builder.myLockJars, builder.myUseCache, builder.myAcceptUnescaped, builder.myPreload);
    }

    public static URL internProtocol(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/lang/UrlClassLoader", "internProtocol"));
        }
        try {
            String protocol = url.getProtocol();
            if ("file".equals(protocol) || "jar".equals(protocol)) {
                return new URL(protocol.intern(), url.getHost(), url.getPort(), url.getFile());
            }
            return url;
        }
        catch (MalformedURLException e) {
            Logger.getInstance(UrlClassLoader.class).error(e);
            return null;
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Resource res = this.myClassPath.getResource(name.replace('.', '/').concat(".class"), false);
        if (res == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            return this.defineClass(name, res);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    @Nullable
    protected Class _findClass(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/lang/UrlClassLoader", "_findClass"));
        }
        Resource res = this.myClassPath.getResource(name.replace('.', '/').concat(".class"), false);
        if (res == null) {
            return null;
        }
        try {
            return this.defineClass(name, res);
        }
        catch (IOException e) {
            return null;
        }
    }

    private Class defineClass(String name, Resource res) throws IOException {
        String pkgName;
        Package pkg;
        int i = name.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgName = name.substring(0, i))) == null) {
            try {
                this.definePackage(pkgName, null, null, null, null, null, null, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        byte[] b = res.getBytes();
        return this._defineClass(name, b);
    }

    protected Class _defineClass(String name, byte[] b) {
        return this.defineClass(name, b, 0, b.length);
    }

    @Override
    @Nullable
    public URL findResource(String name) {
        return this.findResourceImpl(name);
    }

    protected URL findResourceImpl(String name) {
        Resource res = this._getResource(name);
        return res != null ? res.getURL() : null;
    }

    @Nullable
    private Resource _getResource(String name) {
        String n = name;
        if (n.startsWith("/")) {
            n = n.substring(1);
        }
        return this.myClassPath.getResource(n, true);
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(String name) {
        try {
            Resource res = this._getResource(name);
            if (res == null) {
                return null;
            }
            return res.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.myClassPath.getResources(name, true);
    }

    public static final class Builder {
        private List<URL> myURLs = ContainerUtil.emptyList();
        private ClassLoader myParent = null;
        private boolean myLockJars = false;
        private boolean myUseCache = false;
        private boolean myAcceptUnescaped = false;
        private boolean myPreload = true;

        private Builder() {
        }

        public Builder urls(List<URL> urls) {
            this.myURLs = urls;
            return this;
        }

        public Builder allowLock() {
            this.myLockJars = true;
            return this;
        }

        public Builder useCache() {
            this.myUseCache = true;
            return this;
        }
    }
}

