/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.org.objectweb.asm.Type;

public interface CallGenerator {
    public void genCall(CallableMethod var1, ResolvedCall<?> var2, int var3, ExpressionCodegen var4);

    public void afterParameterPut(Type var1, StackValue var2, ValueParameterDescriptor var3);

    public void genValueAndPut(@NotNull ValueParameterDescriptor var1, @NotNull JetExpression var2, @NotNull Type var3);

    public void putCapturedValueOnStack(@NotNull StackValue var1, @NotNull Type var2, int var3);

    public void putHiddenParams();

    public static class DefaultCallGenerator
    implements CallGenerator {
        private ExpressionCodegen codegen;

        public DefaultCallGenerator(ExpressionCodegen codegen) {
            this.codegen = codegen;
        }

        @Override
        public void genCall(CallableMethod callableMethod, ResolvedCall<?> resolvedCall, int mask, ExpressionCodegen codegen) {
            if (mask == 0) {
                callableMethod.invokeWithNotNullAssertion(codegen.v, codegen.getState(), resolvedCall);
            } else {
                callableMethod.invokeDefaultWithNotNullAssertion(codegen.v, codegen.getState(), resolvedCall, mask);
            }
        }

        @Override
        public void afterParameterPut(Type type, StackValue stackValue, ValueParameterDescriptor valueParameterDescriptor) {
        }

        @Override
        public void putHiddenParams() {
        }

        @Override
        public void genValueAndPut(@NotNull ValueParameterDescriptor valueParameterDescriptor, @NotNull JetExpression argumentExpression, @NotNull Type parameterType) {
            if (valueParameterDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "genValueAndPut"));
            }
            if (argumentExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExpression", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "genValueAndPut"));
            }
            if (parameterType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "genValueAndPut"));
            }
            StackValue value = this.codegen.gen(argumentExpression);
            value.put(parameterType, this.codegen.v);
        }

        @Override
        public void putCapturedValueOnStack(@NotNull StackValue stackValue, @NotNull Type valueType, int paramIndex) {
            if (stackValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "putCapturedValueOnStack"));
            }
            if (valueType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueType", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "putCapturedValueOnStack"));
            }
            stackValue.put(stackValue.type, this.codegen.v);
        }
    }
}

