/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AnnotationCodegen;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.DefaultParameterValueLoader;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.FunctionGenerationStrategy;
import org.jetbrains.jet.codegen.JvmSerializationBindings;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.ParentCodegenAwareImpl;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.bridges.Bridge;
import org.jetbrains.jet.codegen.bridges.BridgesPackage;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.context.PackageFacadeContext;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterSignature;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.constants.ArrayValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.JavaClassValue;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class FunctionCodegen
extends ParentCodegenAwareImpl {
    private final CodegenContext owner;
    private final ClassBuilder v;

    public FunctionCodegen(@NotNull CodegenContext owner, @NotNull ClassBuilder v, @NotNull GenerationState state, MemberCodegen<?> parentCodegen) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/codegen/FunctionCodegen", "<init>"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/FunctionCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/FunctionCodegen", "<init>"));
        }
        super(state, parentCodegen);
        this.owner = owner;
        this.v = v;
    }

    public void gen(@NotNull JetNamedFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/codegen/FunctionCodegen", "gen"));
        }
        SimpleFunctionDescriptor functionDescriptor = this.bindingContext.get(BindingContext.FUNCTION, function);
        assert (functionDescriptor != null) : "No descriptor for function " + function.getText() + "\n" + "in " + function.getContainingFile().getVirtualFile();
        OwnerKind kind = this.owner.getContextKind();
        JvmMethodSignature method = this.typeMapper.mapSignature(functionDescriptor, kind);
        if (kind != OwnerKind.TRAIT_IMPL || function.getBodyExpression() != null) {
            this.generateMethod(function, method, functionDescriptor, new FunctionGenerationStrategy.FunctionDefault(this.state, functionDescriptor, function));
        }
        this.generateDefaultIfNeeded(this.owner.intoFunction(functionDescriptor), method, functionDescriptor, kind, DefaultParameterValueLoader.DEFAULT);
    }

    public void generateMethod(@Nullable PsiElement origin, @NotNull JvmMethodSignature jvmSignature, @NotNull FunctionDescriptor functionDescriptor, @NotNull FunctionGenerationStrategy strategy) {
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        this.generateMethod(origin, jvmSignature, functionDescriptor, this.owner.intoFunction(functionDescriptor), strategy);
    }

    public void generateMethod(@Nullable PsiElement origin, @NotNull JvmMethodSignature jvmSignature, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext methodContext, @NotNull FunctionGenerationStrategy strategy) {
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (methodContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContext", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethod"));
        }
        OwnerKind methodContextKind = methodContext.getContextKind();
        Method asmMethod = jvmSignature.getAsmMethod();
        MethodVisitor mv = this.v.newMethod(origin, AsmUtil.getMethodAsmFlags(functionDescriptor, methodContextKind), asmMethod.getName(), asmMethod.getDescriptor(), jvmSignature.getGenericsSignature(), FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper));
        if (this.owner instanceof PackageFacadeContext) {
            Type ownerType = ((PackageFacadeContext)this.owner).getDelegateToClassType();
            this.v.getSerializationBindings().put(JvmSerializationBindings.IMPL_CLASS_NAME_FOR_CALLABLE, functionDescriptor, AsmUtil.shortNameByAsmType(ownerType));
        } else {
            this.v.getSerializationBindings().put(JvmSerializationBindings.METHOD_FOR_FUNCTION, functionDescriptor, asmMethod);
        }
        AnnotationCodegen.forMethod(mv, this.typeMapper).genAnnotations(functionDescriptor);
        this.generateParameterAnnotations(functionDescriptor, mv, jvmSignature);
        this.generateJetValueParameterAnnotations(mv, functionDescriptor, jvmSignature);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES || AsmUtil.isAbstractMethod(functionDescriptor, methodContextKind)) {
            FunctionCodegen.generateLocalVariableTable(mv, jvmSignature, functionDescriptor, FunctionCodegen.getThisTypeForFunction(functionDescriptor, methodContext, this.typeMapper), new Label(), new Label(), methodContextKind);
            return;
        }
        FunctionCodegen.generateMethodBody(mv, functionDescriptor, methodContext, jvmSignature, strategy, this.getParentCodegen());
        FunctionCodegen.endVisit(mv, null, origin);
        methodContext.recordSyntheticAccessorIfNeeded(functionDescriptor, this.bindingContext);
        this.generateBridges(functionDescriptor);
    }

    private void generateParameterAnnotations(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmSignature) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateParameterAnnotations"));
        }
        Iterator<ValueParameterDescriptor> iterator2 = functionDescriptor.getValueParameters().iterator();
        List<JvmMethodParameterSignature> kotlinParameterTypes = jvmSignature.getValueParameters();
        for (int i = 0; i < kotlinParameterTypes.size(); ++i) {
            JvmMethodParameterKind kind = kotlinParameterTypes.get(i).getKind();
            if (kind.isSkippedInGenericSignature()) {
                this.markEnumOrInnerConstructorParameterAsSynthetic(mv, i);
                continue;
            }
            if (kind != JvmMethodParameterKind.VALUE) continue;
            ValueParameterDescriptor parameter = iterator2.next();
            this.v.getSerializationBindings().put(JvmSerializationBindings.INDEX_FOR_VALUE_PARAMETER, parameter, i);
            AnnotationCodegen.forParameter(i, mv, this.typeMapper).genAnnotations(parameter);
        }
    }

    private void generateJetValueParameterAnnotations(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor, @NotNull JvmMethodSignature jvmSignature) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateJetValueParameterAnnotations"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateJetValueParameterAnnotations"));
        }
        if (jvmSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmSignature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateJetValueParameterAnnotations"));
        }
        Iterator<ValueParameterDescriptor> descriptors = functionDescriptor.getValueParameters().iterator();
        List<JvmMethodParameterSignature> kotlinParameterTypes = jvmSignature.getValueParameters();
        for (int i = 0; i < kotlinParameterTypes.size(); ++i) {
            boolean nullableType;
            String name;
            JvmMethodParameterKind kind = kotlinParameterTypes.get(i).getKind();
            if (kind.isSkippedInGenericSignature()) {
                this.markEnumOrInnerConstructorParameterAsSynthetic(mv, i);
                continue;
            }
            if (kind == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor descriptor = descriptors.next();
                name = descriptor.getName().asString();
                nullableType = descriptor.getType().isNullable();
            } else {
                ReceiverParameterDescriptor receiver;
                String lowercaseKind = kind.name().toLowerCase();
                name = FunctionCodegen.needIndexForVar(kind) ? "$" + lowercaseKind + "$" + i : "$" + lowercaseKind;
                nullableType = kind == JvmMethodParameterKind.RECEIVER ? (receiver = functionDescriptor.getReceiverParameter()) == null || receiver.getType().isNullable() : true;
            }
            AnnotationVisitor av = mv.visitParameterAnnotation(i, AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_JET_VALUE_PARAMETER_ANNOTATION), true);
            if (av == null) continue;
            av.visit("name", name);
            if (nullableType) {
                av.visit("type", "?");
            }
            av.visitEnd();
        }
    }

    private void markEnumOrInnerConstructorParameterAsSynthetic(MethodVisitor mv, int i) {
        if (this.state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        AnnotationVisitor av = mv.visitParameterAnnotation(i, "Ljava/lang/Synthetic;", true);
        if (av != null) {
            av.visitEnd();
        }
    }

    @Nullable
    private static Type getThisTypeForFunction(@NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context, @NotNull JetTypeMapper typeMapper) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/jet/codegen/FunctionCodegen", "getThisTypeForFunction"));
        }
        ReceiverParameterDescriptor expectedThisObject = functionDescriptor.getExpectedThisObject();
        if (functionDescriptor instanceof ConstructorDescriptor) {
            return typeMapper.mapType(functionDescriptor);
        }
        if (expectedThisObject != null) {
            return typeMapper.mapType(expectedThisObject.getType());
        }
        if (DescriptorUtils.isFunctionLiteral(functionDescriptor) || CodegenBinding.isLocalNamedFun(functionDescriptor)) {
            return typeMapper.mapType(context.getThisDescriptor());
        }
        return null;
    }

    public static void generateMethodBody(@NotNull MethodVisitor mv, @NotNull FunctionDescriptor functionDescriptor, @NotNull MethodContext context, @NotNull JvmMethodSignature signature, @NotNull FunctionGenerationStrategy strategy, @NotNull MemberCodegen<?> parentCodegen) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strategy", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        if (parentCodegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/jet/codegen/FunctionCodegen", "generateMethodBody"));
        }
        mv.visitCode();
        Label methodBegin = new Label();
        mv.visitLabel(methodBegin);
        JetTypeMapper typeMapper = parentCodegen.typeMapper;
        if (context.getParentContext() instanceof PackageFacadeContext) {
            FunctionCodegen.generateStaticDelegateMethodBody(mv, signature.getAsmMethod(), (PackageFacadeContext)context.getParentContext());
        } else {
            FrameMap frameMap = strategy.getFrameMap(typeMapper, context);
            for (ValueParameterDescriptor parameter : functionDescriptor.getValueParameters()) {
                frameMap.enter(parameter, typeMapper.mapType(parameter));
            }
            Label methodEntry = new Label();
            mv.visitLabel(methodEntry);
            context.setMethodStartLabel(methodEntry);
            if (!JetTypeMapper.isAccessor(functionDescriptor)) {
                AsmUtil.genNotNullAssertionsForParameters(new InstructionAdapter(mv), parentCodegen.state, functionDescriptor, frameMap);
            }
            strategy.generateBody(mv, signature, context, parentCodegen);
        }
        Label methodEnd = new Label();
        mv.visitLabel(methodEnd);
        Type thisType = FunctionCodegen.getThisTypeForFunction(functionDescriptor, context, typeMapper);
        FunctionCodegen.generateLocalVariableTable(mv, signature, functionDescriptor, thisType, methodBegin, methodEnd, context.getContextKind());
    }

    private static void generateLocalVariableTable(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature jvmMethodSignature, @NotNull FunctionDescriptor functionDescriptor, @Nullable Type thisType, @NotNull Label methodBegin, @NotNull Label methodEnd, @NotNull OwnerKind ownerKind) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (jvmMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmMethodSignature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (methodBegin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodBegin", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (methodEnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodEnd", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        if (ownerKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerKind", "org/jetbrains/jet/codegen/FunctionCodegen", "generateLocalVariableTable"));
        }
        Iterator<ValueParameterDescriptor> valueParameters = functionDescriptor.getValueParameters().iterator();
        List<JvmMethodParameterSignature> params = jvmMethodSignature.getValueParameters();
        int shift = 0;
        boolean isStatic = AsmUtil.isStaticMethod(ownerKind, functionDescriptor);
        if (!isStatic) {
            if (thisType != null) {
                mv.visitLocalVariable("this", thisType.getDescriptor(), null, methodBegin, methodEnd, shift);
            }
            ++shift;
        }
        for (int i = 0; i < params.size(); ++i) {
            String parameterName;
            JvmMethodParameterSignature param = params.get(i);
            JvmMethodParameterKind kind = param.getKind();
            if (kind == JvmMethodParameterKind.VALUE) {
                ValueParameterDescriptor parameter = valueParameters.next();
                parameterName = parameter.getName().asString();
            } else {
                String lowercaseKind = kind.name().toLowerCase();
                parameterName = FunctionCodegen.needIndexForVar(kind) ? "$" + lowercaseKind + "$" + i : "$" + lowercaseKind;
            }
            Type type = param.getAsmType();
            mv.visitLocalVariable(parameterName, type.getDescriptor(), null, methodBegin, methodEnd, shift);
            shift += type.getSize();
        }
    }

    private static void generateStaticDelegateMethodBody(@NotNull MethodVisitor mv, @NotNull Method asmMethod, @NotNull PackageFacadeContext context) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateStaticDelegateMethodBody"));
        }
        if (asmMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmMethod", "org/jetbrains/jet/codegen/FunctionCodegen", "generateStaticDelegateMethodBody"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/FunctionCodegen", "generateStaticDelegateMethodBody"));
        }
        InstructionAdapter iv = new InstructionAdapter(mv);
        Type[] argTypes = asmMethod.getArgumentTypes();
        Label label = new Label();
        iv.visitLabel(label);
        iv.visitLineNumber(1, label);
        int k = 0;
        for (Type argType : argTypes) {
            iv.load(k, argType);
            k += argType.getSize();
        }
        iv.invokestatic(context.getDelegateToClassType().getInternalName(), asmMethod.getName(), asmMethod.getDescriptor());
        iv.areturn(asmMethod.getReturnType());
    }

    private static boolean needIndexForVar(JvmMethodParameterKind kind) {
        return kind == JvmMethodParameterKind.CAPTURED_LOCAL_VARIABLE || kind == JvmMethodParameterKind.SUPER_OF_ANONYMOUS_CALL_PARAM;
    }

    public static void endVisit(MethodVisitor mv, @Nullable String description, @Nullable PsiElement method) {
        try {
            mv.visitMaxs(-1, -1);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            String bytecode = FunctionCodegen.renderByteCodeIfAvailable(mv);
            throw new CompilationException("wrong code generated" + (description != null ? " for " + description : "") + t.getClass().getName() + " " + t.getMessage() + (bytecode != null ? "\nbytecode:\n" + bytecode : ""), t, method);
        }
        mv.visitEnd();
    }

    private static String renderByteCodeIfAvailable(MethodVisitor mv) {
        String bytecode = null;
        if (mv instanceof TraceMethodVisitor) {
            TraceMethodVisitor traceMethodVisitor = (TraceMethodVisitor)mv;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            traceMethodVisitor.p.print(pw);
            pw.close();
            bytecode = sw.toString();
        }
        return bytecode;
    }

    public void generateBridges(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateBridges"));
        }
        if (descriptor instanceof ConstructorDescriptor) {
            return;
        }
        if (this.owner.getContextKind() == OwnerKind.TRAIT_IMPL) {
            return;
        }
        if (DescriptorUtils.isTrait(descriptor.getContainingDeclaration())) {
            return;
        }
        if (FunctionCodegen.isMethodOfAny(descriptor)) {
            return;
        }
        if (CallResolverUtil.isOrOverridesSynthesized(descriptor)) {
            return;
        }
        Set<Bridge<Method>> bridgesToGenerate = BridgesPackage.generateBridgesForFunctionDescriptor(descriptor, new Function1<FunctionDescriptor, Method>(){

            @Override
            public Method invoke(FunctionDescriptor descriptor) {
                return FunctionCodegen.this.typeMapper.mapSignature(descriptor).getAsmMethod();
            }
        });
        if (!bridgesToGenerate.isEmpty()) {
            PsiElement origin = descriptor.getKind() == CallableMemberDescriptor.Kind.DECLARATION ? BindingContextUtils.callableDescriptorToDeclaration(this.bindingContext, descriptor) : null;
            for (Bridge<Method> bridge : bridgesToGenerate) {
                this.generateBridge(origin, bridge.getFrom(), bridge.getTo());
            }
        }
    }

    private static boolean isMethodOfAny(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "isMethodOfAny"));
        }
        String name = descriptor.getName().asString();
        List<ValueParameterDescriptor> parameters = descriptor.getValueParameters();
        if (parameters.isEmpty()) {
            return name.equals("hashCode") || name.equals("toString");
        }
        if (parameters.size() == 1 && name.equals("equals")) {
            ValueParameterDescriptor parameter = parameters.get(0);
            return ((Object)parameter.getType()).equals(KotlinBuiltIns.getInstance().getNullableAnyType());
        }
        return false;
    }

    @NotNull
    private static String[] getThrownExceptions(@NotNull FunctionDescriptor function, final @NotNull JetTypeMapper mapper) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/codegen/FunctionCodegen", "getThrownExceptions"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "org/jetbrains/jet/codegen/FunctionCodegen", "getThrownExceptions"));
        }
        AnnotationDescriptor annotation = function.getAnnotations().findAnnotation(new FqName("kotlin.throws"));
        if (annotation == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionCodegen", "getThrownExceptions"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        Collection<CompileTimeConstant<?>> values = annotation.getAllValueArguments().values();
        if (values.isEmpty()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionCodegen", "getThrownExceptions"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        CompileTimeConstant<?> value = values.iterator().next();
        if (!(value instanceof ArrayValue)) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionCodegen", "getThrownExceptions"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayValue arrayValue = (ArrayValue)value;
        List strings = ContainerUtil.mapNotNull(arrayValue.getValue(), new Function<CompileTimeConstant<?>, String>(){

            @Override
            public String fun(CompileTimeConstant<?> constant) {
                if (constant instanceof JavaClassValue) {
                    JavaClassValue classValue = (JavaClassValue)constant;
                    ClassDescriptor classDescriptor = DescriptorUtils.getClassDescriptorForType(classValue.getValue());
                    return mapper.mapClass(classDescriptor).getInternalName();
                }
                return null;
            }
        });
        String[] stringArray = strings.toArray(new String[strings.size()]);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/FunctionCodegen", "getThrownExceptions"));
        }
        return stringArray;
    }

    static void generateConstructorWithoutParametersIfNeeded(@NotNull GenerationState state, @NotNull CallableMethod method, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull ClassBuilder classBuilder) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (classBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classBuilder", "org/jetbrains/jet/codegen/FunctionCodegen", "generateConstructorWithoutParametersIfNeeded"));
        }
        if (!FunctionCodegen.isDefaultConstructorNeeded(state.getBindingContext(), constructorDescriptor)) {
            return;
        }
        int flags = AsmUtil.getVisibilityAccessFlag(constructorDescriptor);
        MethodVisitor mv = classBuilder.newMethod(null, flags, "<init>", "()V", null, FunctionCodegen.getThrownExceptions(constructorDescriptor, state.getTypeMapper()));
        if (state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) {
            return;
        }
        InstructionAdapter v = new InstructionAdapter(mv);
        mv.visitCode();
        Type methodOwner = method.getOwner();
        v.load(0, methodOwner);
        int mask = 0;
        for (ValueParameterDescriptor parameterDescriptor : constructorDescriptor.getValueParameters()) {
            Type paramType = state.getTypeMapper().mapType(parameterDescriptor.getType());
            AsmUtil.pushDefaultValueOnStack(paramType, v);
            mask |= 1 << parameterDescriptor.getIndex();
        }
        v.iconst(mask);
        String desc = method.getAsmMethod().getDescriptor().replace(")", "I)");
        v.invokespecial(methodOwner.getInternalName(), "<init>", desc);
        v.areturn(Type.VOID_TYPE);
        FunctionCodegen.endVisit(mv, "default constructor for " + methodOwner.getInternalName(), null);
    }

    void generateDefaultIfNeeded(@NotNull MethodContext owner, @NotNull JvmMethodSignature signature, @NotNull FunctionDescriptor functionDescriptor, @NotNull OwnerKind kind, @NotNull DefaultParameterValueLoader loadStrategy) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        if (loadStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadStrategy", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultIfNeeded"));
        }
        DeclarationDescriptor contextClass = ((CallableMemberDescriptor)owner.getContextDescriptor()).getContainingDeclaration();
        if (kind != OwnerKind.TRAIT_IMPL && contextClass instanceof ClassDescriptor && ((ClassDescriptor)contextClass).getKind() == ClassKind.TRAIT) {
            return;
        }
        if (!FunctionCodegen.isDefaultNeeded(functionDescriptor)) {
            return;
        }
        boolean isStatic = AsmUtil.isStatic(kind);
        Method jvmSignature = signature.getAsmMethod();
        int flags = AsmUtil.getVisibilityAccessFlag(functionDescriptor) | AsmUtil.getDeprecatedAccessFlag(functionDescriptor);
        Type ownerType = this.typeMapper.mapOwner(functionDescriptor, true);
        String descriptor = jvmSignature.getDescriptor().replace(")", "I)");
        boolean isConstructor = "<init>".equals(jvmSignature.getName());
        if (!isStatic && !isConstructor) {
            descriptor = descriptor.replace("(", "(" + ownerType.getDescriptor());
        }
        MethodVisitor mv = this.v.newMethod(null, flags | (isConstructor ? 0 : 8), isConstructor ? "<init>" : jvmSignature.getName() + "$default", descriptor, null, FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper));
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            this.generateDefaultImpl(owner, signature, functionDescriptor, isStatic, mv, loadStrategy);
        }
    }

    private void generateDefaultImpl(@NotNull MethodContext methodContext, @NotNull JvmMethodSignature signature, @NotNull FunctionDescriptor functionDescriptor, boolean aStatic, @NotNull MethodVisitor mv, @NotNull DefaultParameterValueLoader loadStrategy) {
        if (methodContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContext", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImpl"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImpl"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImpl"));
        }
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImpl"));
        }
        if (loadStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadStrategy", "org/jetbrains/jet/codegen/FunctionCodegen", "generateDefaultImpl"));
        }
        mv.visitCode();
        FrameMap frameMap = new FrameMap();
        if (!aStatic) {
            frameMap.enterTemp(AsmTypeConstants.OBJECT_TYPE);
        }
        ExpressionCodegen codegen = new ExpressionCodegen(mv, frameMap, signature.getReturnType(), methodContext, this.state, this.getParentCodegen());
        Type[] argTypes = signature.getAsmMethod().getArgumentTypes();
        List<ValueParameterDescriptor> paramDescrs = functionDescriptor.getValueParameters();
        Iterator<ValueParameterDescriptor> iterator2 = paramDescrs.iterator();
        int countOfExtraVarsInMethodArgs = 0;
        for (JvmMethodParameterSignature parameterSignature : signature.getValueParameters()) {
            if (parameterSignature.getKind() != JvmMethodParameterKind.VALUE) {
                ++countOfExtraVarsInMethodArgs;
                frameMap.enterTemp(parameterSignature.getAsmType());
                continue;
            }
            frameMap.enter(iterator2.next(), parameterSignature.getAsmType());
        }
        int maskIndex = frameMap.enterTemp(Type.INT_TYPE);
        InstructionAdapter iv = new InstructionAdapter(mv);
        FunctionCodegen.loadExplicitArgumentsOnStack(iv, AsmTypeConstants.OBJECT_TYPE, aStatic, signature);
        for (int index = 0; index < paramDescrs.size(); ++index) {
            ValueParameterDescriptor parameterDescriptor = paramDescrs.get(index);
            Type t = argTypes[countOfExtraVarsInMethodArgs + index];
            if (parameterDescriptor.declaresDefaultValue()) {
                iv.load(maskIndex, Type.INT_TYPE);
                iv.iconst(1 << index);
                iv.and(Type.INT_TYPE);
                Label loadArg = new Label();
                iv.ifeq(loadArg);
                loadStrategy.putValueOnStack(parameterDescriptor, codegen);
                int ind = frameMap.getIndex(parameterDescriptor);
                iv.store(ind, t);
                iv.mark(loadArg);
            }
            iv.load(frameMap.getIndex(parameterDescriptor), t);
        }
        CallableMethod method = functionDescriptor instanceof ConstructorDescriptor ? this.typeMapper.mapToCallableMethod((ConstructorDescriptor)functionDescriptor) : this.typeMapper.mapToCallableMethod(functionDescriptor, false, methodContext);
        iv.visitMethodInsn(method.getInvokeOpcode(), method.getOwner().getInternalName(), method.getAsmMethod().getName(), method.getAsmMethod().getDescriptor());
        iv.areturn(signature.getReturnType());
        FunctionCodegen.endVisit(mv, "default method", BindingContextUtils.callableDescriptorToDeclaration(this.state.getBindingContext(), functionDescriptor));
    }

    private static void loadExplicitArgumentsOnStack(@NotNull InstructionAdapter iv, @NotNull Type ownerType, boolean isStatic, @NotNull JvmMethodSignature signature) {
        if (iv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iv", "org/jetbrains/jet/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        if (ownerType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerType", "org/jetbrains/jet/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/FunctionCodegen", "loadExplicitArgumentsOnStack"));
        }
        int var = 0;
        if (!isStatic) {
            iv.load(var, ownerType);
            var += ownerType.getSize();
        }
        for (JvmMethodParameterSignature parameterSignature : signature.getValueParameters()) {
            if (parameterSignature.getKind() == JvmMethodParameterKind.VALUE) continue;
            Type type = parameterSignature.getAsmType();
            iv.load(var, type);
            var += type.getSize();
        }
    }

    private static boolean isDefaultNeeded(FunctionDescriptor functionDescriptor) {
        boolean needed = false;
        if (functionDescriptor != null) {
            for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
                if (!parameterDescriptor.declaresDefaultValue()) continue;
                needed = true;
                break;
            }
        }
        return needed;
    }

    private static boolean isDefaultConstructorNeeded(@NotNull BindingContext context, @NotNull ConstructorDescriptor constructorDescriptor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/FunctionCodegen", "isDefaultConstructorNeeded"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/jet/codegen/FunctionCodegen", "isDefaultConstructorNeeded"));
        }
        ClassDescriptor classDescriptor = constructorDescriptor.getContainingDeclaration();
        if (CodegenBinding.canHaveOuter(context, classDescriptor)) {
            return false;
        }
        if (classDescriptor.getVisibility() == Visibilities.PRIVATE || constructorDescriptor.getVisibility() == Visibilities.PRIVATE) {
            return false;
        }
        if (constructorDescriptor.getValueParameters().isEmpty()) {
            return false;
        }
        for (ValueParameterDescriptor parameterDescriptor : constructorDescriptor.getValueParameters()) {
            if (parameterDescriptor.declaresDefaultValue()) continue;
            return false;
        }
        return true;
    }

    private void generateBridge(@Nullable PsiElement origin, @NotNull Method bridge, @NotNull Method delegateTo) {
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bridge", "org/jetbrains/jet/codegen/FunctionCodegen", "generateBridge"));
        }
        if (delegateTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateTo", "org/jetbrains/jet/codegen/FunctionCodegen", "generateBridge"));
        }
        int flags = 4161;
        MethodVisitor mv = this.v.newMethod(null, flags, delegateTo.getName(), bridge.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        mv.visitCode();
        Type[] argTypes = bridge.getArgumentTypes();
        Type[] originalArgTypes = delegateTo.getArgumentTypes();
        InstructionAdapter iv = new InstructionAdapter(mv);
        iv.load(0, AsmTypeConstants.OBJECT_TYPE);
        int reg = 1;
        for (int i = 0; i < argTypes.length; ++i) {
            StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
            reg += argTypes[i].getSize();
        }
        iv.invokevirtual(this.v.getThisName(), delegateTo.getName(), delegateTo.getDescriptor());
        StackValue.coerce(delegateTo.getReturnType(), bridge.getReturnType(), iv);
        iv.areturn(bridge.getReturnType());
        FunctionCodegen.endVisit(mv, "bridge method", origin);
    }

    public void genDelegate(FunctionDescriptor functionDescriptor, FunctionDescriptor overriddenDescriptor, StackValue field) {
        this.genDelegate(functionDescriptor, (ClassDescriptor)overriddenDescriptor.getContainingDeclaration(), field, this.typeMapper.mapSignature(functionDescriptor), this.typeMapper.mapSignature(overriddenDescriptor.getOriginal()));
    }

    public void genDelegate(FunctionDescriptor functionDescriptor, ClassDescriptor toClass, StackValue field, JvmMethodSignature jvmDelegateMethodSignature, JvmMethodSignature jvmOverriddenMethodSignature) {
        Method overriddenMethod = jvmOverriddenMethodSignature.getAsmMethod();
        Method delegateMethod = jvmDelegateMethodSignature.getAsmMethod();
        int flags = 1;
        MethodVisitor mv = this.v.newMethod(null, flags, delegateMethod.getName(), delegateMethod.getDescriptor(), null, FunctionCodegen.getThrownExceptions(functionDescriptor, this.typeMapper));
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        mv.visitCode();
        Type[] argTypes = delegateMethod.getArgumentTypes();
        Type[] originalArgTypes = overriddenMethod.getArgumentTypes();
        InstructionAdapter iv = new InstructionAdapter(mv);
        iv.load(0, AsmTypeConstants.OBJECT_TYPE);
        field.put(field.type, iv);
        int reg = 1;
        for (int i = 0; i < argTypes.length; ++i) {
            StackValue.local(reg, argTypes[i]).put(originalArgTypes[i], iv);
            reg += argTypes[i].getSize();
        }
        String internalName = this.typeMapper.mapType(toClass).getInternalName();
        if (toClass.getKind() == ClassKind.TRAIT) {
            iv.invokeinterface(internalName, overriddenMethod.getName(), overriddenMethod.getDescriptor());
        } else {
            iv.invokevirtual(internalName, overriddenMethod.getName(), overriddenMethod.getDescriptor());
        }
        StackValue.onStack(overriddenMethod.getReturnType()).put(delegateMethod.getReturnType(), iv);
        iv.areturn(delegateMethod.getReturnType());
        FunctionCodegen.endVisit(mv, "Delegate method " + functionDescriptor + " to " + jvmOverriddenMethodSignature, BindingContextUtils.descriptorToDeclaration(this.bindingContext, functionDescriptor.getContainingDeclaration()));
        this.generateBridges(functionDescriptor);
    }
}

