/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.jet.lang.reflect.ReflectionTypes;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class JvmFunctionImplTypes {
    private final ReflectionTypes reflectionTypes;
    private final ModuleDescriptor fakeModule;
    private volatile List<Functions> functionsList;
    private volatile List<KFunctions> kFunctionsList;
    private volatile Map<ClassDescriptor, ClassDescriptor> kFunctionToImplMap;

    public JvmFunctionImplTypes(@NotNull ReflectionTypes reflectionTypes) {
        if (reflectionTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reflectionTypes", "org/jetbrains/jet/codegen/JvmFunctionImplTypes", "<init>"));
        }
        this.reflectionTypes = reflectionTypes;
        this.fakeModule = new ModuleDescriptorImpl(Name.special("<fake module for functions impl>"), Collections.<ImportPath>emptyList(), JavaToKotlinClassMap.getInstance());
    }

    @NotNull
    private List<Functions> getFunctionsImplList() {
        if (this.functionsList == null) {
            MutablePackageFragmentDescriptor kotlin = new MutablePackageFragmentDescriptor(this.fakeModule, new FqName("kotlin"));
            KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
            ImmutableList.Builder<Functions> builder = ImmutableList.builder();
            for (int i = 0; i < 23; ++i) {
                builder.add(new Functions(JvmFunctionImplTypes.createFunctionImpl(kotlin, "FunctionImpl" + i, builtIns.getFunction(i)), JvmFunctionImplTypes.createFunctionImpl(kotlin, "ExtensionFunctionImpl" + i, builtIns.getExtensionFunction(i))));
            }
            this.functionsList = builder.build();
        }
        List<Functions> list = this.functionsList;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JvmFunctionImplTypes", "getFunctionsImplList"));
        }
        return list;
    }

    @NotNull
    private List<KFunctions> getKFunctionsImplList() {
        if (this.kFunctionsList == null) {
            MutablePackageFragmentDescriptor reflect = new MutablePackageFragmentDescriptor(this.fakeModule, new FqName("kotlin.reflect"));
            ImmutableList.Builder<KFunctions> builder = ImmutableList.builder();
            for (int i = 0; i < 23; ++i) {
                builder.add(new KFunctions(JvmFunctionImplTypes.createFunctionImpl(reflect, "KFunctionImpl" + i, this.reflectionTypes.getKFunction(i)), JvmFunctionImplTypes.createFunctionImpl(reflect, "KMemberFunctionImpl" + i, this.reflectionTypes.getKMemberFunction(i)), JvmFunctionImplTypes.createFunctionImpl(reflect, "KExtensionFunctionImpl" + i, this.reflectionTypes.getKExtensionFunction(i))));
            }
            this.kFunctionsList = builder.build();
        }
        List<KFunctions> list = this.kFunctionsList;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JvmFunctionImplTypes", "getKFunctionsImplList"));
        }
        return list;
    }

    @NotNull
    private Map<ClassDescriptor, ClassDescriptor> getKFunctionToImplMap() {
        if (this.kFunctionToImplMap == null) {
            ImmutableMap.Builder<ClassDescriptor, ClassDescriptor> builder = ImmutableMap.builder();
            for (int i = 0; i < 23; ++i) {
                KFunctions kFunctions = this.getKFunctionsImplList().get(i);
                builder.put(this.reflectionTypes.getKFunction(i), kFunctions.kFunctionImpl);
                builder.put(this.reflectionTypes.getKMemberFunction(i), kFunctions.kMemberFunctionImpl);
                builder.put(this.reflectionTypes.getKExtensionFunction(i), kFunctions.kExtensionFunctionImpl);
            }
            this.kFunctionToImplMap = builder.build();
        }
        Map<ClassDescriptor, ClassDescriptor> map2 = this.kFunctionToImplMap;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JvmFunctionImplTypes", "getKFunctionToImplMap"));
        }
        return map2;
    }

    @Nullable
    public ClassDescriptor kFunctionTypeToImpl(@NotNull JetType functionType) {
        if (functionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "org/jetbrains/jet/codegen/JvmFunctionImplTypes", "kFunctionTypeToImpl"));
        }
        return this.getKFunctionToImplMap().get(functionType.getConstructor().getDeclarationDescriptor());
    }

    @NotNull
    public JetType getSuperTypeForClosure(@NotNull FunctionDescriptor descriptor, boolean kFunction) {
        ClassDescriptor classDescriptor;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/JvmFunctionImplTypes", "getSuperTypeForClosure"));
        }
        int arity = descriptor.getValueParameters().size();
        ReceiverParameterDescriptor receiverParameter = descriptor.getReceiverParameter();
        ReceiverParameterDescriptor expectedThisObject = descriptor.getExpectedThisObject();
        ArrayList<TypeProjectionImpl> typeArguments = new ArrayList<TypeProjectionImpl>(arity + 2);
        if (receiverParameter != null) {
            typeArguments.add(new TypeProjectionImpl(receiverParameter.getType()));
        } else if (kFunction && expectedThisObject != null) {
            typeArguments.add(new TypeProjectionImpl(expectedThisObject.getType()));
        }
        for (ValueParameterDescriptor parameter : descriptor.getValueParameters()) {
            typeArguments.add(new TypeProjectionImpl(parameter.getType()));
        }
        typeArguments.add(new TypeProjectionImpl(descriptor.getReturnType()));
        if (kFunction) {
            KFunctions kFunctions = this.getKFunctionsImplList().get(arity);
            classDescriptor = expectedThisObject != null ? kFunctions.kMemberFunctionImpl : (receiverParameter != null ? kFunctions.kExtensionFunctionImpl : kFunctions.kFunctionImpl);
        } else {
            Functions functions2 = this.getFunctionsImplList().get(arity);
            classDescriptor = receiverParameter != null ? functions2.extensionFunctionImpl : functions2.functionImpl;
        }
        JetTypeImpl jetTypeImpl = new JetTypeImpl(classDescriptor.getDefaultType().getAnnotations(), classDescriptor.getTypeConstructor(), false, typeArguments, classDescriptor.getMemberScope(typeArguments));
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JvmFunctionImplTypes", "getSuperTypeForClosure"));
        }
        return jetTypeImpl;
    }

    @NotNull
    private static ClassDescriptor createFunctionImpl(@NotNull PackageFragmentDescriptor containingDeclaration, @NotNull String name, @NotNull ClassDescriptor functionInterface) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/codegen/JvmFunctionImplTypes", "createFunctionImpl"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/JvmFunctionImplTypes", "createFunctionImpl"));
        }
        if (functionInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionInterface", "org/jetbrains/jet/codegen/JvmFunctionImplTypes", "createFunctionImpl"));
        }
        MutableClassDescriptor functionImpl = new MutableClassDescriptor(containingDeclaration, containingDeclaration.getMemberScope(), ClassKind.CLASS, false, Name.identifier(name));
        functionImpl.setModality(Modality.FINAL);
        functionImpl.setVisibility(Visibilities.PUBLIC);
        functionImpl.setTypeParameterDescriptors(functionInterface.getDefaultType().getConstructor().getParameters());
        functionImpl.createTypeConstructor();
        MutableClassDescriptor mutableClassDescriptor = functionImpl;
        if (mutableClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JvmFunctionImplTypes", "createFunctionImpl"));
        }
        return mutableClassDescriptor;
    }

    private static class KFunctions {
        public final ClassDescriptor kFunctionImpl;
        public final ClassDescriptor kMemberFunctionImpl;
        public final ClassDescriptor kExtensionFunctionImpl;

        public KFunctions(@NotNull ClassDescriptor kFunctionImpl, @NotNull ClassDescriptor kMemberFunctionImpl, @NotNull ClassDescriptor kExtensionFunctionImpl) {
            if (kFunctionImpl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kFunctionImpl", "org/jetbrains/jet/codegen/JvmFunctionImplTypes$KFunctions", "<init>"));
            }
            if (kMemberFunctionImpl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kMemberFunctionImpl", "org/jetbrains/jet/codegen/JvmFunctionImplTypes$KFunctions", "<init>"));
            }
            if (kExtensionFunctionImpl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kExtensionFunctionImpl", "org/jetbrains/jet/codegen/JvmFunctionImplTypes$KFunctions", "<init>"));
            }
            this.kFunctionImpl = kFunctionImpl;
            this.kMemberFunctionImpl = kMemberFunctionImpl;
            this.kExtensionFunctionImpl = kExtensionFunctionImpl;
        }
    }

    private static class Functions {
        public final ClassDescriptor functionImpl;
        public final ClassDescriptor extensionFunctionImpl;

        public Functions(@NotNull ClassDescriptor functionImpl, @NotNull ClassDescriptor extensionFunctionImpl) {
            if (functionImpl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionImpl", "org/jetbrains/jet/codegen/JvmFunctionImplTypes$Functions", "<init>"));
            }
            if (extensionFunctionImpl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionFunctionImpl", "org/jetbrains/jet/codegen/JvmFunctionImplTypes$Functions", "<init>"));
            }
            this.functionImpl = functionImpl;
            this.extensionFunctionImpl = extensionFunctionImpl;
        }
    }
}

