/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.ClassBuilderOnDemand;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.FunctionGenerationStrategy;
import org.jetbrains.jet.codegen.JavaSerializerExtension;
import org.jetbrains.jet.codegen.JvmCodegenUtil;
import org.jetbrains.jet.codegen.JvmSerializationBindings;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.PackagePartCodegen;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.codegen.ScriptCodegen;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.FieldOwnerContext;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.context.PackageContext;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.config.IncrementalCompilation;
import org.jetbrains.jet.descriptors.serialization.BitEncoding;
import org.jetbrains.jet.descriptors.serialization.DescriptorSerializer;
import org.jetbrains.jet.descriptors.serialization.NameSerializationUtil;
import org.jetbrains.jet.descriptors.serialization.PackageData;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.MemberComparator;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.lazy.descriptors.LazyJavaPackageFragmentScope;
import org.jetbrains.jet.lang.resolve.kotlin.BaseDescriptorDeserializer;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class PackageCodegen {
    private final GenerationState state;
    private final ClassBuilderOnDemand v;
    private final Collection<JetFile> files;
    private final PackageFragmentDescriptor packageFragment;
    private final PackageFragmentDescriptor compiledPackageFragment;

    public PackageCodegen(@NotNull ClassBuilderOnDemand v, final @NotNull FqName fqName, @NotNull GenerationState state, @NotNull Collection<JetFile> packageFiles) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/PackageCodegen", "<init>"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/codegen/PackageCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/PackageCodegen", "<init>"));
        }
        if (packageFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFiles", "org/jetbrains/jet/codegen/PackageCodegen", "<init>"));
        }
        this.state = state;
        this.v = v;
        this.files = packageFiles;
        this.packageFragment = this.getOnlyPackageFragment();
        this.compiledPackageFragment = this.getCompiledPackageFragment();
        final PsiFile sourceFile = packageFiles.size() == 1 && this.getPreviouslyCompiledCallables().isEmpty() ? packageFiles.iterator().next().getContainingFile() : null;
        v.addOptionalDeclaration(new ClassBuilderOnDemand.ClassBuilderCallback(){

            @Override
            public void doSomething(@NotNull ClassBuilder v) {
                if (v == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/PackageCodegen$1", "doSomething"));
                }
                v.defineClass(sourceFile, 50, 17, JvmClassName.byFqNameWithoutInnerClasses(PackageClassUtils.getPackageClassFqName(fqName)).getInternalName(), null, "java/lang/Object", ArrayUtil.EMPTY_STRING_ARRAY);
                if (sourceFile != null) {
                    v.visitSource(sourceFile.getName(), null);
                }
            }
        });
    }

    @Nullable
    private PackageFragmentDescriptor getCompiledPackageFragment() {
        if (!IncrementalCompilation.ENABLED) {
            return null;
        }
        for (PackageFragmentDescriptor anotherFragment : this.packageFragment.getContainingDeclaration().getPackageFragmentProvider().getPackageFragments(this.packageFragment.getFqName())) {
            if (!(anotherFragment.getMemberScope() instanceof LazyJavaPackageFragmentScope)) continue;
            return anotherFragment;
        }
        return null;
    }

    @NotNull
    private List<DeserializedCallableMemberDescriptor> getPreviouslyCompiledCallables() {
        ArrayList<DeserializedCallableMemberDescriptor> callables = Lists.newArrayList();
        if (this.compiledPackageFragment != null) {
            for (DeclarationDescriptor member : this.compiledPackageFragment.getMemberScope().getAllDescriptors()) {
                if (!(member instanceof DeserializedCallableMemberDescriptor)) continue;
                callables.add((DeserializedCallableMemberDescriptor)member);
            }
        }
        ArrayList<DeserializedCallableMemberDescriptor> arrayList = callables;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/PackageCodegen", "getPreviouslyCompiledCallables"));
        }
        return arrayList;
    }

    private void generateDelegationsToPreviouslyCompiled(Map<CallableMemberDescriptor, Runnable> generateCallableMemberTasks) {
        for (final DeserializedCallableMemberDescriptor member : this.getPreviouslyCompiledCallables()) {
            generateCallableMemberTasks.put(member, new Runnable(){

                @Override
                public void run() {
                    FieldOwnerContext context = CodegenContext.STATIC.intoPackageFacade(Type.getObjectType(PackageCodegen.getPackagePartInternalName(member)), PackageCodegen.this.compiledPackageFragment);
                    FunctionCodegen functionCodegen = new FunctionCodegen(context, PackageCodegen.this.v.getClassBuilder(), PackageCodegen.this.state, PackageCodegen.this.getMemberCodegen(context));
                    if (member instanceof DeserializedSimpleFunctionDescriptor) {
                        DeserializedSimpleFunctionDescriptor function = (DeserializedSimpleFunctionDescriptor)member;
                        JvmMethodSignature signature = PackageCodegen.this.state.getTypeMapper().mapSignature(function, OwnerKind.PACKAGE);
                        functionCodegen.generateMethod(null, signature, function, new FunctionGenerationStrategy(){

                            @Override
                            public void generateBody(@NotNull MethodVisitor mv, @NotNull JvmMethodSignature signature, @NotNull MethodContext context, @Nullable MemberCodegen<?> parentCodegen) {
                                if (mv == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/jet/codegen/PackageCodegen$2$1", "generateBody"));
                                }
                                if (signature == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/PackageCodegen$2$1", "generateBody"));
                                }
                                if (context == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/PackageCodegen$2$1", "generateBody"));
                                }
                                throw new IllegalStateException("shouldn't be called");
                            }
                        });
                    } else if (member instanceof DeserializedPropertyDescriptor) {
                        PropertyCodegen propertyCodegen = new PropertyCodegen(context, PackageCodegen.this.v.getClassBuilder(), functionCodegen, PackageCodegen.this.getMemberCodegen(context));
                        propertyCodegen.generateInPackageFacade((DeserializedPropertyDescriptor)member);
                    } else {
                        throw new IllegalStateException("Unexpected member: " + member);
                    }
                }
            });
        }
    }

    public void generate(@NotNull CompilationErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/jet/codegen/PackageCodegen", "generate"));
        }
        ArrayList<JvmSerializationBindings> bindings = new ArrayList<JvmSerializationBindings>(this.files.size() + 1);
        boolean shouldGeneratePackageClass = PackageCodegen.shouldGeneratePackageClass(this.files);
        if (shouldGeneratePackageClass) {
            bindings.add(this.v.getClassBuilder().getSerializationBindings());
        }
        HashMap<CallableMemberDescriptor, Runnable> generateCallableMemberTasks = new HashMap<CallableMemberDescriptor, Runnable>();
        for (JetFile file : this.files) {
            try {
                ClassBuilder builder = this.generate(file, generateCallableMemberTasks);
                if (builder == null) continue;
                bindings.add(builder.getSerializationBindings());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                VirtualFile vFile = file.getVirtualFile();
                errorHandler.reportException(e, vFile == null ? "no file" : vFile.getUrl());
                DiagnosticUtils.throwIfRunningOnServer(e);
                if (!ApplicationManager.getApplication().isInternal()) continue;
                e.printStackTrace();
            }
        }
        if (shouldGeneratePackageClass) {
            this.generateDelegationsToPreviouslyCompiled(generateCallableMemberTasks);
        }
        for (CallableMemberDescriptor member : Ordering.from(MemberComparator.INSTANCE).sortedCopy(generateCallableMemberTasks.keySet())) {
            ((Runnable)generateCallableMemberTasks.get(member)).run();
        }
        if (shouldGeneratePackageClass) {
            this.writeKotlinPackageAnnotationIfNeeded(JvmSerializationBindings.union(bindings));
        }
        assert (this.v.isActivated() == shouldGeneratePackageClass) : "Different algorithms for generating package class and for heuristics for: " + this.packageFragment;
    }

    private void writeKotlinPackageAnnotationIfNeeded(@NotNull JvmSerializationBindings bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindings", "org/jetbrains/jet/codegen/PackageCodegen", "writeKotlinPackageAnnotationIfNeeded"));
        }
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        for (JetFile file : this.files) {
            if (!file.isScript()) continue;
            return;
        }
        DescriptorSerializer serializer2 = new DescriptorSerializer(new JavaSerializerExtension(bindings));
        Collection<PackageFragmentDescriptor> packageFragments = this.compiledPackageFragment == null ? Collections.singleton(this.packageFragment) : Arrays.asList(this.packageFragment, this.compiledPackageFragment);
        ProtoBuf.Package packageProto = serializer2.packageProto(packageFragments).build();
        if (packageProto.getMemberCount() == 0) {
            return;
        }
        PackageData data2 = new PackageData(NameSerializationUtil.createNameResolver(serializer2.getNameTable()), packageProto);
        AnnotationVisitor av = this.v.getClassBuilder().newAnnotation(AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_PACKAGE), true);
        av.visit("abiVersion", 15);
        AnnotationVisitor array = av.visitArray("data");
        for (String string : BitEncoding.encodeBytes(data2.toBytes())) {
            array.visit(null, string);
        }
        array.visitEnd();
        av.visitEnd();
    }

    @Nullable
    private ClassBuilder generate(@NotNull JetFile file, @NotNull Map<CallableMemberDescriptor, Runnable> generateCallableMemberTasks) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/PackageCodegen", "generate"));
        }
        if (generateCallableMemberTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generateCallableMemberTasks", "org/jetbrains/jet/codegen/PackageCodegen", "generate"));
        }
        boolean generateSrcClass = false;
        Type packagePartType = PackageCodegen.getPackagePartType(PackageClassUtils.getPackageClassFqName(this.packageFragment.getFqName()), file.getVirtualFile());
        PackageContext packagePartContext = CodegenContext.STATIC.intoPackagePart(this.packageFragment, packagePartType);
        for (JetDeclaration declaration : file.getDeclarations()) {
            if (declaration instanceof JetProperty || declaration instanceof JetNamedFunction) {
                generateSrcClass = true;
                continue;
            }
            if (declaration instanceof JetClassOrObject) {
                JetClassOrObject classOrObject = (JetClassOrObject)declaration;
                if (!this.state.getGenerateDeclaredClassFilter().shouldProcess(classOrObject)) continue;
                this.generateClassOrObject(classOrObject);
                continue;
            }
            if (!(declaration instanceof JetScript)) continue;
            ScriptCodegen.createScriptCodegen((JetScript)declaration, this.state, packagePartContext).generate();
        }
        if (!generateSrcClass) {
            return null;
        }
        ClassBuilder builder = this.state.getFactory().forPackagePart(packagePartType, file);
        new PackagePartCodegen(builder, file, packagePartType, packagePartContext, this.state).generate();
        FieldOwnerContext packageFacade = CodegenContext.STATIC.intoPackageFacade(packagePartType, this.packageFragment);
        final MemberCodegen<?> memberCodegen = this.getMemberCodegen(packageFacade);
        for (final JetDeclaration declaration : file.getDeclarations()) {
            if (!(declaration instanceof JetNamedFunction) && !(declaration instanceof JetProperty)) continue;
            DeclarationDescriptor descriptor = this.state.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
            assert (descriptor instanceof CallableMemberDescriptor) : "Expected callable member, was " + descriptor + " for " + declaration.getText();
            generateCallableMemberTasks.put((CallableMemberDescriptor)descriptor, new Runnable(){

                @Override
                public void run() {
                    memberCodegen.genFunctionOrProperty((JetTypeParameterListOwner)declaration, PackageCodegen.this.v.getClassBuilder());
                }
            });
        }
        return builder;
    }

    private MemberCodegen<?> getMemberCodegen(@NotNull FieldOwnerContext packageFacade) {
        if (packageFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFacade", "org/jetbrains/jet/codegen/PackageCodegen", "getMemberCodegen"));
        }
        return new MemberCodegen<JetFile>(this.state, null, packageFacade, null, null){

            @Override
            protected void generateDeclaration() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void generateBody() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void generateKotlinAnnotation() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @NotNull
    private PackageFragmentDescriptor getOnlyPackageFragment() {
        SmartList<PackageFragmentDescriptor> fragments = new SmartList<PackageFragmentDescriptor>();
        for (JetFile file : this.files) {
            PackageFragmentDescriptor fragment = this.state.getBindingContext().get(BindingContext.FILE_TO_PACKAGE_FRAGMENT, file);
            assert (fragment != null) : "package fragment is null for " + file;
            if (fragments.contains(fragment)) continue;
            fragments.add(fragment);
        }
        if (fragments.size() != 1) {
            throw new IllegalStateException("More than one package fragment, files: " + this.files + " | fragments: " + fragments);
        }
        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)fragments.get(0);
        if (packageFragmentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/PackageCodegen", "getOnlyPackageFragment"));
        }
        return packageFragmentDescriptor;
    }

    public void generateClassOrObject(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/codegen/PackageCodegen", "generateClassOrObject"));
        }
        JetFile file = classOrObject.getContainingJetFile();
        Type packagePartType = PackageCodegen.getPackagePartType(PackageClassUtils.getPackageClassFqName(this.packageFragment.getFqName()), file.getVirtualFile());
        PackageContext context = CodegenContext.STATIC.intoPackagePart(this.packageFragment, packagePartType);
        MemberCodegen.genClassOrObject(context, classOrObject, this.state, null);
    }

    public static boolean shouldGeneratePackageClass(@NotNull Collection<JetFile> packageFiles) {
        if (packageFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFiles", "org/jetbrains/jet/codegen/PackageCodegen", "shouldGeneratePackageClass"));
        }
        for (JetFile file : packageFiles) {
            for (JetDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof JetProperty) && !(declaration instanceof JetNamedFunction)) continue;
                return true;
            }
        }
        return false;
    }

    public void done() {
        this.v.done();
    }

    @NotNull
    public static Type getPackagePartType(@NotNull FqName facadeFqName, @NotNull VirtualFile file) {
        if (facadeFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facadeFqName", "org/jetbrains/jet/codegen/PackageCodegen", "getPackagePartType"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/PackageCodegen", "getPackagePartType"));
        }
        String fileName = FileUtil.getNameWithoutExtension(PathUtil.getFileName(file.getName()));
        String srcName = facadeFqName.shortName().asString() + "-" + PackageCodegen.replaceSpecialSymbols(fileName) + "-" + Integer.toHexString(JvmCodegenUtil.getPathHashCode(file));
        Type type = AsmUtil.asmTypeByFqNameWithoutInnerClasses(facadeFqName.parent().child(Name.identifier(srcName)));
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/PackageCodegen", "getPackagePartType"));
        }
        return type;
    }

    @NotNull
    private static String replaceSpecialSymbols(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "org/jetbrains/jet/codegen/PackageCodegen", "replaceSpecialSymbols"));
        }
        String string = str.replace('.', '_');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/PackageCodegen", "replaceSpecialSymbols"));
        }
        return string;
    }

    @NotNull
    public static String getPackagePartInternalName(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/PackageCodegen", "getPackagePartInternalName"));
        }
        FqName packageFqName = file.getPackageFqName();
        String string = PackageCodegen.getPackagePartType(PackageClassUtils.getPackageClassFqName(packageFqName), file.getVirtualFile()).getInternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/PackageCodegen", "getPackagePartInternalName"));
        }
        return string;
    }

    @NotNull
    public static String getPackagePartInternalName(@NotNull DeserializedCallableMemberDescriptor callable2) {
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/codegen/PackageCodegen", "getPackagePartInternalName"));
        }
        FqName packageFqName = ((PackageFragmentDescriptor)callable2.getContainingDeclaration()).getFqName();
        FqName packagePartFqName = packageFqName.child(BaseDescriptorDeserializer.getPackagePartClassName(callable2));
        String string = JvmClassName.byFqNameWithoutInnerClasses(packagePartFqName).getInternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/PackageCodegen", "getPackagePartInternalName"));
        }
        return string;
    }
}

