/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.JetElementInstructionImpl;
import org.jetbrains.jet.lang.cfg.pseudocode.JumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.LexicalScope;
import org.jetbrains.jet.lang.psi.JetElement;

public abstract class AbstractJumpInstruction
extends JetElementInstructionImpl
implements JumpInstruction {
    private final Label targetLabel;
    private Instruction resolvedTarget;

    public AbstractJumpInstruction(@NotNull JetElement element, Label targetLabel, LexicalScope lexicalScope) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/pseudocode/AbstractJumpInstruction", "<init>"));
        }
        super(element, lexicalScope);
        this.targetLabel = targetLabel;
    }

    public Label getTargetLabel() {
        return this.targetLabel;
    }

    public Instruction getResolvedTarget() {
        return this.resolvedTarget;
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        Set<Instruction> set = Collections.singleton(this.getResolvedTarget());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/AbstractJumpInstruction", "getNextInstructions"));
        }
        return set;
    }

    public void setResolvedTarget(Instruction resolvedTarget) {
        this.resolvedTarget = this.outgoingEdgeTo(resolvedTarget);
    }

    protected abstract AbstractJumpInstruction createCopy(@NotNull Label var1, @NotNull LexicalScope var2);

    public final Instruction copy(@NotNull Label newLabel) {
        if (newLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLabel", "org/jetbrains/jet/lang/cfg/pseudocode/AbstractJumpInstruction", "copy"));
        }
        return this.updateCopyInfo(this.createCopy(newLabel, this.lexicalScope));
    }

    @Override
    @NotNull
    protected Instruction createCopy() {
        AbstractJumpInstruction abstractJumpInstruction = this.createCopy(this.targetLabel, this.lexicalScope);
        if (abstractJumpInstruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/AbstractJumpInstruction", "createCopy"));
        }
        return abstractJumpInstruction;
    }
}

