/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionImpl;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitorWithResult;
import org.jetbrains.jet.lang.cfg.pseudocode.LexicalScope;
import org.jetbrains.jet.lang.psi.JetElement;

public class SubroutineSinkInstruction
extends InstructionImpl {
    private final JetElement subroutine;
    private final String debugLabel;

    public SubroutineSinkInstruction(@NotNull JetElement subroutine, @NotNull LexicalScope lexicalScope, @NotNull String debugLabel) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineSinkInstruction", "<init>"));
        }
        if (lexicalScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexicalScope", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineSinkInstruction", "<init>"));
        }
        if (debugLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugLabel", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineSinkInstruction", "<init>"));
        }
        super(lexicalScope);
        this.subroutine = subroutine;
        this.debugLabel = debugLabel;
    }

    public JetElement getSubroutine() {
        return this.subroutine;
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        List<Instruction> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineSinkInstruction", "getNextInstructions"));
        }
        return list;
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineSinkInstruction", "accept"));
        }
        visitor.visitSubroutineSink(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<R> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineSinkInstruction", "accept"));
        }
        return visitor.visitSubroutineSink(this);
    }

    public String toString() {
        return this.debugLabel;
    }

    @Override
    @NotNull
    protected Instruction createCopy() {
        SubroutineSinkInstruction subroutineSinkInstruction = new SubroutineSinkInstruction(this.subroutine, this.lexicalScope, this.debugLabel);
        if (subroutineSinkInstruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineSinkInstruction", "createCopy"));
        }
        return subroutineSinkInstruction;
    }
}

