/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeConstructorImpl;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.renderer.DescriptorRenderer;
import org.jetbrains.jet.storage.LockBasedStorageManager;

public class TypeParameterDescriptorImpl
extends DeclarationDescriptorNonRootImpl
implements TypeParameterDescriptor {
    private final int index;
    private final Variance variance;
    private final Set<JetType> upperBounds;
    private JetType upperBoundsAsType;
    private final TypeConstructor typeConstructor;
    private JetType defaultType;
    private final Set<JetType> classObjectUpperBounds;
    private JetType classObjectBoundsAsType;
    private final boolean reified;
    private boolean initialized;

    public static TypeParameterDescriptor createWithDefaultBound(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations, boolean reified, @NotNull Variance variance, @NotNull Name name, int index) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "createWithDefaultBound"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "createWithDefaultBound"));
        }
        if (variance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variance", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "createWithDefaultBound"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "createWithDefaultBound"));
        }
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDeclaration, annotations, reified, variance, name, index);
        typeParameterDescriptor.addUpperBound(KotlinBuiltIns.getInstance().getDefaultBound());
        typeParameterDescriptor.setInitialized();
        return typeParameterDescriptor;
    }

    public static TypeParameterDescriptorImpl createForFurtherModification(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations, boolean reified, @NotNull Variance variance, @NotNull Name name, int index) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "createForFurtherModification"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "createForFurtherModification"));
        }
        if (variance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variance", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "createForFurtherModification"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "createForFurtherModification"));
        }
        return new TypeParameterDescriptorImpl(containingDeclaration, annotations, reified, variance, name, index);
    }

    private TypeParameterDescriptorImpl(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations, boolean reified, @NotNull Variance variance, @NotNull Name name, int index) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "<init>"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "<init>"));
        }
        if (variance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variance", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "<init>"));
        }
        super(containingDeclaration, annotations, name);
        this.classObjectUpperBounds = Sets.newLinkedHashSet();
        this.initialized = false;
        this.index = index;
        this.variance = variance;
        this.upperBounds = Sets.newLinkedHashSet();
        this.reified = reified;
        this.typeConstructor = new TypeConstructorImpl(this, annotations, false, name.asString(), Collections.emptyList(), this.upperBounds);
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Type parameter descriptor is not initialized: " + this.nameForAssertions());
        }
    }

    private void checkUninitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Type parameter descriptor is already initialized: " + this.nameForAssertions());
        }
    }

    private String nameForAssertions() {
        return this.getName() + " declared in " + DescriptorUtils.getFqName(this.getContainingDeclaration());
    }

    public void setInitialized() {
        this.checkUninitialized();
        this.initialized = true;
    }

    @Override
    public boolean isReified() {
        this.checkInitialized();
        return this.reified;
    }

    @Override
    @NotNull
    public Variance getVariance() {
        Variance variance = this.variance;
        if (variance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "getVariance"));
        }
        return variance;
    }

    public void addUpperBound(@NotNull JetType bound) {
        if (bound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bound", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "addUpperBound"));
        }
        this.checkUninitialized();
        this.doAddUpperBound(bound);
    }

    private void doAddUpperBound(JetType bound) {
        this.upperBounds.add(bound);
    }

    public void addDefaultUpperBound() {
        this.checkUninitialized();
        if (this.upperBounds.isEmpty()) {
            this.doAddUpperBound(KotlinBuiltIns.getInstance().getDefaultBound());
        }
    }

    @Override
    @NotNull
    public Set<JetType> getUpperBounds() {
        this.checkInitialized();
        Set<JetType> set = this.upperBounds;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "getUpperBounds"));
        }
        return set;
    }

    @Override
    @NotNull
    public JetType getUpperBoundsAsType() {
        this.checkInitialized();
        if (this.upperBoundsAsType == null) {
            assert (this.upperBounds != null) : "Upper bound list is null in " + this.getName();
            assert (this.upperBounds.size() > 0) : "Upper bound list is empty in " + this.getName();
            this.upperBoundsAsType = TypeUtils.intersect(JetTypeChecker.INSTANCE, this.upperBounds);
            if (this.upperBoundsAsType == null) {
                this.upperBoundsAsType = KotlinBuiltIns.getInstance().getNothingType();
            }
        }
        JetType jetType = this.upperBoundsAsType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "getUpperBoundsAsType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public Set<JetType> getLowerBounds() {
        Set<JetType> set = Collections.singleton(KotlinBuiltIns.getInstance().getNothingType());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "getLowerBounds"));
        }
        return set;
    }

    @Override
    @NotNull
    public JetType getLowerBoundsAsType() {
        this.checkInitialized();
        JetType jetType = KotlinBuiltIns.getInstance().getNothingType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "getLowerBoundsAsType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        TypeConstructor typeConstructor = this.typeConstructor;
        if (typeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "getTypeConstructor"));
        }
        return typeConstructor;
    }

    @Override
    public String toString() {
        try {
            return DescriptorRenderer.FQ_NAMES_IN_TYPES.render(this);
        }
        catch (Exception e) {
            return this.getClass().getName() + "@" + System.identityHashCode(this);
        }
    }

    @Override
    @Deprecated
    @NotNull
    public TypeParameterDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "substitute"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        this.checkInitialized();
        return visitor.visitTypeParameterDescriptor(this, data2);
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        if (this.defaultType == null) {
            this.defaultType = new JetTypeImpl(Annotations.EMPTY, this.getTypeConstructor(), TypeUtils.hasNullableLowerBound(this), Collections.emptyList(), new LazyScopeAdapter(LockBasedStorageManager.NO_LOCKS.createLazyValue(new Function0<JetScope>(){

                @Override
                public JetScope invoke() {
                    return TypeParameterDescriptorImpl.this.getUpperBoundsAsType().getMemberScope();
                }
            })));
        }
        JetType jetType = this.defaultType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "getDefaultType"));
        }
        return jetType;
    }

    @Override
    public JetType getClassObjectType() {
        this.checkInitialized();
        if (this.classObjectUpperBounds.isEmpty()) {
            return null;
        }
        if (this.classObjectBoundsAsType == null) {
            this.classObjectBoundsAsType = TypeUtils.intersect(JetTypeChecker.INSTANCE, this.classObjectUpperBounds);
            if (this.classObjectBoundsAsType == null) {
                this.classObjectBoundsAsType = KotlinBuiltIns.getInstance().getNothingType();
            }
        }
        return this.classObjectBoundsAsType;
    }

    public void addClassObjectBound(@NotNull JetType bound) {
        if (bound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bound", "org/jetbrains/jet/lang/descriptors/impl/TypeParameterDescriptorImpl", "addClassObjectBound"));
        }
        this.checkUninitialized();
        this.classObjectUpperBounds.add(bound);
    }

    @Override
    public int getIndex() {
        this.checkInitialized();
        return this.index;
    }
}

