/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetDeclarationImpl;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetStatementExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lexer.JetTokens;

public class JetClassObject
extends JetDeclarationImpl
implements JetStatementExpression {
    public JetClassObject(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetClassObject", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetClassObject", "accept"));
        }
        return visitor.visitClassObject(this, data2);
    }

    @NotNull
    public JetObjectDeclaration getObjectDeclaration() {
        JetObjectDeclaration objectDeclaration = (JetObjectDeclaration)this.findChildByType(JetNodeTypes.OBJECT_DECLARATION);
        assert (objectDeclaration != null) : String.format("It should be impossible to produce class object element without object child:\n %s", this.getParent().getText());
        JetObjectDeclaration jetObjectDeclaration = objectDeclaration;
        if (jetObjectDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetClassObject", "getObjectDeclaration"));
        }
        return jetObjectDeclaration;
    }

    @IfNotParsed
    @Nullable
    public PsiElement getClassKeywordNode() {
        ASTNode keywordNode = this.getNode().findChildByType(JetTokens.CLASS_KEYWORD);
        return keywordNode != null ? keywordNode.getPsi() : null;
    }
}

