/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationContainer;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetImportList;
import org.jetbrains.jet.lang.psi.JetPackageDirective;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetTreeVisitor;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.stubs.PsiJetFileStub;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.plugin.JetFileType;
import org.jetbrains.jet.plugin.JetLanguage;

public class JetFile
extends PsiFileBase
implements PsiClassOwner,
JetDeclarationContainer,
JetElement {
    private final boolean isCompiled;

    public JetFile(FileViewProvider viewProvider, boolean compiled) {
        super(viewProvider, JetLanguage.INSTANCE);
        this.isCompiled = compiled;
    }

    @Override
    public FileASTNode getNode() {
        return super.getNode();
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        JetFileType jetFileType = JetFileType.INSTANCE;
        if (jetFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFile", "getFileType"));
        }
        return jetFileType;
    }

    @Override
    public String toString() {
        return "JetFile: " + this.getName();
    }

    @Override
    @NotNull
    public List<JetDeclaration> getDeclarations() {
        List<JetDeclaration> list = PsiTreeUtil.getChildrenOfTypeAsList(this, JetDeclaration.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFile", "getDeclarations"));
        }
        return list;
    }

    @Nullable
    public JetImportList getImportList() {
        return this.findChildByClass(JetImportList.class);
    }

    @NotNull
    public List<JetImportDirective> getImportDirectives() {
        JetImportList importList = this.getImportList();
        List<JetImportDirective> list = importList != null ? importList.getImports() : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFile", "getImportDirectives"));
        }
        return list;
    }

    @Nullable
    public JetImportDirective findImportByAlias(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/psi/JetFile", "findImportByAlias"));
        }
        for (JetImportDirective directive : this.getImportDirectives()) {
            if (!name.equals(directive.getAliasName())) continue;
            return directive;
        }
        return null;
    }

    @Nullable
    public JetPackageDirective getPackageDirective() {
        ASTNode ast = this.getNode().findChildByType(JetNodeTypes.PACKAGE_DIRECTIVE);
        return ast != null ? (JetPackageDirective)ast.getPsi() : null;
    }

    @Override
    @Deprecated
    @NotNull
    public String getPackageName() {
        String string = this.getPackageFqName().asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFile", "getPackageName"));
        }
        return string;
    }

    @NotNull
    public FqName getPackageFqName() {
        PsiJetFileStub stub = (PsiJetFileStub)this.getStub();
        if (stub != null) {
            FqName fqName = stub.getPackageFqName();
            if (fqName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFile", "getPackageFqName"));
            }
            return fqName;
        }
        JetPackageDirective packageDirective = this.getPackageDirective();
        if (packageDirective == null) {
            FqName fqName = FqName.ROOT;
            if (fqName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFile", "getPackageFqName"));
            }
            return fqName;
        }
        FqName fqName = packageDirective.getFqName();
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFile", "getPackageFqName"));
        }
        return fqName;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFile", "getClasses"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Override
    public void setPackageName(String packageName) {
    }

    @Nullable
    public JetScript getScript() {
        return PsiTreeUtil.getChildOfType(this, JetScript.class);
    }

    public boolean isScript() {
        PsiJetFileStub stub = (PsiJetFileStub)this.getStub();
        if (stub != null) {
            return stub.isScript();
        }
        return this.getScript() != null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = super.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFile", "getName"));
        }
        return string;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetFile", "accept"));
        }
        if (visitor instanceof JetVisitor) {
            this.accept((JetVisitor)visitor, null);
        } else {
            visitor.visitFile(this);
        }
    }

    @Override
    @NotNull
    public JetFile getContainingJetFile() {
        JetFile jetFile = this;
        if (jetFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetFile", "getContainingJetFile"));
        }
        return jetFile;
    }

    @Override
    public <D> void acceptChildren(@NotNull JetTreeVisitor<D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetFile", "acceptChildren"));
        }
        JetPsiUtil.visitChildren(this, visitor, data2);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetFile", "accept"));
        }
        return visitor.visitJetFile(this, data2);
    }
}

