/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.stubs.PsiJetPropertyStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class PsiJetPropertyStubImpl
extends StubBase<JetProperty>
implements PsiJetPropertyStub {
    private final StringRef name;
    private final boolean isVar;
    private final boolean isTopLevel;
    private final FqName fqName;
    private final StringRef typeText;
    private final StringRef inferenceBodyText;

    public PsiJetPropertyStubImpl(StubElement parent, StringRef name, boolean isVar, boolean isTopLevel, @Nullable FqName fqName, StringRef typeText, StringRef inferenceBodyText) {
        super(parent, JetStubElementTypes.PROPERTY);
        if (isTopLevel && fqName == null) {
            throw new IllegalArgumentException("fqName shouldn't be null for top level properties");
        }
        this.name = name;
        this.isVar = isVar;
        this.isTopLevel = isTopLevel;
        this.fqName = fqName;
        this.typeText = typeText;
        this.inferenceBodyText = inferenceBodyText;
    }

    public PsiJetPropertyStubImpl(StubElement parent, String name, boolean isVar, boolean isTopLevel, @Nullable FqName topFQName, String typeText, String inferenceBodyText) {
        this(parent, StringRef.fromString(name), isVar, isTopLevel, topFQName, StringRef.fromString(typeText), StringRef.fromString(inferenceBodyText));
    }

    @Override
    public boolean isVar() {
        return this.isVar;
    }

    @Override
    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    @Override
    @Nullable
    public FqName getFqName() {
        return this.fqName;
    }

    @Override
    public String getTypeText() {
        return StringRef.toString(this.typeText);
    }

    @Override
    public String getInferenceBodyText() {
        return StringRef.toString(this.inferenceBodyText);
    }

    @Override
    public String getName() {
        return StringRef.toString(this.name);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiJetPropertyStubImpl[");
        builder.append(this.isVar() ? "var " : "val ");
        if (this.isTopLevel()) {
            assert (this.fqName != null);
            builder.append("top ").append("fqName=").append(this.fqName.toString()).append(" ");
        }
        builder.append("name=").append(this.getName());
        builder.append(" typeText=").append(this.getTypeText());
        builder.append(" bodyText=").append(this.getInferenceBodyText());
        builder.append("]");
        return builder.toString();
    }
}

