/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.analyzer.AnalyzerFacade;
import org.jetbrains.jet.context.ContextPackage;
import org.jetbrains.jet.context.GlobalContextImpl;
import org.jetbrains.jet.descriptors.serialization.descriptors.MemberFilter;
import org.jetbrains.jet.di.InjectorForLazyResolveWithJava;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerForJvm;
import org.jetbrains.jet.lang.descriptors.DependencyKind;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.lazy.declarations.DeclarationProviderFactoryService;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public enum AnalyzerFacadeForJVM implements AnalyzerFacade
{
    INSTANCE;

    public static final List<ImportPath> DEFAULT_IMPORTS;

    @Override
    @NotNull
    public JvmSetup createSetup(@NotNull Project fileProject, @NotNull Collection<JetFile> files) {
        if (fileProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileProject", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createSetup"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createSetup"));
        }
        JvmSetup jvmSetup = AnalyzerFacadeForJVM.createSetup(fileProject, files, new BindingTraceContext(), true);
        if (jvmSetup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createSetup"));
        }
        return jvmSetup;
    }

    @NotNull
    public static ResolveSession createLazyResolveSession(@NotNull Project project, @NotNull Collection<JetFile> files, @NotNull BindingTrace trace, boolean addBuiltIns) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createLazyResolveSession"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createLazyResolveSession"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createLazyResolveSession"));
        }
        ResolveSession resolveSession = AnalyzerFacadeForJVM.createSetup(project, files, trace, addBuiltIns).getLazyResolveSession();
        if (resolveSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createLazyResolveSession"));
        }
        return resolveSession;
    }

    private static JvmSetup createSetup(Project project, Collection<JetFile> files, BindingTrace trace, boolean addBuiltIns) {
        GlobalContextImpl globalContext = ContextPackage.GlobalContext();
        DeclarationProviderFactory declarationProviderFactory = DeclarationProviderFactoryService.createDeclarationProviderFactory(project, globalContext.getStorageManager(), files);
        InjectorForLazyResolveWithJava resolveWithJava = new InjectorForLazyResolveWithJava(project, globalContext, declarationProviderFactory, trace);
        resolveWithJava.getModule().addFragmentProvider(DependencyKind.BINARIES, resolveWithJava.getJavaDescriptorResolver().getPackageFragmentProvider());
        if (addBuiltIns) {
            resolveWithJava.getModule().addFragmentProvider(DependencyKind.BUILT_INS, KotlinBuiltIns.getInstance().getBuiltInsModule().getPackageFragmentProvider());
        }
        return new JvmSetup(resolveWithJava.getResolveSession(), resolveWithJava.getJavaDescriptorResolver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static AnalyzeExhaust analyzeFilesWithJavaIntegration(Project project, Collection<JetFile> files, BindingTrace trace, Predicate<PsiFile> filesToAnalyzeCompletely, ModuleDescriptorImpl module, MemberFilter memberFilter2) {
        GlobalContextImpl globalContext = ContextPackage.GlobalContext();
        TopDownAnalysisParameters topDownAnalysisParameters = TopDownAnalysisParameters.create(globalContext.getStorageManager(), globalContext.getExceptionTracker(), filesToAnalyzeCompletely, false, false);
        InjectorForTopDownAnalyzerForJvm injector = new InjectorForTopDownAnalyzerForJvm(project, topDownAnalysisParameters, trace, module, memberFilter2);
        module.addFragmentProvider(DependencyKind.BINARIES, injector.getJavaDescriptorResolver().getPackageFragmentProvider());
        injector.getTopDownAnalyzer().analyzeFiles(topDownAnalysisParameters, files);
        AnalyzeExhaust analyzeExhaust = AnalyzeExhaust.success(trace.getBindingContext(), module);
        AnalyzeExhaust analyzeExhaust2 = analyzeExhaust;
        if (analyzeExhaust2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        return analyzeExhaust2;
        finally {
            injector.destroy();
        }
    }

    @NotNull
    public static ModuleDescriptorImpl createJavaModule(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createJavaModule"));
        }
        ModuleDescriptorImpl moduleDescriptorImpl = new ModuleDescriptorImpl(Name.special(name), DEFAULT_IMPORTS, JavaToKotlinClassMap.getInstance());
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createJavaModule"));
        }
        return moduleDescriptorImpl;
    }

    static {
        DEFAULT_IMPORTS = ImmutableList.of(new ImportPath("java.lang.*"), new ImportPath("kotlin.*"), new ImportPath("kotlin.io.*"));
    }

    public static class JvmSetup
    extends AnalyzerFacade.BasicSetup {
        private final JavaDescriptorResolver javaDescriptorResolver;

        public JvmSetup(@NotNull ResolveSession session, @NotNull JavaDescriptorResolver javaDescriptorResolver) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM$JvmSetup", "<init>"));
            }
            if (javaDescriptorResolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaDescriptorResolver", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM$JvmSetup", "<init>"));
            }
            super(session);
            this.javaDescriptorResolver = javaDescriptorResolver;
        }

        @NotNull
        public JavaDescriptorResolver getJavaDescriptorResolver() {
            JavaDescriptorResolver javaDescriptorResolver = this.javaDescriptorResolver;
            if (javaDescriptorResolver == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM$JvmSetup", "getJavaDescriptorResolver"));
            }
            return javaDescriptorResolver;
        }
    }
}

