/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeParameter;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeSubstitutor;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaTypeParameterImpl;

public class JavaTypeSubstitutorImpl
implements JavaTypeSubstitutor {
    private final PsiSubstitutor psiSubstitutor;
    private Map<JavaTypeParameter, JavaType> substitutionMap;

    public JavaTypeSubstitutorImpl(@NotNull PsiSubstitutor psiSubstitutor) {
        if (psiSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiSubstitutor", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "<init>"));
        }
        this.psiSubstitutor = psiSubstitutor;
    }

    public JavaTypeSubstitutorImpl(@NotNull PsiSubstitutor psiSubstitutor, @NotNull Map<JavaTypeParameter, JavaType> substitutionMap) {
        if (psiSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiSubstitutor", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "<init>"));
        }
        if (substitutionMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutionMap", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "<init>"));
        }
        this(psiSubstitutor);
        this.substitutionMap = substitutionMap;
    }

    @NotNull
    public static JavaTypeSubstitutor create(@NotNull Map<JavaTypeParameter, JavaType> substitutionMap) {
        if (substitutionMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutionMap", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "create"));
        }
        HashMap<PsiTypeParameter, PsiType> psiMap = new HashMap<PsiTypeParameter, PsiType>();
        for (Map.Entry<JavaTypeParameter, JavaType> entry : substitutionMap.entrySet()) {
            JavaTypeImpl value = (JavaTypeImpl)entry.getValue();
            psiMap.put((PsiTypeParameter)((JavaTypeParameterImpl)entry.getKey()).getPsi(), (PsiType)(value == null ? null : (Object)value.getPsi()));
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutorImpl.createSubstitutor(psiMap);
        JavaTypeSubstitutorImpl javaTypeSubstitutorImpl = new JavaTypeSubstitutorImpl(psiSubstitutor, substitutionMap);
        if (javaTypeSubstitutorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "create"));
        }
        return javaTypeSubstitutorImpl;
    }

    @Override
    @NotNull
    public JavaType substitute(@NotNull JavaType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "substitute"));
        }
        JavaTypeImpl<?> javaTypeImpl = JavaTypeImpl.create(this.psiSubstitutor.substitute((PsiType)((JavaTypeImpl)type).getPsi()));
        if (javaTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "substitute"));
        }
        return javaTypeImpl;
    }

    @Override
    @Nullable
    public JavaType substitute(@NotNull JavaTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "substitute"));
        }
        PsiType psiType = this.psiSubstitutor.substitute((PsiTypeParameter)((JavaTypeParameterImpl)typeParameter).getPsi());
        return psiType == null ? null : JavaTypeImpl.create(psiType);
    }

    @Override
    @NotNull
    public Map<JavaTypeParameter, JavaType> getSubstitutionMap() {
        if (this.substitutionMap == null) {
            Map<PsiTypeParameter, PsiType> psiMap = this.psiSubstitutor.getSubstitutionMap();
            this.substitutionMap = new HashMap<JavaTypeParameter, JavaType>();
            for (Map.Entry<PsiTypeParameter, PsiType> entry : psiMap.entrySet()) {
                PsiType value = entry.getValue();
                this.substitutionMap.put(new JavaTypeParameterImpl(entry.getKey()), value == null ? null : JavaTypeImpl.create(value));
            }
        }
        Map<JavaTypeParameter, JavaType> map2 = this.substitutionMap;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaTypeSubstitutorImpl", "getSubstitutionMap"));
        }
        return map2;
    }

    public int hashCode() {
        return this.psiSubstitutor.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaTypeSubstitutorImpl && this.psiSubstitutor.equals(((JavaTypeSubstitutorImpl)obj).psiSubstitutor);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.psiSubstitutor;
    }
}

