/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinBinaryClassCache;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileFinder;
import org.jetbrains.jet.lang.resolve.name.FqName;

public abstract class VirtualFileKotlinClassFinder
implements VirtualFileFinder {
    @Override
    @Nullable
    public KotlinJvmBinaryClass findKotlinClass(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClassFinder", "findKotlinClass"));
        }
        VirtualFile file = this.findVirtualFileWithHeader(fqName);
        return file == null ? null : KotlinBinaryClassCache.getKotlinBinaryClass(file);
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass findKotlinClass(@NotNull JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClassFinder", "findKotlinClass"));
        }
        VirtualFile file = ((PsiClass)((JavaClassImpl)javaClass).getPsi()).getContainingFile().getVirtualFile();
        if (javaClass.getOuterClass() != null) {
            file = file.getParent().findChild(VirtualFileKotlinClassFinder.classFileName(javaClass) + ".class");
            assert (file != null) : "Virtual file not found for " + javaClass;
        }
        if (file.getFileType() != JavaClassFileType.INSTANCE) {
            return null;
        }
        return KotlinBinaryClassCache.getKotlinBinaryClass(file);
    }

    @NotNull
    private static String classFileName(@NotNull JavaClass jClass) {
        if (jClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jClass", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClassFinder", "classFileName"));
        }
        JavaClass outerClass = jClass.getOuterClass();
        if (outerClass == null) {
            String string = jClass.getName().asString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClassFinder", "classFileName"));
            }
            return string;
        }
        String string = VirtualFileKotlinClassFinder.classFileName(outerClass) + "$" + jClass.getName().asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClassFinder", "classFileName"));
        }
        return string;
    }
}

