/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy.descriptors;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DelegationResolver;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.jet.lang.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.AbstractLazyMemberScope;
import org.jetbrains.jet.lang.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.storage.NullableLazyValue;

public class LazyClassMemberScope
extends AbstractLazyMemberScope<LazyClassDescriptor, ClassMemberDeclarationProvider> {
    @NotNull
    private static final Set<ClassKind> GENERATE_CONSTRUCTORS_FOR = ImmutableSet.of(ClassKind.CLASS, ClassKind.ANNOTATION_CLASS, ClassKind.OBJECT, ClassKind.ENUM_CLASS, ClassKind.ENUM_ENTRY, ClassKind.CLASS_OBJECT, new ClassKind[0]);
    private final NullableLazyValue<ConstructorDescriptor> primaryConstructor;

    public LazyClassMemberScope(@NotNull ResolveSession resolveSession, @NotNull ClassMemberDeclarationProvider declarationProvider, @NotNull LazyClassDescriptor thisClass, @NotNull BindingTrace trace) {
        if (resolveSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "<init>"));
        }
        if (declarationProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProvider", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "<init>"));
        }
        if (thisClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thisClass", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "<init>"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "<init>"));
        }
        super(resolveSession, declarationProvider, thisClass, trace);
        this.primaryConstructor = resolveSession.getStorageManager().createNullableLazyValue(new Function0<ConstructorDescriptor>(){

            @Override
            public ConstructorDescriptor invoke() {
                return LazyClassMemberScope.this.resolvePrimaryConstructor();
            }
        });
    }

    @Override
    @NotNull
    protected JetScope getScopeForMemberDeclarationResolution(JetDeclaration declaration) {
        if (declaration instanceof JetProperty) {
            JetScope jetScope = ((LazyClassDescriptor)this.thisDescriptor).getScopeForInitializerResolution();
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "getScopeForMemberDeclarationResolution"));
            }
            return jetScope;
        }
        JetScope jetScope = ((LazyClassDescriptor)this.thisDescriptor).getScopeForMemberDeclarationResolution();
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "getScopeForMemberDeclarationResolution"));
        }
        return jetScope;
    }

    private <D extends CallableMemberDescriptor> void generateFakeOverrides(@NotNull Name name, @NotNull Collection<D> fromSupertypes, final @NotNull Collection<D> result2, final @NotNull Class<? extends D> exactDescriptorClass) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "generateFakeOverrides"));
        }
        if (fromSupertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromSupertypes", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "generateFakeOverrides"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "generateFakeOverrides"));
        }
        if (exactDescriptorClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exactDescriptorClass", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "generateFakeOverrides"));
        }
        OverridingUtil.generateOverridesInFunctionGroup(name, fromSupertypes, Lists.newArrayList(result2), (ClassDescriptor)this.thisDescriptor, new OverridingUtil.DescriptorSink(){

            @Override
            public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                if (fakeOverride == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeOverride", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope$2", "addToScope"));
                }
                assert (exactDescriptorClass.isInstance(fakeOverride)) : "Wrong descriptor type in an override: " + fakeOverride + " while expecting " + exactDescriptorClass.getSimpleName();
                result2.add(fakeOverride);
            }

            @Override
            public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                if (fromSuper == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromSuper", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope$2", "conflict"));
                }
                if (fromCurrent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromCurrent", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope$2", "conflict"));
                }
                JetDeclaration declaration = (JetDeclaration)BindingContextUtils.descriptorToDeclaration(LazyClassMemberScope.this.trace.getBindingContext(), fromCurrent);
                assert (declaration != null) : "fromCurrent can not be a fake override";
                LazyClassMemberScope.this.trace.report(Errors.CONFLICTING_OVERLOADS.on(declaration, fromCurrent, fromCurrent.getContainingDeclaration().getName().asString()));
            }
        });
        OverrideResolver.resolveUnknownVisibilities(result2, this.trace);
    }

    @Override
    @NotNull
    public Set<FunctionDescriptor> getFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "getFunctions"));
        }
        Collection functions2 = super.getFunctions(name);
        this.resolveUnknownVisibilitiesForMembers((Set<? extends CallableMemberDescriptor>)functions2);
        Collection collection = functions2;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "getFunctions"));
        }
        return collection;
    }

    @Override
    protected void getNonDeclaredFunctions(@NotNull Name name, @NotNull Set<FunctionDescriptor> result2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "getNonDeclaredFunctions"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "getNonDeclaredFunctions"));
        }
        ArrayList<FunctionDescriptor> fromSupertypes = Lists.newArrayList();
        for (JetType supertype : ((LazyClassDescriptor)this.thisDescriptor).getTypeConstructor().getSupertypes()) {
            fromSupertypes.addAll(supertype.getMemberScope().getFunctions(name));
        }
        result2.addAll(this.generateDelegatingDescriptors(name, MemberExtractor.EXTRACT_FUNCTIONS, result2));
        this.generateEnumClassObjectMethods(result2, name);
        this.generateDataClassMethods(result2, name);
        this.generateFakeOverrides(name, fromSupertypes, result2, FunctionDescriptor.class);
    }

    private void generateDataClassMethods(@NotNull Collection<FunctionDescriptor> result2, @NotNull Name name) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "generateDataClassMethods"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "generateDataClassMethods"));
        }
        if (!KotlinBuiltIns.getInstance().isData((ClassDescriptor)this.thisDescriptor)) {
            return;
        }
        ConstructorDescriptor constructor = this.getPrimaryConstructor();
        if (constructor == null) {
            return;
        }
        int parameterIndex = 0;
        for (ValueParameterDescriptor parameter : constructor.getValueParameters()) {
            Collection properties;
            if (parameter.getType().isError() || (properties = this.getProperties(parameter.getName())).isEmpty()) continue;
            assert (properties.size() == 1) : "A constructor parameter is resolved to more than one (" + properties.size() + ") property: " + parameter;
            PropertyDescriptor property2 = (PropertyDescriptor)properties.iterator().next();
            if (property2 == null || !name.equals(Name.identifier("component" + ++parameterIndex))) continue;
            SimpleFunctionDescriptor functionDescriptor = DescriptorResolver.createComponentFunctionDescriptor(parameterIndex, property2, parameter, (ClassDescriptor)this.thisDescriptor, this.trace);
            result2.add(functionDescriptor);
            break;
        }
        if (!constructor.getValueParameters().isEmpty() && name.equals(DescriptorResolver.COPY_METHOD_NAME)) {
            SimpleFunctionDescriptor copyFunctionDescriptor = DescriptorResolver.createCopyFunctionDescriptor(constructor.getValueParameters(), (ClassDescriptor)this.thisDescriptor, this.trace);
            result2.add(copyFunctionDescriptor);
        }
    }

    private void generateEnumClassObjectMethods(@NotNull Collection<? super FunctionDescriptor> result2, @NotNull Name name) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "generateEnumClassObjectMethods"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "generateEnumClassObjectMethods"));
        }
        if (!DescriptorUtils.isEnumClassObject(this.thisDescriptor)) {
            return;
        }
        if (name.equals(DescriptorFactory.VALUES_METHOD_NAME)) {
            SimpleFunctionDescriptor valuesMethod = DescriptorResolver.createEnumClassObjectValuesMethod((ClassDescriptor)this.thisDescriptor, this.trace);
            result2.add(valuesMethod);
        } else if (name.equals(DescriptorFactory.VALUE_OF_METHOD_NAME)) {
            SimpleFunctionDescriptor valueOfMethod = DescriptorResolver.createEnumClassObjectValueOfMethod((ClassDescriptor)this.thisDescriptor, this.trace);
            result2.add(valueOfMethod);
        }
    }

    @Override
    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "getProperties"));
        }
        Collection properties = super.getProperties(name);
        this.resolveUnknownVisibilitiesForMembers((Set<? extends CallableMemberDescriptor>)properties);
        Collection collection = properties;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "getProperties"));
        }
        return collection;
    }

    private void resolveUnknownVisibilitiesForMembers(@NotNull Set<? extends CallableMemberDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "resolveUnknownVisibilitiesForMembers"));
        }
        for (CallableMemberDescriptor callableMemberDescriptor : descriptors) {
            if (callableMemberDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE || callableMemberDescriptor.getKind() == CallableMemberDescriptor.Kind.DELEGATION) continue;
            OverridingUtil.resolveUnknownVisibilityForMember(callableMemberDescriptor, OverrideResolver.createCannotInferVisibilityReporter(this.trace));
        }
    }

    @Override
    protected void getNonDeclaredProperties(@NotNull Name name, @NotNull Set<VariableDescriptor> result2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "getNonDeclaredProperties"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "getNonDeclaredProperties"));
        }
        this.createPropertiesFromPrimaryConstructorParameters(name, result2);
        ArrayList<VariableDescriptor> fromSupertypes = Lists.newArrayList();
        for (JetType supertype : ((LazyClassDescriptor)this.thisDescriptor).getTypeConstructor().getSupertypes()) {
            fromSupertypes.addAll(supertype.getMemberScope().getProperties(name));
        }
        result2.addAll(this.generateDelegatingDescriptors(name, MemberExtractor.EXTRACT_PROPERTIES, result2));
        this.generateFakeOverrides(name, fromSupertypes, result2, PropertyDescriptor.class);
    }

    protected void createPropertiesFromPrimaryConstructorParameters(@NotNull Name name, @NotNull Set<VariableDescriptor> result2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "createPropertiesFromPrimaryConstructorParameters"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "createPropertiesFromPrimaryConstructorParameters"));
        }
        JetClassLikeInfo classInfo = ((ClassMemberDeclarationProvider)this.declarationProvider).getOwnerInfo();
        ConstructorDescriptor primaryConstructor = this.getPrimaryConstructor();
        if (primaryConstructor == null) {
            return;
        }
        List<ValueParameterDescriptor> valueParameterDescriptors = primaryConstructor.getValueParameters();
        List<? extends JetParameter> primaryConstructorParameters = classInfo.getPrimaryConstructorParameters();
        assert (valueParameterDescriptors.size() == primaryConstructorParameters.size()) : "From descriptor: " + valueParameterDescriptors.size() + " but from PSI: " + primaryConstructorParameters.size();
        for (ValueParameterDescriptor valueParameterDescriptor : valueParameterDescriptors) {
            JetParameter parameter;
            if (!name.equals(valueParameterDescriptor.getName()) || (parameter = primaryConstructorParameters.get(valueParameterDescriptor.getIndex())).getValOrVarNode() == null) continue;
            PropertyDescriptor propertyDescriptor = this.resolveSession.getDescriptorResolver().resolvePrimaryConstructorParameterToAProperty((ClassDescriptor)this.thisDescriptor, valueParameterDescriptor, ((LazyClassDescriptor)this.thisDescriptor).getScopeForClassHeaderResolution(), parameter, this.trace);
            result2.add(propertyDescriptor);
        }
    }

    @NotNull
    private <T extends CallableMemberDescriptor> Collection<T> generateDelegatingDescriptors(final @NotNull Name name, final @NotNull MemberExtractor<T> extractor, @NotNull Collection<? extends CallableDescriptor> existingDescriptors) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "generateDelegatingDescriptors"));
        }
        if (extractor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractor", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "generateDelegatingDescriptors"));
        }
        if (existingDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingDescriptors", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "generateDelegatingDescriptors"));
        }
        JetClassOrObject classOrObject = ((ClassMemberDeclarationProvider)this.declarationProvider).getOwnerInfo().getCorrespondingClassOrObject();
        if (classOrObject == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "generateDelegatingDescriptors"));
            }
            return set;
        }
        DelegationResolver.TypeResolver lazyTypeResolver = new DelegationResolver.TypeResolver(){

            @Override
            @Nullable
            public JetType resolve(@NotNull JetTypeReference reference) {
                if (reference == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope$3", "resolve"));
                }
                return LazyClassMemberScope.this.resolveSession.getTypeResolver().resolveType(((LazyClassDescriptor)LazyClassMemberScope.this.thisDescriptor).getScopeForClassHeaderResolution(), reference, LazyClassMemberScope.this.trace, false);
            }
        };
        DelegationResolver.MemberExtractor lazyMemberExtractor = new DelegationResolver.MemberExtractor<T>(){

            @Override
            @NotNull
            public Collection<T> getMembersByType(@NotNull JetType type) {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope$4", "getMembersByType"));
                }
                Collection collection = extractor.extract(type, name);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope$4", "getMembersByType"));
                }
                return collection;
            }
        };
        Collection collection = DelegationResolver.generateDelegatedMembers(classOrObject, (ClassDescriptor)this.thisDescriptor, existingDescriptors, this.trace, lazyMemberExtractor, lazyTypeResolver);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "generateDelegatingDescriptors"));
        }
        return collection;
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> computeExtraDescriptors() {
        ArrayList<DeclarationDescriptor> result2 = new ArrayList<DeclarationDescriptor>();
        for (JetType supertype : ((LazyClassDescriptor)this.thisDescriptor).getTypeConstructor().getSupertypes()) {
            for (DeclarationDescriptor descriptor : supertype.getMemberScope().getAllDescriptors()) {
                if (descriptor instanceof FunctionDescriptor) {
                    result2.addAll(this.getFunctions(descriptor.getName()));
                    continue;
                }
                if (!(descriptor instanceof PropertyDescriptor)) continue;
                result2.addAll(this.getProperties(descriptor.getName()));
            }
        }
        result2.addAll(this.getFunctions(DescriptorFactory.VALUES_METHOD_NAME));
        result2.addAll(this.getFunctions(DescriptorFactory.VALUE_OF_METHOD_NAME));
        this.addDataClassMethods(result2);
        result2.trimToSize();
        ArrayList<DeclarationDescriptor> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "computeExtraDescriptors"));
        }
        return arrayList;
    }

    private void addDataClassMethods(@NotNull Collection<DeclarationDescriptor> result2) {
        Name componentName;
        Collection functions2;
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "addDataClassMethods"));
        }
        if (!KotlinBuiltIns.getInstance().isData((ClassDescriptor)this.thisDescriptor)) {
            return;
        }
        ConstructorDescriptor constructor = this.getPrimaryConstructor();
        if (constructor == null) {
            return;
        }
        int n = 1;
        while (!(functions2 = this.getFunctions(componentName = Name.identifier("component" + n))).isEmpty()) {
            result2.addAll(functions2);
            ++n;
        }
        result2.addAll(this.getFunctions(Name.identifier("copy")));
    }

    @Override
    @Nullable
    public PackageViewDescriptor getPackage(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "getPackage"));
        }
        return null;
    }

    @Override
    @NotNull
    protected ReceiverParameterDescriptor getImplicitReceiver() {
        ReceiverParameterDescriptor receiverParameterDescriptor = ((LazyClassDescriptor)this.thisDescriptor).getThisAsReceiverParameter();
        if (receiverParameterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "getImplicitReceiver"));
        }
        return receiverParameterDescriptor;
    }

    @NotNull
    public Set<ConstructorDescriptor> getConstructors() {
        ConstructorDescriptor constructor = this.getPrimaryConstructor();
        Set<Object> set = constructor == null ? Collections.emptySet() : Collections.singleton(constructor);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "getConstructors"));
        }
        return set;
    }

    @Nullable
    public ConstructorDescriptor getPrimaryConstructor() {
        return (ConstructorDescriptor)this.primaryConstructor.invoke();
    }

    @Nullable
    protected ConstructorDescriptor resolvePrimaryConstructor() {
        if (GENERATE_CONSTRUCTORS_FOR.contains((Object)((LazyClassDescriptor)this.thisDescriptor).getKind())) {
            JetClassLikeInfo ownerInfo = ((ClassMemberDeclarationProvider)this.declarationProvider).getOwnerInfo();
            JetClassOrObject classOrObject = ownerInfo.getCorrespondingClassOrObject();
            if (!((LazyClassDescriptor)this.thisDescriptor).getKind().isSingleton()) {
                JetClass jetClass = (JetClass)classOrObject;
                assert (jetClass != null) : "No JetClass for " + this.thisDescriptor;
                ConstructorDescriptorImpl constructor = this.resolveSession.getDescriptorResolver().resolvePrimaryConstructorDescriptor(((LazyClassDescriptor)this.thisDescriptor).getScopeForClassHeaderResolution(), (ClassDescriptor)this.thisDescriptor, jetClass, this.trace);
                assert (constructor != null) : "No constructor created for " + this.thisDescriptor;
                this.setDeferredReturnType(constructor);
                return constructor;
            }
            ConstructorDescriptorImpl constructor = DescriptorResolver.createAndRecordPrimaryConstructorForObject(classOrObject, (ClassDescriptor)this.thisDescriptor, this.trace);
            this.setDeferredReturnType(constructor);
            return constructor;
        }
        return null;
    }

    protected void setDeferredReturnType(@NotNull ConstructorDescriptorImpl descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope", "setDeferredReturnType"));
        }
        descriptor.setReturnType(DeferredType.create(this.resolveSession.getStorageManager(), this.trace, new Function0<JetType>(){

            @Override
            public JetType invoke() {
                return ((LazyClassDescriptor)LazyClassMemberScope.this.thisDescriptor).getDefaultType();
            }
        }));
    }

    @Override
    public String toString() {
        return "lazy scope for class " + ((LazyClassDescriptor)this.thisDescriptor).getName();
    }

    private static interface MemberExtractor<T extends CallableMemberDescriptor> {
        public static final MemberExtractor<FunctionDescriptor> EXTRACT_FUNCTIONS = new MemberExtractor<FunctionDescriptor>(){

            @Override
            @NotNull
            public Collection<FunctionDescriptor> extract(@NotNull JetType extractFrom, @NotNull Name name) {
                if (extractFrom == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractFrom", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope$MemberExtractor$1", "extract"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope$MemberExtractor$1", "extract"));
                }
                Collection<FunctionDescriptor> collection = extractFrom.getMemberScope().getFunctions(name);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope$MemberExtractor$1", "extract"));
                }
                return collection;
            }
        };
        public static final MemberExtractor<PropertyDescriptor> EXTRACT_PROPERTIES = new MemberExtractor<PropertyDescriptor>(){

            @Override
            @NotNull
            public Collection<PropertyDescriptor> extract(@NotNull JetType extractFrom, @NotNull Name name) {
                if (extractFrom == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractFrom", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope$MemberExtractor$2", "extract"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope$MemberExtractor$2", "extract"));
                }
                Collection<VariableDescriptor> collection = extractFrom.getMemberScope().getProperties(name);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/lazy/descriptors/LazyClassMemberScope$MemberExtractor$2", "extract"));
                }
                return collection;
            }
        };

        @NotNull
        public Collection<T> extract(@NotNull JetType var1, @NotNull Name var2);
    }
}

