/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression.foreach;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.backend.js.ast.JsWhile;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.k2js.translate.callTranslator.CallTranslator;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.expression.foreach.ForTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class IteratorForTranslator
extends ForTranslator {
    @NotNull
    private final Pair<JsVars.JsVar, JsExpression> iterator;

    @NotNull
    public static JsStatement doTranslate(@NotNull JetForExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/expression/foreach/IteratorForTranslator", "doTranslate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/foreach/IteratorForTranslator", "doTranslate"));
        }
        JsBlock jsBlock = new IteratorForTranslator(expression, context).translate();
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/IteratorForTranslator", "doTranslate"));
        }
        return jsBlock;
    }

    private IteratorForTranslator(@NotNull JetForExpression forExpression, @NotNull TranslationContext context) {
        if (forExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forExpression", "org/jetbrains/k2js/translate/expression/foreach/IteratorForTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/expression/foreach/IteratorForTranslator", "<init>"));
        }
        super(forExpression, context);
        this.iterator = context.dynamicContext().createTemporary(this.iteratorMethodInvocation());
    }

    @NotNull
    private JsBlock translate() {
        JsBlock jsBlock = new JsBlock(new JsVars((JsVars.JsVar)this.iterator.first), new JsWhile(this.hasNextMethodInvocation(), this.translateBody(this.nextMethodInvocation())));
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/IteratorForTranslator", "translate"));
        }
        return jsBlock;
    }

    @NotNull
    private JsExpression nextMethodInvocation() {
        JsExpression jsExpression = this.translateMethodInvocation((JsExpression)this.iterator.second, BindingUtils.getNextFunction(this.bindingContext(), PsiUtils.getLoopRange(this.expression)));
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/IteratorForTranslator", "nextMethodInvocation"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression hasNextMethodInvocation() {
        ResolvedCall<FunctionDescriptor> resolvedCall = BindingUtils.getHasNextCallable(this.bindingContext(), PsiUtils.getLoopRange(this.expression));
        JsExpression jsExpression = this.translateMethodInvocation((JsExpression)this.iterator.second, resolvedCall);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/IteratorForTranslator", "hasNextMethodInvocation"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression iteratorMethodInvocation() {
        JetExpression rangeExpression = PsiUtils.getLoopRange(this.expression);
        JsExpression range = Translation.translateAsExpression(rangeExpression, this.context());
        ResolvedCall<FunctionDescriptor> resolvedCall = BindingUtils.getIteratorFunction(this.bindingContext(), rangeExpression);
        JsExpression jsExpression = this.translateMethodInvocation(range, resolvedCall);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/IteratorForTranslator", "iteratorMethodInvocation"));
        }
        return jsExpression;
    }

    @NotNull
    private JsExpression translateMethodInvocation(@Nullable JsExpression receiver, @NotNull ResolvedCall<FunctionDescriptor> resolvedCall) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/k2js/translate/expression/foreach/IteratorForTranslator", "translateMethodInvocation"));
        }
        JsExpression jsExpression = CallTranslator.instance$.translate(this.context(), resolvedCall, receiver);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/expression/foreach/IteratorForTranslator", "translateMethodInvocation"));
        }
        return jsExpression;
    }
}

