/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Parameter;
import org.picocontainer.defaults.AbstractComponentAdapter;
import org.picocontainer.defaults.ComponentParameter;
import org.picocontainer.defaults.DefaultLifecycleStrategy;
import org.picocontainer.defaults.DelegatingComponentMonitor;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public abstract class InstantiatingComponentAdapter
extends AbstractComponentAdapter
implements LifecycleStrategy {
    protected transient Parameter[] parameters;
    protected boolean allowNonPublicClasses;
    protected LifecycleStrategy lifecycleStrategy;

    protected InstantiatingComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses, ComponentMonitor monitor, LifecycleStrategy lifecycleStrategy) {
        super(componentKey, componentImplementation, monitor);
        this.checkConcrete();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] != null) continue;
                throw new NullPointerException(new StringBuffer().append("Parameter ").append(i).append(" is null").toString());
            }
        }
        this.parameters = parameters;
        this.allowNonPublicClasses = allowNonPublicClasses;
        this.lifecycleStrategy = lifecycleStrategy;
    }

    protected InstantiatingComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses, ComponentMonitor monitor) {
        this(componentKey, componentImplementation, parameters, allowNonPublicClasses, monitor, new DefaultLifecycleStrategy(monitor));
    }

    protected InstantiatingComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses) {
        this(componentKey, componentImplementation, parameters, allowNonPublicClasses, new DelegatingComponentMonitor());
    }

    private void checkConcrete() throws NotConcreteRegistrationException {
        boolean isAbstract;
        boolean bl = isAbstract = (this.getComponentImplementation().getModifiers() & 0x400) == 1024;
        if (this.getComponentImplementation().isInterface() || isAbstract) {
            throw new NotConcreteRegistrationException(this.getComponentImplementation());
        }
    }

    protected Parameter[] createDefaultParameters(Class[] parameters) {
        Parameter[] componentParameters = new Parameter[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            componentParameters[i] = ComponentParameter.DEFAULT;
        }
        return componentParameters;
    }

    @Override
    public boolean hasLifecycle(Class type) {
        return this.lifecycleStrategy.hasLifecycle(type);
    }

    protected Object newInstance(Constructor constructor, Object[] parameters) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.allowNonPublicClasses) {
            constructor.setAccessible(true);
        }
        return constructor.newInstance(parameters);
    }
}

