/*
 * Copyright 2010-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.jet.lang.psi.codeFragmentUtil

import com.intellij.openapi.util.Key
import com.intellij.psi.PsiFile
import org.jetbrains.jet.lang.psi.JetFile
import org.jetbrains.jet.lang.psi.JetCodeFragment

public val SKIP_VISIBILITY_CHECK: Key<Boolean> = Key.create<Boolean>("SKIP_VISIBILITY_CHECK")

fun JetFile.skipVisibilityCheck() =
        when (this) {
            is JetCodeFragment -> true
            is JetFile -> getUserData(SKIP_VISIBILITY_CHECK) ?: false
            else -> false
        }

fun JetFile.setSkipVisibilityCheck(skip: Boolean) {
    putUserData(SKIP_VISIBILITY_CHECK, skip)
}

