/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.keyFMap.KeyFMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserDataHolderBase
implements UserDataHolderEx,
Cloneable {
    public static final Key<KeyFMap> COPYABLE_USER_MAP_KEY = Key.create("COPYABLE_USER_MAP_KEY");
    @NotNull
    private volatile KeyFMap myUserMap = KeyFMap.EMPTY_MAP;
    private static final AtomicFieldUpdater<UserDataHolderBase, KeyFMap> updater = AtomicFieldUpdater.forFieldOfType(UserDataHolderBase.class, KeyFMap.class);

    protected Object clone() {
        try {
            UserDataHolderBase clone = (UserDataHolderBase)super.clone();
            clone.myUserMap = KeyFMap.EMPTY_MAP;
            this.copyCopyableDataTo(clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUserDataString() {
        KeyFMap userMap = this.myUserMap;
        KeyFMap copyableMap = this.getUserData(COPYABLE_USER_MAP_KEY);
        return ((Object)userMap).toString() + (copyableMap == null ? "" : ((Object)copyableMap).toString());
    }

    public void copyUserDataTo(UserDataHolderBase other) {
        other.myUserMap = this.myUserMap;
    }

    @Override
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/UserDataHolderBase", "getUserData"));
        }
        return this.myUserMap.get(key);
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        KeyFMap map;
        KeyFMap newMap;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/UserDataHolderBase", "putUserData"));
        }
        do {
            map = this.myUserMap;
            KeyFMap keyFMap = newMap = value == null ? map.minus(key) : map.plus(key, value);
        } while (newMap != map && !updater.compareAndSet(this, map, newMap));
    }

    public <T> T getCopyableUserData(Key<T> key) {
        KeyFMap map = this.getUserData(COPYABLE_USER_MAP_KEY);
        return map == null ? null : (T)map.get(key);
    }

    public <T> void putCopyableUserData(Key<T> key, T value) {
        KeyFMap map;
        KeyFMap newMap;
        do {
            KeyFMap copyableMap;
            if ((copyableMap = (map = this.myUserMap).get(COPYABLE_USER_MAP_KEY)) == null) {
                copyableMap = KeyFMap.EMPTY_MAP;
            }
            KeyFMap newCopyableMap = value == null ? copyableMap.minus(key) : copyableMap.plus(key, value);
            KeyFMap keyFMap = newMap = newCopyableMap.isEmpty() ? map.minus(COPYABLE_USER_MAP_KEY) : map.plus(COPYABLE_USER_MAP_KEY, newCopyableMap);
        } while (newMap != map && !updater.compareAndSet(this, map, newMap));
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        KeyFMap map;
        KeyFMap newMap;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/UserDataHolderBase", "replace"));
        }
        do {
            if ((map = this.myUserMap).get(key) != oldValue) {
                return false;
            }
            KeyFMap keyFMap = newMap = newValue == null ? map.minus(key) : map.plus(key, newValue);
        } while (newMap != map && !updater.compareAndSet(this, map, newMap));
        return true;
    }

    @Override
    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        KeyFMap map;
        KeyFMap newMap;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/UserDataHolderBase", "putUserDataIfAbsent"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/UserDataHolderBase", "putUserDataIfAbsent"));
        }
        do {
            T oldValue;
            if ((oldValue = (map = this.myUserMap).get(key)) == null) continue;
            T t = oldValue;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/UserDataHolderBase", "putUserDataIfAbsent"));
            }
            return t;
        } while ((newMap = map.plus(key, value)) != map && !updater.compareAndSet(this, map, newMap));
        T t = value;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/UserDataHolderBase", "putUserDataIfAbsent"));
        }
        return t;
    }

    public void copyCopyableDataTo(@NotNull UserDataHolderBase clone) {
        if (clone == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/UserDataHolderBase", "copyCopyableDataTo"));
        }
        clone.putUserData(COPYABLE_USER_MAP_KEY, this.getUserData(COPYABLE_USER_MAP_KEY));
    }

    protected void clearUserData() {
        this.myUserMap = KeyFMap.EMPTY_MAP;
    }

    public boolean isUserDataEmpty() {
        return this.myUserMap.isEmpty();
    }
}

