/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariablesOrder;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.CheckedExceptionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSession {
    private static final Logger LOG = Logger.getInstance("#" + InferenceSession.class.getName());
    public static final Key<PsiType> LOWER_BOUND = Key.create("LowBound");
    private static final Key<Boolean> ERASED = Key.create("UNCHECKED_CONVERSION");
    private final Map<PsiTypeParameter, InferenceVariable> myInferenceVariables = new LinkedHashMap<PsiTypeParameter, InferenceVariable>();
    private final List<ConstraintFormula> myConstraints = new ArrayList<ConstraintFormula>();
    private PsiSubstitutor mySiteSubstitutor;
    private PsiManager myManager;
    private int myConstraintIdx = 0;
    private boolean myErased = false;
    private final InferenceIncorporationPhase myIncorporationPhase = new InferenceIncorporationPhase(this);
    private final PsiElement myContext;

    public InferenceSession(PsiTypeParameter[] typeParams, PsiType[] leftTypes, PsiType[] rightTypes, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.initBounds(typeParams);
        LOG.assertTrue(leftTypes.length == rightTypes.length);
        for (int i = 0; i < leftTypes.length; ++i) {
            PsiType rightType = this.mySiteSubstitutor.substitute(rightTypes[i]);
            if (rightType == null) continue;
            this.myConstraints.add(new TypeCompatibilityConstraint(leftTypes[i], rightType));
        }
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.initBounds(typeParams);
    }

    public void initExpressionConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiElement parent, PsiMethod method) {
        Pair<PsiMethod, PsiCallExpression> pair;
        if (method == null && (pair = InferenceSession.getPair(parent)) != null) {
            method = (PsiMethod)pair.first;
        }
        if (parameters.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null || !InferenceSession.isPertinentToApplicability(args[i], method)) continue;
                PsiType parameterType = InferenceSession.getParameterType(parameters, args, i, this.mySiteSubstitutor);
                this.myConstraints.add(new ExpressionCompatibilityConstraint(args[i], parameterType));
            }
        }
    }

    private static Pair<PsiMethod, PsiCallExpression> getPair(PsiElement parent) {
        Pair<PsiMethod, PsiSubstitutor> pair;
        if (parent instanceof PsiCallExpression && (pair = MethodCandidateInfo.getCurrentMethod(((PsiCallExpression)parent).getArgumentList())) != null) {
            return Pair.create(pair.first, (PsiCallExpression)parent);
        }
        return null;
    }

    public static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method) {
        if (expr instanceof PsiLambdaExpression) {
            if (!((PsiLambdaExpression)expr).hasFormalParameterTypes()) {
                return false;
            }
            for (PsiExpression expression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)expr)) {
                if (InferenceSession.isPertinentToApplicability(expression, method)) continue;
                return false;
            }
            if (method != null && method.getTypeParameters().length > 0) {
                PsiElement gParent;
                PsiElement parent = PsiUtil.skipParenthesizedExprUp(expr.getParent());
                if (parent instanceof PsiExpressionList && (gParent = parent.getParent()) instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArgumentList().getTypeParameterElements().length == 0) {
                    PsiType paramType;
                    PsiParameter[] parameters;
                    int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)parent, expr);
                    if (idx > (parameters = method.getParameterList().getParameters()).length - 1) {
                        PsiType lastParamType = parameters[parameters.length - 1].getType();
                        paramType = parameters[parameters.length - 1].isVarArgs() ? ((PsiEllipsisType)lastParamType).getComponentType() : lastParamType;
                    } else {
                        paramType = parameters[idx].getType();
                    }
                    PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(paramType);
                    if (psiClass instanceof PsiTypeParameter && ((PsiTypeParameter)psiClass).getOwner() == method) {
                        return false;
                    }
                }
                for (PsiExpression expression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)expr)) {
                    if (!PsiPolyExpressionUtil.isPolyExpression(expression)) continue;
                    return false;
                }
            }
            return true;
        }
        if (expr instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)expr).isExact();
        }
        if (expr instanceof PsiParenthesizedExpression) {
            return InferenceSession.isPertinentToApplicability(((PsiParenthesizedExpression)expr).getExpression(), method);
        }
        if (expr instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            if (!InferenceSession.isPertinentToApplicability(thenExpression, method)) {
                return false;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            if (!InferenceSession.isPertinentToApplicability(elseExpression, method)) {
                return false;
            }
        }
        return true;
    }

    private static PsiType getParameterType(PsiParameter[] parameters, PsiExpression[] args, int i, @Nullable PsiSubstitutor substitutor) {
        if (substitutor == null) {
            return null;
        }
        PsiType parameterType = substitutor.substitute(parameters[i < parameters.length ? i : parameters.length - 1].getType());
        if (parameterType instanceof PsiEllipsisType) {
            PsiType returnType;
            PsiMethod method;
            PsiExpression arg = args[i];
            if (arg instanceof PsiNewExpression && (((PsiNewExpression)arg).getArrayDimensions().length == parameterType.getArrayDimensions() || ((PsiNewExpression)arg).getArrayInitializer() != null)) {
                return parameterType;
            }
            if (arg instanceof PsiCallExpression && (method = ((PsiCallExpression)arg).resolveMethod()) != null && (returnType = method.getReturnType()) != null && returnType.getArrayDimensions() == parameterType.getArrayDimensions()) {
                return parameterType;
            }
            if (args.length != parameters.length || PsiPolyExpressionUtil.isPolyExpression(arg) || arg != null && !(arg.getType() instanceof PsiArrayType)) {
                parameterType = ((PsiEllipsisType)parameterType).getComponentType();
            }
        }
        return parameterType;
    }

    @NotNull
    public PsiSubstitutor infer() {
        PsiSubstitutor psiSubstitutor = this.infer(null, null, null);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    private PsiSubstitutor tryToInfer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiCallExpression parent, PsiMethod parentMethod) {
        if (!this.repeatInferencePhases(true)) {
            return this.resolveSubset(this.myInferenceVariables.values(), this.mySiteSubstitutor);
        }
        if (parentMethod != null) {
            this.initReturnTypeConstraint(parentMethod, parent);
            if (!this.repeatInferencePhases(true)) {
                return this.prepareSubstitution();
            }
            if (parameters != null && args != null) {
                HashSet<ConstraintFormula> additionalConstraints = new HashSet<ConstraintFormula>();
                if (parameters.length > 0) {
                    InferenceSession.collectAdditionalConstraints(parameters, args, parentMethod, PsiSubstitutor.EMPTY, additionalConstraints);
                }
                if (!additionalConstraints.isEmpty() && !this.proceedWithAdditionalConstraints(additionalConstraints)) {
                    return this.prepareSubstitution();
                }
            }
        }
        return null;
    }

    private static void collectAdditionalConstraints(PsiParameter[] parameters, PsiExpression[] args, PsiMethod parentMethod, PsiSubstitutor siteSubstitutor, Set<ConstraintFormula> additionalConstraints) {
        for (int i = 0; i < args.length; ++i) {
            JavaResolveResult result;
            PsiCallExpression callExpression;
            PsiExpressionList argumentList;
            if (args[i] == null) continue;
            PsiType parameterType = InferenceSession.getParameterType(parameters, args, i, siteSubstitutor);
            if (!InferenceSession.isPertinentToApplicability(args[i], parentMethod)) {
                additionalConstraints.add(new ExpressionCompatibilityConstraint(args[i], parameterType));
            }
            additionalConstraints.add(new CheckedExceptionCompatibilityConstraint(args[i], parameterType));
            if (!(args[i] instanceof PsiCallExpression) || (argumentList = (callExpression = (PsiCallExpression)args[i]).getArgumentList()) == null || !((result = callExpression.resolveMethodGenerics()) instanceof MethodCandidateInfo)) continue;
            PsiMethod method = ((MethodCandidateInfo)result).getElement();
            LOG.assertTrue(method != null);
            PsiExpression[] newArgs = argumentList.getExpressions();
            PsiParameter[] newParams = method.getParameterList().getParameters();
            if (newParams.length <= 0) continue;
            InferenceSession.collectAdditionalConstraints(newParams, newArgs, method, ((MethodCandidateInfo)result).getSiteSubstitutor(), additionalConstraints);
        }
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters, @Nullable PsiExpression[] args, @Nullable PsiElement parent) {
        Pair<PsiMethod, PsiCallExpression> pair = InferenceSession.getPair(parent);
        PsiSubstitutor psiSubstitutor = this.infer(parameters, args, parent, pair != null ? (PsiMethod)pair.first : null);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor infer(PsiParameter[] parameters, PsiExpression[] args, PsiElement parent, PsiMethod parentMethod) {
        PsiSubstitutor subst = this.tryToInfer(parameters, args, parent instanceof PsiCallExpression ? (PsiCallExpression)parent : null, parentMethod);
        if (subst != null) {
            PsiSubstitutor psiSubstitutor = subst;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
            }
            return psiSubstitutor;
        }
        PsiSubstitutor substitutor = this.resolveBounds(this.myInferenceVariables.values(), this.mySiteSubstitutor);
        if (substitutor != null) {
            if (this.myContext != null) {
                this.myContext.putUserData(ERASED, this.myErased);
            }
            this.mySiteSubstitutor = substitutor;
            for (PsiTypeParameter parameter : substitutor.getSubstitutionMap().keySet()) {
                InferenceVariable variable = this.getInferenceVariable(parameter);
                if (variable == null) continue;
                variable.setInstantiation(substitutor.substitute(parameter));
            }
        } else {
            PsiSubstitutor psiSubstitutor = this.resolveSubset(this.myInferenceVariables.values(), this.mySiteSubstitutor);
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession", "infer"));
        }
        return psiSubstitutor;
    }

    public PsiSubstitutor retrieveNonPrimitiveEqualsBounds(Collection<InferenceVariable> variables) {
        PsiSubstitutor substitutor = this.mySiteSubstitutor;
        for (InferenceVariable variable : variables) {
            PsiType equalsBound = this.getEqualsBound(variable, substitutor);
            if (equalsBound instanceof PsiPrimitiveType) continue;
            substitutor = substitutor.put(variable.getParameter(), equalsBound);
        }
        return substitutor;
    }

    private PsiSubstitutor prepareSubstitution() {
        for (InferenceVariable inferenceVariable : this.myInferenceVariables.values()) {
            PsiTypeParameter typeParameter = inferenceVariable.getParameter();
            PsiType instantiation = inferenceVariable.getInstantiation();
            if (instantiation != PsiType.NULL) continue;
            this.mySiteSubstitutor = this.mySiteSubstitutor.put(typeParameter, JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(typeParameter));
        }
        return this.mySiteSubstitutor;
    }

    private boolean isInsideRecursiveCall(PsiTypeParameter parameter) {
        PsiModifierListOwner staticContainer;
        PsiTypeParameterListOwner parameterOwner = parameter.getOwner();
        return this.myContext != null && PsiTreeUtil.isAncestor(parameterOwner, this.myContext, true) && ((staticContainer = PsiUtil.getEnclosingStaticElement(this.myContext, null)) == null || PsiTreeUtil.isAncestor(staticContainer, parameterOwner, false));
    }

    public boolean initBounds(PsiTypeParameter ... typeParameters) {
        boolean sameMethodCall = false;
        for (PsiTypeParameter parameter : typeParameters) {
            PsiClassType[] extendsListTypes;
            if (this.myInferenceVariables.containsKey(parameter)) {
                sameMethodCall = true;
                continue;
            }
            InferenceVariable variable = new InferenceVariable(parameter);
            boolean added = false;
            for (PsiType classType : extendsListTypes = parameter.getExtendsListTypes()) {
                if (this.isProperType(classType = this.mySiteSubstitutor.substitute(classType))) {
                    added = true;
                }
                variable.addBound(classType, InferenceBound.UPPER);
            }
            if (!added) {
                variable.addBound(PsiType.getJavaLangObject(parameter.getManager(), parameter.getResolveScope()), InferenceBound.UPPER);
            }
            this.myInferenceVariables.put(parameter, variable);
        }
        return sameMethodCall;
    }

    private void initReturnTypeConstraint(PsiMethod method, PsiCallExpression context) {
        PsiType returnType;
        if (PsiPolyExpressionUtil.isMethodCallPolyExpression(context, method) && !PsiType.VOID.equals(returnType = method.getReturnType()) && returnType != null) {
            PsiType targetType = PsiTypesUtil.getExpectedTypeByParent(context);
            if (targetType == null) {
                targetType = InferenceSession.getTargetType(context);
            }
            if (targetType != null) {
                this.registerConstraints(PsiUtil.isRawSubstitutor(method, this.mySiteSubstitutor) ? returnType : this.mySiteSubstitutor.substitute(returnType), targetType);
            }
        }
        for (PsiClassType thrownType : method.getThrowsList().getReferencedTypes()) {
            InferenceVariable variable = this.getInferenceVariable(thrownType);
            if (variable == null) continue;
            variable.setThrownBound();
        }
    }

    public void registerConstraints(PsiType returnType, PsiType targetType) {
        InferenceVariable inferenceVariable = this.shouldResolveAndInstantiate(returnType, targetType);
        if (inferenceVariable != null) {
            PsiSubstitutor substitutor = this.resolveSubset(Collections.singletonList(inferenceVariable), this.mySiteSubstitutor);
            this.myConstraints.add(new TypeCompatibilityConstraint(targetType, PsiUtil.captureToplevelWildcards(substitutor.substitute(inferenceVariable.getParameter()), this.myContext)));
        } else if (FunctionalInterfaceParameterizationUtil.isWildcardParameterized(returnType)) {
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(returnType);
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass != null) {
                LOG.assertTrue(returnType instanceof PsiClassType);
                PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
                PsiSubstitutor subst = PsiSubstitutor.EMPTY;
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(psiClass.getProject());
                PsiTypeParameter[] copy = new PsiTypeParameter[typeParameters.length];
                for (int i = 0; i < typeParameters.length; ++i) {
                    PsiTypeParameter typeParameter = typeParameters[i];
                    copy[i] = elementFactory.createTypeParameterFromText("rCopy" + typeParameter.getName(), null);
                    this.initBounds(copy[i]);
                    subst = subst.put(typeParameter, elementFactory.createType(copy[i]));
                }
                PsiType substitutedCapture = PsiUtil.captureToplevelWildcards(subst.substitute(returnType), this.myContext);
                this.myIncorporationPhase.addCapture(copy, (PsiClassType)returnType);
                this.myConstraints.add(new TypeCompatibilityConstraint(targetType, substitutedCapture));
            }
        } else {
            this.myConstraints.add(new TypeCompatibilityConstraint(targetType, this.myErased ? TypeConversionUtil.erasure(returnType) : returnType));
        }
    }

    private InferenceVariable shouldResolveAndInstantiate(PsiType returnType, PsiType targetType) {
        InferenceVariable inferenceVariable = this.getInferenceVariable(returnType);
        if (inferenceVariable != null) {
            if (targetType instanceof PsiPrimitiveType && InferenceSession.hasPrimitiveWrapperBound(inferenceVariable)) {
                return inferenceVariable;
            }
            if (targetType instanceof PsiClassType && (this.myErased || InferenceSession.hasUncheckedBounds(inferenceVariable, (PsiClassType)targetType) || InferenceSession.hasWildcardParameterization(inferenceVariable, (PsiClassType)targetType))) {
                return inferenceVariable;
            }
        }
        return null;
    }

    private static boolean hasPrimitiveWrapperBound(InferenceVariable inferenceVariable) {
        InferenceBound[] boundTypes;
        for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.UPPER, InferenceBound.LOWER}) {
            List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
            for (PsiType bound : bounds) {
                if (PsiPrimitiveType.getUnboxedType(bound) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasUncheckedBounds(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!targetType.isRaw()) {
            InferenceBound[] boundTypes;
            for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.EQ, InferenceBound.LOWER}) {
                List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
                for (PsiType bound : bounds) {
                    if (!TypeCompatibilityConstraint.isUncheckedConversion(targetType, bound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasWildcardParameterization(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(targetType)) {
            Processor<Pair<PsiType, PsiType>> differentParameterizationProcessor;
            List<PsiType> bounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            if (InferenceIncorporationPhase.findParameterizationOfTheSameGenericClass(bounds, differentParameterizationProcessor = new Processor<Pair<PsiType, PsiType>>(){

                @Override
                public boolean process(Pair<PsiType, PsiType> pair) {
                    return pair.first == null || pair.second == null || ((PsiType)pair.first).equals(pair.second);
                }
            })) {
                return true;
            }
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            for (PsiType lowBound : bounds) {
                if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(lowBound)) continue;
                for (PsiType bound : eqBounds) {
                    if (!lowBound.equals(bound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static PsiType getTargetType(PsiExpression context) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp(context.getParent());
        if (parent instanceof PsiExpressionList) {
            PsiExpressionList argumentList;
            PsiElement gParent = parent.getParent();
            if (gParent instanceof PsiAnonymousClass) {
                gParent = gParent.getParent();
            }
            if (gParent instanceof PsiCallExpression && (argumentList = ((PsiCallExpression)gParent).getArgumentList()) != null) {
                JavaResolveResult result = ((PsiCallExpression)gParent).resolveMethodGenerics();
                return InferenceSession.getTypeByMethod(context, argumentList, result, result.getElement());
            }
        } else {
            if (parent instanceof PsiConditionalExpression) {
                PsiType targetType = PsiTypesUtil.getExpectedTypeByParent((PsiExpression)parent);
                if (targetType == null) {
                    targetType = InferenceSession.getTargetType((PsiExpression)parent);
                }
                return targetType;
            }
            if (parent instanceof PsiLambdaExpression) {
                if (PsiUtil.skipParenthesizedExprUp(parent.getParent()) instanceof PsiExpressionList) {
                    PsiType typeTypeByParentCall = InferenceSession.getTargetType((PsiLambdaExpression)parent);
                    return LambdaUtil.getFunctionalInterfaceReturnType(FunctionalInterfaceParameterizationUtil.getGroundTargetType(typeTypeByParentCall, (PsiLambdaExpression)parent));
                }
                return LambdaUtil.getFunctionalInterfaceReturnType(((PsiLambdaExpression)parent).getFunctionalInterfaceType());
            }
        }
        return null;
    }

    private static PsiType getTypeByMethod(PsiExpression context, PsiExpressionList argumentList, final JavaResolveResult result, PsiElement parentMethod) {
        if (parentMethod instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)parentMethod).getParameterList().getParameters();
            if (parameters.length == 0) {
                return null;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (!((PsiMethod)parentMethod).isVarArgs() && parameters.length != args.length) {
                return null;
            }
            PsiElement arg = context;
            while (arg.getParent() instanceof PsiParenthesizedExpression) {
                arg = arg.getParent();
            }
            int i = ArrayUtilRt.find(args, arg);
            if (i < 0) {
                return null;
            }
            return InferenceSession.getParameterType(parameters, args, i, PsiResolveHelper.ourGraphGuard.doPreventingRecursion(argumentList.getParent(), false, new Computable<PsiSubstitutor>(){

                @Override
                public PsiSubstitutor compute() {
                    return result.getSubstitutor();
                }
            }));
        }
        return null;
    }

    public InferenceVariable getInferenceVariable(PsiType psiType) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(psiType);
        if (psiClass instanceof PsiTypeParameter) {
            return this.myInferenceVariables.get(psiClass);
        }
        return null;
    }

    public boolean isProperType(@Nullable PsiType type) {
        return this.collectDependencies(type, null);
    }

    public boolean collectDependencies(@Nullable PsiType type, final @Nullable Set<InferenceVariable> dependencies) {
        if (type == null) {
            return true;
        }
        Boolean isProper = type.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitType(PsiType type) {
                return true;
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }

            @Override
            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound == null) {
                    return true;
                }
                return bound.accept(this);
            }

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                InferenceVariable inferenceVariable = InferenceSession.this.getInferenceVariable(classType);
                if (inferenceVariable != null) {
                    if (dependencies != null) {
                        dependencies.add(inferenceVariable);
                        return true;
                    }
                    return false;
                }
                for (PsiType psiType : classType.getParameters()) {
                    if (psiType.accept(this).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        });
        return dependencies != null ? !dependencies.isEmpty() : isProper;
    }

    public boolean repeatInferencePhases(boolean incorporate) {
        do {
            if (this.reduceConstraints()) continue;
            return false;
        } while (this.myConstraintIdx < this.myConstraints.size());
        do {
            if (!this.reduceConstraints()) {
                return false;
            }
            if (!incorporate || this.myIncorporationPhase.incorporate()) continue;
            return false;
        } while (incorporate && !this.myIncorporationPhase.isFullyIncorporated() || this.myConstraintIdx < this.myConstraints.size());
        return true;
    }

    private boolean reduceConstraints() {
        ArrayList<ConstraintFormula> newConstraints = new ArrayList<ConstraintFormula>();
        for (int i = this.myConstraintIdx; i < this.myConstraints.size(); ++i) {
            ConstraintFormula constraint = this.myConstraints.get(i);
            if (constraint.reduce(this, newConstraints)) continue;
            return false;
        }
        this.myConstraintIdx = this.myConstraints.size();
        for (ConstraintFormula constraint : newConstraints) {
            this.addConstraint(constraint);
        }
        return true;
    }

    private boolean isThrowable(List<PsiType> upperBounds) {
        boolean commonThrowable = false;
        for (PsiType upperBound : upperBounds) {
            if (upperBound.equalsToText("java.lang.Object") || !this.isProperType(upperBound)) continue;
            if (upperBound.equalsToText("java.lang.Exception") || upperBound.equalsToText("java.lang.Throwable")) {
                commonThrowable = true;
                continue;
            }
            return false;
        }
        return commonThrowable;
    }

    private PsiType substituteNonProperBound(PsiType bound, PsiSubstitutor substitutor) {
        return this.isProperType(bound) ? bound : substitutor.substitute(bound);
    }

    private PsiSubstitutor resolveBounds(Collection<InferenceVariable> inferenceVariables, PsiSubstitutor substitutor) {
        ArrayList<InferenceVariable> allVars = new ArrayList<InferenceVariable>(inferenceVariables);
        while (!allVars.isEmpty()) {
            PsiSubstitutor firstSubstitutor;
            List<InferenceVariable> vars = InferenceVariablesOrder.resolveOrder(allVars, this);
            if (!this.myIncorporationPhase.hasCaptureConstraints(vars) && (firstSubstitutor = this.resolveSubset(vars, substitutor)) != null) {
                substitutor = firstSubstitutor;
                allVars.removeAll(vars);
                continue;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.getManager().getProject());
            for (InferenceVariable var : vars) {
                PsiTypeParameter parameter = var.getParameter();
                PsiTypeParameter copy = elementFactory.createTypeParameterFromText("z" + parameter.getName(), null);
                PsiType lub = this.getLowerBound(var, substitutor);
                PsiType glb = this.getUpperBound(var, substitutor);
                InferenceVariable zVariable = new InferenceVariable(copy);
                zVariable.addBound(glb, InferenceBound.UPPER);
                if (lub != PsiType.NULL) {
                    if (!TypeConversionUtil.isAssignable(glb, lub)) {
                        return null;
                    }
                    copy.putUserData(LOWER_BOUND, lub);
                    zVariable.addBound(lub, InferenceBound.LOWER);
                }
                this.myInferenceVariables.put(copy, zVariable);
                allVars.add(zVariable);
                var.addBound(elementFactory.createType(copy), InferenceBound.EQ);
            }
            this.myIncorporationPhase.forgetCaptures(vars);
            if (this.myIncorporationPhase.incorporate()) continue;
            return null;
        }
        return substitutor;
    }

    private PsiType getLowerBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.LOWER, new Function<Pair<PsiType, PsiType>, PsiType>(){

            @Override
            public PsiType fun(Pair<PsiType, PsiType> pair) {
                return GenericsUtil.getLeastUpperBound((PsiType)pair.first, (PsiType)pair.second, InferenceSession.this.myManager);
            }
        }, substitutor);
    }

    private PsiSubstitutor resolveSubset(Collection<InferenceVariable> vars, PsiSubstitutor substitutor) {
        for (InferenceVariable var : vars) {
            PsiType lub;
            LOG.assertTrue(var.getInstantiation() == PsiType.NULL);
            PsiTypeParameter typeParameter = var.getParameter();
            PsiType eqBound = this.getEqualsBound(var, substitutor);
            if (eqBound != PsiType.NULL && eqBound instanceof PsiPrimitiveType) continue;
            PsiType psiType = lub = eqBound != PsiType.NULL && (this.myErased || eqBound != null) ? eqBound : this.getLowerBound(var, substitutor);
            if (lub != PsiType.NULL) {
                substitutor = substitutor.put(typeParameter, lub);
                continue;
            }
            if (var.isThrownBound() && this.isThrowable(var.getBounds(InferenceBound.UPPER))) {
                PsiClassType runtimeException = PsiType.getJavaLangRuntimeException(this.myManager, GlobalSearchScope.allScope(this.myManager.getProject()));
                substitutor = substitutor.put(typeParameter, runtimeException);
                continue;
            }
            substitutor = substitutor.put(typeParameter, this.getUpperBound(var, substitutor));
        }
        return substitutor;
    }

    private PsiType getUpperBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.UPPER, new Function<Pair<PsiType, PsiType>, PsiType>(){

            @Override
            public PsiType fun(Pair<PsiType, PsiType> pair) {
                return GenericsUtil.getGreatestLowerBound((PsiType)pair.first, (PsiType)pair.second);
            }
        }, substitutor);
    }

    public PsiType getEqualsBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.EQ, new Function<Pair<PsiType, PsiType>, PsiType>(){

            @Override
            public PsiType fun(Pair<PsiType, PsiType> pair) {
                return (PsiType)pair.first;
            }
        }, substitutor);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor) {
        List<PsiType> lowerBounds = variable.getBounds(boundType);
        PsiType lub = PsiType.NULL;
        for (PsiType lowerBound : lowerBounds) {
            lowerBound = this.substituteNonProperBound(lowerBound, substitutor);
            HashSet<InferenceVariable> dependencies = new HashSet<InferenceVariable>();
            this.collectDependencies(lowerBound, dependencies);
            if (dependencies.size() == 1 && dependencies.contains(variable) && this.isInsideRecursiveCall(dependencies)) {
                lub = JavaPsiFacade.getElementFactory(this.myManager.getProject()).createType(variable.getParameter());
                continue;
            }
            if (!dependencies.isEmpty() && !this.isInsideRecursiveCall(dependencies)) continue;
            if (lub == PsiType.NULL) {
                lub = lowerBound;
                continue;
            }
            lub = fun.fun(Pair.create(lub, lowerBound));
        }
        return lub;
    }

    private boolean isInsideRecursiveCall(HashSet<InferenceVariable> dependencies) {
        for (InferenceVariable dependency : dependencies) {
            if (this.isInsideRecursiveCall(dependency.getParameter())) continue;
            return false;
        }
        return true;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public GlobalSearchScope getScope() {
        return GlobalSearchScope.allScope(this.myManager.getProject());
    }

    public Collection<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables.values();
    }

    public void addConstraint(ConstraintFormula constraint) {
        if (!this.myConstraints.contains(constraint)) {
            this.myConstraints.add(constraint);
        }
    }

    public Collection<PsiTypeParameter> getTypeParams() {
        return this.myInferenceVariables.keySet();
    }

    private boolean proceedWithAdditionalConstraints(Set<ConstraintFormula> additionalConstraints) {
        while (!additionalConstraints.isEmpty()) {
            Set<ConstraintFormula> subset = this.buildSubset(additionalConstraints);
            HashSet<InferenceVariable> varsToResolve = new HashSet<InferenceVariable>();
            for (ConstraintFormula formula : subset) {
                Set<InferenceVariable> inputVariables;
                if (!(formula instanceof InputOutputConstraintFormula) || (inputVariables = ((InputOutputConstraintFormula)formula).getInputVariables(this)) == null) continue;
                varsToResolve.addAll(inputVariables);
            }
            PsiSubstitutor substitutor = this.resolveSubset(varsToResolve, this.mySiteSubstitutor);
            if (substitutor == null) {
                return false;
            }
            if (this.myContext instanceof PsiCallExpression) {
                PsiExpressionList argumentList = ((PsiCallExpression)this.myContext).getArgumentList();
                LOG.assertTrue(argumentList != null);
                MethodCandidateInfo.updateSubstitutor(argumentList, substitutor);
            }
            for (ConstraintFormula additionalConstraint : subset) {
                additionalConstraint.apply(substitutor);
            }
            this.myConstraints.addAll(subset);
            if (this.repeatInferencePhases(true)) continue;
            return false;
        }
        return true;
    }

    private Set<ConstraintFormula> buildSubset(Set<ConstraintFormula> additionalConstraints) {
        Set<InferenceVariable> inputVariables;
        HashSet<ConstraintFormula> subset = new HashSet<ConstraintFormula>();
        HashSet<InferenceVariable> outputVariables = new HashSet<InferenceVariable>();
        for (ConstraintFormula constraint : additionalConstraints) {
            Set<InferenceVariable> outputVars;
            if (!(constraint instanceof InputOutputConstraintFormula) || (outputVars = ((InputOutputConstraintFormula)constraint).getOutputVariables(inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this), this)) == null) continue;
            outputVariables.addAll(outputVars);
        }
        for (ConstraintFormula constraint : additionalConstraints) {
            if (constraint instanceof InputOutputConstraintFormula) {
                inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this);
                if (inputVariables != null) {
                    boolean dependsOnOutput = false;
                    for (InferenceVariable inputVariable : inputVariables) {
                        Set<InferenceVariable> dependencies = inputVariable.getDependencies(this);
                        dependencies.add(inputVariable);
                        dependencies.retainAll(outputVariables);
                        if (dependencies.isEmpty()) continue;
                        dependsOnOutput = true;
                        break;
                    }
                    if (dependsOnOutput) continue;
                    subset.add(constraint);
                    continue;
                }
                subset.add(constraint);
                continue;
            }
            subset.add(constraint);
        }
        if (subset.isEmpty()) {
            subset.add(additionalConstraints.iterator().next());
        }
        additionalConstraints.removeAll(subset);
        return subset;
    }

    public void setErased() {
        this.myErased = true;
    }

    public InferenceVariable getInferenceVariable(PsiTypeParameter parameter) {
        return this.myInferenceVariables.get(parameter);
    }

    public static boolean isMoreSpecific(PsiMethod m1, PsiMethod m2, PsiSubstitutor siteSubstitutor2, PsiExpression[] args, PsiElement context, boolean varargs) {
        PsiTypeParameter[] typeParameters = m2.getTypeParameters();
        InferenceSession session = new InferenceSession(typeParameters, siteSubstitutor2, m2.getManager(), context);
        PsiParameter[] parameters1 = m1.getParameterList().getParameters();
        PsiParameter[] parameters2 = m2.getParameterList().getParameters();
        if (!varargs) {
            LOG.assertTrue(parameters1.length == parameters2.length);
        }
        int paramsLength = !varargs ? parameters1.length : parameters1.length - 1;
        for (int i = 0; i < paramsLength; ++i) {
            PsiType sType = siteSubstitutor2.substitute(parameters1[i].getType());
            PsiType tType = siteSubstitutor2.substitute(InferenceSession.getVarargParameterType(varargs, i, parameters2));
            if (session.isProperType(sType) && session.isProperType(tType)) {
                if (TypeConversionUtil.isAssignable(tType, sType)) continue;
                return false;
            }
            if (LambdaUtil.isFunctionalType(sType) && LambdaUtil.isFunctionalType(tType) && !InferenceSession.relates(sType, tType)) {
                if (InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, session, args)) continue;
                return false;
            }
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        if (varargs) {
            PsiType sType = siteSubstitutor2.substitute(parameters1[paramsLength].getType());
            PsiType tType = siteSubstitutor2.substitute(InferenceSession.getVarargParameterType(true, paramsLength, parameters2));
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        return session.repeatInferencePhases(true);
    }

    public static PsiType getVarargParameterType(boolean varargs, int i, PsiParameter[] parameters2) {
        if (varargs && i >= parameters2.length - 1) {
            PsiType lastParamType = parameters2[parameters2.length - 1].getType();
            LOG.assertTrue(lastParamType instanceof PsiEllipsisType);
            return ((PsiEllipsisType)lastParamType).getComponentType();
        }
        return parameters2[i].getType();
    }

    public static boolean isFunctionalTypeMoreSpecificOnExpression(PsiType sType, PsiType tType, PsiExpression arg) {
        return InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, null, arg);
    }

    private static boolean isFunctionalTypeMoreSpecific(PsiType sType, PsiType tType, @Nullable InferenceSession session, PsiExpression ... args) {
        PsiType capturedSType = sType;
        PsiClassType.ClassResolveResult sResult = PsiUtil.resolveGenericsClassInType(capturedSType);
        PsiMethod sInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(sResult);
        LOG.assertTrue(sInterfaceMethod != null);
        PsiSubstitutor sSubstitutor = LambdaUtil.getSubstitutor(sInterfaceMethod, sResult);
        PsiClassType.ClassResolveResult tResult = PsiUtil.resolveGenericsClassInType(tType);
        PsiMethod tInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(tResult);
        LOG.assertTrue(tInterfaceMethod != null);
        PsiSubstitutor tSubstitutor = LambdaUtil.getSubstitutor(tInterfaceMethod, tResult);
        for (PsiExpression arg : args) {
            if (InferenceSession.argConstraints(arg, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor)) continue;
            return false;
        }
        return true;
    }

    protected static boolean argConstraints(PsiExpression arg, @Nullable InferenceSession session, PsiMethod sInterfaceMethod, PsiSubstitutor sSubstitutor, PsiMethod tInterfaceMethod, PsiSubstitutor tSubstitutor) {
        if (arg instanceof PsiLambdaExpression && ((PsiLambdaExpression)arg).hasFormalParameterTypes()) {
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (tReturnType == PsiType.VOID) {
                return true;
            }
            if (sReturnType == PsiType.VOID && session != null) {
                return false;
            }
            if (LambdaUtil.isFunctionalType(sReturnType) && LambdaUtil.isFunctionalType(tReturnType) && !TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(sReturnType), TypeConversionUtil.erasure(tReturnType)) && !TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(tReturnType), TypeConversionUtil.erasure(sReturnType))) {
                List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)arg);
                if (!InferenceSession.isFunctionalTypeMoreSpecific(sReturnType, tReturnType, session, returnExpressions.toArray(new PsiExpression[returnExpressions.size()]))) {
                    return false;
                }
            } else {
                boolean sPrimitive = sReturnType instanceof PsiPrimitiveType;
                boolean tPrimitive = tReturnType instanceof PsiPrimitiveType;
                if (sPrimitive ^ tPrimitive) {
                    for (PsiExpression returnExpression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)arg)) {
                        if (PsiPolyExpressionUtil.isPolyExpression(returnExpression)) continue;
                        PsiType returnExpressionType = returnExpression.getType();
                        if (!(sPrimitive ? !(returnExpressionType instanceof PsiPrimitiveType) : !(returnExpressionType instanceof PsiClassType))) continue;
                        return false;
                    }
                    return true;
                }
                if (session != null) {
                    session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                    return true;
                }
                return TypeConversionUtil.isAssignable(sReturnType, tReturnType);
            }
        }
        if (arg instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)arg).isExact()) {
            boolean tPrimitive;
            PsiParameter[] sParameters = sInterfaceMethod.getParameterList().getParameters();
            PsiParameter[] tParameters = tInterfaceMethod.getParameterList().getParameters();
            if (session != null) {
                LOG.assertTrue(sParameters.length == tParameters.length);
                for (int i = 0; i < tParameters.length; ++i) {
                    session.addConstraint(new TypeEqualityConstraint(tSubstitutor.substitute(tParameters[i].getType()), sSubstitutor.substitute(sParameters[i].getType())));
                }
            }
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (tReturnType == PsiType.VOID) {
                return true;
            }
            if (sReturnType == PsiType.VOID && session != null) {
                return false;
            }
            boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && sReturnType != PsiType.VOID;
            boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && tReturnType != PsiType.VOID;
            if (sPrimitive ^ tPrimitive) {
                PsiMember member = ((PsiMethodReferenceExpression)arg).getPotentiallyApplicableMember();
                LOG.assertTrue(member != null);
                if (member instanceof PsiMethod) {
                    PsiType methodReturnType = ((PsiMethod)member).getReturnType();
                    if (sPrimitive && methodReturnType instanceof PsiPrimitiveType && methodReturnType != PsiType.VOID || tPrimitive && methodReturnType instanceof PsiClassType) {
                        return true;
                    }
                }
                return false;
            }
            if (session != null) {
                session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                return true;
            }
            return TypeConversionUtil.isAssignable(sReturnType, tReturnType);
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return InferenceSession.argConstraints(((PsiParenthesizedExpression)arg).getExpression(), session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        if (arg instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)arg).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)arg).getElseExpression();
            return InferenceSession.argConstraints(thenExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor) && InferenceSession.argConstraints(elseExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        return false;
    }

    private static boolean relates(PsiType sType, PsiType tType) {
        PsiType sTypeErasure;
        PsiType erasedType = TypeConversionUtil.erasure(tType);
        LOG.assertTrue(erasedType != null);
        if (sType instanceof PsiIntersectionType) {
            boolean superRelation = true;
            boolean subRelation = false;
            for (PsiType sConjunct : ((PsiIntersectionType)sType).getConjuncts()) {
                PsiType sConjunctErasure = TypeConversionUtil.erasure(sConjunct);
                if (sConjunctErasure == null) continue;
                superRelation &= TypeConversionUtil.isAssignable(sConjunctErasure, erasedType);
                subRelation |= TypeConversionUtil.isAssignable(erasedType, sConjunctErasure);
            }
            return superRelation || subRelation;
        }
        if (sType instanceof PsiClassType && (sTypeErasure = TypeConversionUtil.erasure(sType)) != null) {
            return TypeConversionUtil.isAssignable(sTypeErasure, erasedType) || TypeConversionUtil.isAssignable(erasedType, sTypeErasure);
        }
        return false;
    }

    public void collectCaptureDependencies(InferenceVariable inferenceVariable, Set<InferenceVariable> dependencies) {
        this.myIncorporationPhase.collectCaptureDependencies(inferenceVariable, dependencies);
    }

    public boolean hasCapture(InferenceVariable inferenceVariable) {
        return this.myIncorporationPhase.hasCaptureConstraints(Arrays.asList(inferenceVariable));
    }

    public void liftBounds(Collection<InferenceVariable> variables) {
        for (InferenceVariable variable : variables) {
            PsiTypeParameter parameter = variable.getParameter();
            InferenceVariable inferenceVariable = this.getInferenceVariable(parameter);
            if (inferenceVariable != null) {
                for (InferenceBound boundType : InferenceBound.values()) {
                    for (PsiType bound : variable.getBounds(boundType)) {
                        inferenceVariable.addBound(bound, boundType);
                    }
                }
                continue;
            }
            this.myInferenceVariables.put(parameter, variable);
        }
    }

    public static boolean wasUncheckedConversionPerformed(PsiElement call) {
        Boolean erased = call.getUserData(ERASED);
        return erased != null && erased != false;
    }
}

