/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.repl;

import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.testFramework.LightVirtualFile;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.OutputFile;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageCollectorToString;
import org.jetbrains.jet.cli.jvm.JVMConfigurationKeys;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.cli.jvm.repl.EarlierLine;
import org.jetbrains.jet.cli.jvm.repl.ReplClassLoader;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilderFactories;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.KotlinCodegenFacade;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.config.CompilerConfiguration;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerForJvm;
import org.jetbrains.jet.lang.descriptors.DependencyKind;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PackageLikeBuilderDummy;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.ScriptHeaderResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.java.AnalyzerFacadeForJVM;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.lang.InlineUtil;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.plugin.JetLanguage;
import org.jetbrains.jet.storage.ExceptionTracker;
import org.jetbrains.jet.storage.LockBasedStorageManager;
import org.jetbrains.jet.utils.UtilsPackage;

public class ReplInterpreter {
    private int lineNumber;
    @Nullable
    private JetScope lastLineScope;
    private List<EarlierLine> earlierLines;
    private List<String> previousIncompleteLines;
    private final ReplClassLoader classLoader;
    @NotNull
    private final InjectorForTopDownAnalyzerForJvm injector;
    @NotNull
    private final TopDownAnalysisContext topDownAnalysisContext;
    @NotNull
    private final JetCoreEnvironment jetCoreEnvironment;
    @NotNull
    private final BindingTraceContext trace;
    @NotNull
    private final ModuleDescriptorImpl module;

    public ReplInterpreter(@NotNull Disposable disposable, @NotNull CompilerConfiguration configuration) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "<init>"));
        }
        this.lineNumber = 0;
        this.earlierLines = Lists.newArrayList();
        this.previousIncompleteLines = Lists.newArrayList();
        this.jetCoreEnvironment = JetCoreEnvironment.createForProduction(disposable, configuration);
        Project project = this.jetCoreEnvironment.getProject();
        this.trace = new BindingTraceContext();
        this.module = AnalyzerFacadeForJVM.createJavaModule("<repl>");
        TopDownAnalysisParameters topDownAnalysisParameters = new TopDownAnalysisParameters(new LockBasedStorageManager(), new ExceptionTracker(), Predicates.<PsiFile>alwaysTrue(), false, true, Collections.<AnalyzerScriptParameter>emptyList());
        this.injector = new InjectorForTopDownAnalyzerForJvm(project, topDownAnalysisParameters, this.trace, this.module);
        this.topDownAnalysisContext = new TopDownAnalysisContext(topDownAnalysisParameters);
        this.module.addFragmentProvider(DependencyKind.SOURCES, this.injector.getTopDownAnalyzer().getPackageFragmentProvider());
        this.module.addFragmentProvider(DependencyKind.BUILT_INS, KotlinBuiltIns.getInstance().getBuiltInsModule().getPackageFragmentProvider());
        this.module.addFragmentProvider(DependencyKind.BINARIES, this.injector.getJavaDescriptorResolver().getPackageFragmentProvider());
        ArrayList<URL> classpath = Lists.newArrayList();
        for (File file : configuration.getList(JVMConfigurationKeys.CLASSPATH_KEY)) {
            try {
                classpath.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw UtilsPackage.rethrow(e);
            }
        }
        this.classLoader = new ReplClassLoader(new URLClassLoader(classpath.toArray(new URL[0])));
    }

    @NotNull
    public LineResult eval(@NotNull String line) {
        Object scriptInstance;
        Class<?> scriptClass;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "eval"));
        }
        ++this.lineNumber;
        FqName scriptFqName = new FqName("Line" + this.lineNumber);
        Type scriptClassType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(scriptFqName);
        StringBuilder fullText = new StringBuilder();
        for (String prevLine : this.previousIncompleteLines) {
            fullText.append(prevLine + "\n");
        }
        fullText.append(line);
        LightVirtualFile virtualFile = new LightVirtualFile("line" + this.lineNumber + ".ktscript", JetLanguage.INSTANCE, (CharSequence)fullText.toString());
        virtualFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        JetFile psiFile = (JetFile)((PsiFileFactoryImpl)PsiFileFactory.getInstance(this.jetCoreEnvironment.getProject())).trySetupPsiForFile(virtualFile, JetLanguage.INSTANCE, true, false);
        MessageCollectorToString errorCollector = new MessageCollectorToString();
        AnalyzerWithCompilerReport.SyntaxErrorReport syntaxErrorReport = AnalyzerWithCompilerReport.reportSyntaxErrors(psiFile, errorCollector);
        if (syntaxErrorReport.isOnlyErrorAtEof()) {
            this.previousIncompleteLines.add(line);
            LineResult lineResult = LineResult.incomplete();
            if (lineResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "eval"));
            }
            return lineResult;
        }
        this.previousIncompleteLines.clear();
        if (syntaxErrorReport.isHasErrors()) {
            LineResult lineResult = LineResult.error(errorCollector.getString());
            if (lineResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "eval"));
            }
            return lineResult;
        }
        this.injector.getTopDownAnalyzer().prepareForTheNextReplLine(this.topDownAnalysisContext);
        this.trace.clearDiagnostics();
        psiFile.getScript().putUserData(ScriptHeaderResolver.PRIORITY_KEY, this.lineNumber);
        ScriptDescriptor scriptDescriptor = this.doAnalyze(psiFile, errorCollector);
        if (scriptDescriptor == null) {
            LineResult lineResult = LineResult.error(errorCollector.getString());
            if (lineResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "eval"));
            }
            return lineResult;
        }
        ArrayList<Pair<ScriptDescriptor, Type>> earlierScripts = Lists.newArrayList();
        for (EarlierLine earlierLine : this.earlierLines) {
            earlierScripts.add(Pair.create(earlierLine.getScriptDescriptor(), earlierLine.getClassType()));
        }
        BindingContext bindingContext = AnalyzeExhaust.success(this.trace.getBindingContext(), this.module).getBindingContext();
        GenerationState generationState = new GenerationState(psiFile.getProject(), ClassBuilderFactories.BINARIES, bindingContext, Collections.singletonList(psiFile), InlineUtil.DEFAULT_INLINE_FLAG);
        ReplInterpreter.compileScript(psiFile.getScript(), scriptClassType, earlierScripts, generationState, CompilationErrorHandler.THROW_EXCEPTION);
        for (OutputFile outputFile : generationState.getFactory().asList()) {
            this.classLoader.addClass(JvmClassName.byInternalName(outputFile.getRelativePath().replaceFirst("\\.class$", "")), outputFile.asByteArray());
        }
        try {
            scriptClass = this.classLoader.loadClass(scriptFqName.asString());
            Class[] constructorParams = new Class[this.earlierLines.size()];
            Object[] constructorArgs = new Object[this.earlierLines.size()];
            for (int i = 0; i < this.earlierLines.size(); ++i) {
                constructorParams[i] = this.earlierLines.get(i).getScriptClass();
                constructorArgs[i] = this.earlierLines.get(i).getScriptInstance();
            }
            Constructor<?> scriptInstanceConstructor = scriptClass.getConstructor(constructorParams);
            try {
                scriptInstance = scriptInstanceConstructor.newInstance(constructorArgs);
            }
            catch (Throwable e) {
                LineResult lineResult = LineResult.error(Throwables.getStackTraceAsString(e));
                if (lineResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "eval"));
                }
                return lineResult;
            }
        }
        catch (Throwable e) {
            PrintWriter writer = new PrintWriter(System.err);
            this.classLoader.dumpClasses(writer);
            writer.flush();
            throw UtilsPackage.rethrow(e);
        }
        Field rvField = scriptClass.getDeclaredField("rv");
        rvField.setAccessible(true);
        Object rv = rvField.get(scriptInstance);
        this.earlierLines.add(new EarlierLine(line, scriptDescriptor, scriptClass, scriptInstance, scriptClassType));
        LineResult lineResult = LineResult.successful(rv, ((Object)scriptDescriptor.getReturnType()).equals(KotlinBuiltIns.getInstance().getUnitType()));
        if (lineResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "eval"));
        }
        return lineResult;
    }

    @Nullable
    private ScriptDescriptor doAnalyze(@NotNull JetFile psiFile, @NotNull MessageCollector messageCollector) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "doAnalyze"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "doAnalyze"));
        }
        WritableScopeImpl scope = new WritableScopeImpl(JetScope.EMPTY, this.module, new TraceBasedRedeclarationHandler(this.trace), "Root scope in analyzePackage");
        scope.changeLockLevel(WritableScope.LockLevel.BOTH);
        scope.importScope(this.module.getPackage(FqName.ROOT).getMemberScope());
        if (this.lastLineScope != null) {
            scope.importScope(this.lastLineScope);
        }
        scope.changeLockLevel(WritableScope.LockLevel.READING);
        this.injector.getTopDownAnalyzer().doProcess(this.topDownAnalysisContext, scope, new PackageLikeBuilderDummy(), Collections.singletonList(psiFile));
        boolean hasErrors = AnalyzerWithCompilerReport.reportDiagnostics(this.trace.getBindingContext(), messageCollector);
        if (hasErrors) {
            return null;
        }
        ScriptDescriptor scriptDescriptor = this.topDownAnalysisContext.getScripts().get(psiFile.getScript());
        this.lastLineScope = this.trace.get(BindingContext.SCRIPT_SCOPE, scriptDescriptor);
        if (this.lastLineScope == null) {
            throw new IllegalStateException("last line scope is not initialized");
        }
        return scriptDescriptor;
    }

    public void dumpClasses(@NotNull PrintWriter out) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "dumpClasses"));
        }
        this.classLoader.dumpClasses(out);
    }

    private static void registerEarlierScripts(@NotNull GenerationState state, @NotNull List<Pair<ScriptDescriptor, Type>> earlierScripts) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "registerEarlierScripts"));
        }
        if (earlierScripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "earlierScripts", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "registerEarlierScripts"));
        }
        for (Pair<ScriptDescriptor, Type> t : earlierScripts) {
            ScriptDescriptor earlierDescriptor = (ScriptDescriptor)t.first;
            Type earlierClassType = (Type)t.second;
            CodegenBinding.registerClassNameForScript(state.getBindingTrace(), earlierDescriptor, earlierClassType);
        }
        ArrayList<ScriptDescriptor> earlierScriptDescriptors = Lists.newArrayList();
        for (Pair<ScriptDescriptor, Type> t : earlierScripts) {
            ScriptDescriptor earlierDescriptor = (ScriptDescriptor)t.first;
            earlierScriptDescriptors.add(earlierDescriptor);
        }
        state.setEarlierScriptsForReplInterpreter(earlierScriptDescriptors);
    }

    public static void compileScript(@NotNull JetScript script, @NotNull Type classType, @NotNull List<Pair<ScriptDescriptor, Type>> earlierScripts, @NotNull GenerationState state, @NotNull CompilationErrorHandler errorHandler) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "compileScript"));
        }
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "compileScript"));
        }
        if (earlierScripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "earlierScripts", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "compileScript"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "compileScript"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter", "compileScript"));
        }
        ReplInterpreter.registerEarlierScripts(state, earlierScripts);
        CodegenBinding.registerClassNameForScript(state.getBindingTrace(), script, classType);
        state.beforeCompile();
        KotlinCodegenFacade.generatePackage(state, JetPsiUtil.getFQName((JetFile)script.getContainingFile()), Collections.singleton((JetFile)script.getContainingFile()), errorHandler);
    }

    public static class LineResult {
        private final Object value;
        private final boolean unit;
        private final String errorText;
        @NotNull
        private final LineResultType type;

        private LineResult(Object value, boolean unit, String errorText, @NotNull LineResultType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter$LineResult", "<init>"));
            }
            this.value = value;
            this.unit = unit;
            this.errorText = errorText;
            this.type = type;
        }

        @NotNull
        public LineResultType getType() {
            LineResultType lineResultType = this.type;
            if (lineResultType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter$LineResult", "getType"));
            }
            return lineResultType;
        }

        private void checkSuccessful() {
            if (this.getType() != LineResultType.SUCCESS) {
                throw new IllegalStateException("it is error");
            }
        }

        public Object getValue() {
            this.checkSuccessful();
            return this.value;
        }

        public boolean isUnit() {
            this.checkSuccessful();
            return this.unit;
        }

        @NotNull
        public String getErrorText() {
            String string = this.errorText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter$LineResult", "getErrorText"));
            }
            return string;
        }

        public static LineResult successful(Object value, boolean unit) {
            return new LineResult(value, unit, null, LineResultType.SUCCESS);
        }

        public static LineResult error(@NotNull String errorText) {
            if (errorText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorText", "org/jetbrains/jet/cli/jvm/repl/ReplInterpreter$LineResult", "error"));
            }
            if (errorText.isEmpty()) {
                errorText = "<unknown error>";
            } else if (!errorText.endsWith("\n")) {
                errorText = errorText + "\n";
            }
            return new LineResult(null, false, errorText, LineResultType.ERROR);
        }

        public static LineResult incomplete() {
            return new LineResult(null, false, null, LineResultType.INCOMPLETE);
        }
    }

    public static enum LineResultType {
        SUCCESS,
        ERROR,
        INCOMPLETE;

    }
}

