/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Lists;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.OutputFile;
import org.jetbrains.jet.OutputFileCollection;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderFactory;
import org.jetbrains.jet.codegen.ClassBuilderOnDemand;
import org.jetbrains.jet.codegen.PackageCodegen;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.GenerationStateAware;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;

public final class ClassFileFactory
extends GenerationStateAware
implements OutputFileCollection {
    @NotNull
    private ClassBuilderFactory builderFactory;
    private final Map<FqName, PackageCodegen> package2codegen;
    private final Map<String, ClassBuilderAndSourceFileList> generators;
    private boolean isDone;

    public ClassFileFactory(@NotNull GenerationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/ClassFileFactory", "<init>"));
        }
        super(state);
        this.package2codegen = new HashMap<FqName, PackageCodegen>();
        this.generators = new LinkedHashMap<String, ClassBuilderAndSourceFileList>();
        this.isDone = false;
    }

    public void setBuilderFactory(@NotNull ClassBuilderFactory builderFactory) {
        if (builderFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builderFactory", "org/jetbrains/jet/codegen/ClassFileFactory", "setBuilderFactory"));
        }
        this.builderFactory = builderFactory;
    }

    @NotNull
    ClassBuilder newVisitor(@NotNull Type asmType, @NotNull PsiFile sourceFile) {
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/jet/codegen/ClassFileFactory", "newVisitor"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "org/jetbrains/jet/codegen/ClassFileFactory", "newVisitor"));
        }
        ClassBuilder classBuilder = this.newVisitor(asmType, Collections.singletonList(sourceFile));
        if (classBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory", "newVisitor"));
        }
        return classBuilder;
    }

    @NotNull
    private ClassBuilder newVisitor(@NotNull Type asmType, @NotNull Collection<? extends PsiFile> sourceFiles) {
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/jet/codegen/ClassFileFactory", "newVisitor"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/jet/codegen/ClassFileFactory", "newVisitor"));
        }
        String outputFilePath = asmType.getInternalName() + ".class";
        this.state.getProgress().reportOutput(ClassFileFactory.toIoFilesIgnoringNonPhysical(sourceFiles), new File(outputFilePath));
        ClassBuilder answer = this.builderFactory.newClassBuilder();
        this.generators.put(outputFilePath, new ClassBuilderAndSourceFileList(answer, sourceFiles));
        ClassBuilder classBuilder = answer;
        if (classBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory", "newVisitor"));
        }
        return classBuilder;
    }

    void done() {
        if (!this.isDone) {
            this.isDone = true;
            for (PackageCodegen codegen : this.package2codegen.values()) {
                codegen.done();
            }
        }
    }

    @Override
    @NotNull
    public List<OutputFile> asList() {
        this.done();
        List<OutputFile> list = ContainerUtil.map(this.generators.keySet(), new Function<String, OutputFile>(){

            @Override
            public OutputFile fun(String relativeClassFilePath) {
                return new OutputClassFile(relativeClassFilePath);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory", "asList"));
        }
        return list;
    }

    @Override
    @Nullable
    public OutputFile get(@NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/jet/codegen/ClassFileFactory", "get"));
        }
        if (this.generators.containsKey(relativePath)) {
            return new OutputClassFile(relativePath);
        }
        return null;
    }

    public String createText() {
        StringBuilder answer = new StringBuilder();
        for (OutputFile file : this.asList()) {
            answer.append("@").append(file.getRelativePath()).append('\n');
            answer.append(file.asText());
        }
        return answer.toString();
    }

    public PackageCodegen forPackage(final FqName fqName, final Collection<JetFile> files) {
        assert (!this.isDone) : "Already done!";
        PackageCodegen codegen = this.package2codegen.get(fqName);
        if (codegen == null) {
            ClassBuilderOnDemand onDemand = new ClassBuilderOnDemand(){

                @Override
                @NotNull
                protected ClassBuilder createClassBuilder() {
                    ClassBuilder classBuilder = ClassFileFactory.this.newVisitor(AsmUtil.asmTypeByFqNameWithoutInnerClasses(PackageClassUtils.getPackageClassFqName(fqName)), files);
                    if (classBuilder == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory$2", "createClassBuilder"));
                    }
                    return classBuilder;
                }
            };
            codegen = new PackageCodegen(onDemand, fqName, this.state, files);
            this.package2codegen.put(fqName, codegen);
        }
        return codegen;
    }

    public ClassBuilder forClassImplementation(ClassDescriptor aClass, PsiFile sourceFile) {
        Type type = this.state.getTypeMapper().mapClass(aClass);
        if (AsmUtil.isPrimitive(type)) {
            throw new IllegalStateException("Codegen for primitive type is not possible: " + aClass);
        }
        return this.newVisitor(type, sourceFile);
    }

    public ClassBuilder forLambdaInlining(Type lambaType, PsiFile sourceFile) {
        if (AsmUtil.isPrimitive(lambaType)) {
            throw new IllegalStateException("Codegen for primitive type is not possible: " + lambaType);
        }
        return this.newVisitor(lambaType, sourceFile);
    }

    @NotNull
    public ClassBuilder forPackagePart(@NotNull Type asmType, @NotNull PsiFile sourceFile) {
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/jet/codegen/ClassFileFactory", "forPackagePart"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "org/jetbrains/jet/codegen/ClassFileFactory", "forPackagePart"));
        }
        ClassBuilder classBuilder = this.newVisitor(asmType, sourceFile);
        if (classBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory", "forPackagePart"));
        }
        return classBuilder;
    }

    @NotNull
    public ClassBuilder forTraitImplementation(@NotNull ClassDescriptor aClass, @NotNull GenerationState state, @NotNull PsiFile file) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/jet/codegen/ClassFileFactory", "forTraitImplementation"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/ClassFileFactory", "forTraitImplementation"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/ClassFileFactory", "forTraitImplementation"));
        }
        ClassBuilder classBuilder = this.newVisitor(state.getTypeMapper().mapTraitImpl(aClass), file);
        if (classBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory", "forTraitImplementation"));
        }
        return classBuilder;
    }

    private static Collection<File> toIoFilesIgnoringNonPhysical(Collection<? extends PsiFile> psiFiles) {
        ArrayList<File> result = Lists.newArrayList();
        for (PsiFile psiFile : psiFiles) {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) continue;
            result.add(new File(virtualFile.getPath()));
        }
        return result;
    }

    public void removeInlinedClasses(Set<String> classNamesToRemove) {
        for (String classInternalName : classNamesToRemove) {
            this.generators.remove(classInternalName + ".class");
        }
    }

    private static final class ClassBuilderAndSourceFileList {
        private final ClassBuilder classBuilder;
        private final Collection<? extends PsiFile> sourceFiles;

        private ClassBuilderAndSourceFileList(ClassBuilder classBuilder, Collection<? extends PsiFile> sourceFiles) {
            this.classBuilder = classBuilder;
            this.sourceFiles = sourceFiles;
        }
    }

    private final class OutputClassFile
    implements OutputFile {
        final String relativeClassFilePath;

        OutputClassFile(String relativeClassFilePath) {
            this.relativeClassFilePath = relativeClassFilePath;
        }

        @Override
        @NotNull
        public String getRelativePath() {
            String string = this.relativeClassFilePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory$OutputClassFile", "getRelativePath"));
            }
            return string;
        }

        @Override
        @NotNull
        public List<File> getSourceFiles() {
            ClassBuilderAndSourceFileList pair = (ClassBuilderAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath);
            if (pair == null) {
                throw new IllegalStateException("No record for binary file " + this.relativeClassFilePath);
            }
            List<File> list = ContainerUtil.mapNotNull(pair.sourceFiles, new Function<PsiFile, File>(){

                @Override
                public File fun(PsiFile file) {
                    VirtualFile virtualFile = file.getVirtualFile();
                    if (virtualFile == null) {
                        return null;
                    }
                    return VfsUtilCore.virtualToIoFile(virtualFile);
                }
            });
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory$OutputClassFile", "getSourceFiles"));
            }
            return list;
        }

        @Override
        @NotNull
        public byte[] asByteArray() {
            byte[] byArray = ClassFileFactory.this.builderFactory.asBytes(((ClassBuilderAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath)).classBuilder);
            if (byArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory$OutputClassFile", "asByteArray"));
            }
            return byArray;
        }

        @Override
        @NotNull
        public String asText() {
            String string = ClassFileFactory.this.builderFactory.asText(((ClassBuilderAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath)).classBuilder);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory$OutputClassFile", "asText"));
            }
            return string;
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.getRelativePath() + " (compiled from " + this.getSourceFiles() + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/ClassFileFactory$OutputClassFile", "toString"));
            }
            return string;
        }
    }
}

