/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.codegen.inline.CapturedParamInfo;
import org.jetbrains.jet.codegen.inline.ParameterInfo;

public class Parameters
implements Iterable<ParameterInfo> {
    private final List<ParameterInfo> real;
    private final List<CapturedParamInfo> captured;

    public Parameters(List<ParameterInfo> real, List<CapturedParamInfo> captured) {
        this.real = real;
        this.captured = captured;
    }

    public List<ParameterInfo> getReal() {
        return this.real;
    }

    public List<CapturedParamInfo> getCaptured() {
        return this.captured;
    }

    public int totalSize() {
        return this.real.size() + this.captured.size();
    }

    public ParameterInfo get(int index) {
        if (index < this.real.size()) {
            return this.real.get(index);
        }
        return this.captured.get(index - this.real.size());
    }

    @Override
    @NotNull
    public Iterator<ParameterInfo> iterator() {
        Iterator<ParameterInfo> iterator2 = Iterables.concat(this.real, this.captured).iterator();
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/Parameters", "iterator"));
        }
        return iterator2;
    }

    public static List<CapturedParamInfo> shiftAndAddStubs(List<CapturedParamInfo> capturedParams, int realSize) {
        ArrayList<CapturedParamInfo> result = new ArrayList<CapturedParamInfo>();
        for (CapturedParamInfo capturedParamInfo : capturedParams) {
            CapturedParamInfo newInfo = capturedParamInfo.newIndex(result.size() + realSize);
            result.add(newInfo);
            if (capturedParamInfo.getType().getSize() != 2) continue;
            result.add(CapturedParamInfo.STUB);
        }
        return result;
    }

    public static List<ParameterInfo> addStubs(List<ParameterInfo> params) {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        for (ParameterInfo newInfo : params) {
            result.add(newInfo);
            if (newInfo.getType().getSize() != 2) continue;
            result.add(ParameterInfo.STUB);
        }
        return result;
    }

    public ArrayList<Type> getCapturedTypes() {
        ArrayList<Type> result = new ArrayList<Type>();
        for (CapturedParamInfo info : this.captured) {
            if (info == CapturedParamInfo.STUB) continue;
            Type type = info.getType();
            result.add(type);
        }
        return result;
    }
}

