/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassData;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.DescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentProvider;
import org.jetbrains.jet.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.storage.StorageManager;

public abstract class AbstractDescriptorFinder
implements DescriptorFinder {
    private final MemoizedFunctionToNullable<ClassId, ClassDescriptor> findClass;
    private final AnnotationDeserializer annotationDeserializer;

    public AbstractDescriptorFinder(final @NotNull StorageManager storageManager, @NotNull AnnotationDeserializer annotationDeserializer, final @NotNull PackageFragmentProvider packageFragmentProvider) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/descriptors/serialization/AbstractDescriptorFinder", "<init>"));
        }
        if (annotationDeserializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationDeserializer", "org/jetbrains/jet/descriptors/serialization/AbstractDescriptorFinder", "<init>"));
        }
        if (packageFragmentProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFragmentProvider", "org/jetbrains/jet/descriptors/serialization/AbstractDescriptorFinder", "<init>"));
        }
        this.annotationDeserializer = annotationDeserializer;
        this.findClass = storageManager.createMemoizedFunctionWithNullableValues(new Function1<ClassId, ClassDescriptor>(){

            @Override
            public ClassDescriptor invoke(ClassId classId) {
                ClassData classData = AbstractDescriptorFinder.this.getClassData(classId);
                if (classData == null) {
                    return null;
                }
                AbstractDescriptorFinder _this = AbstractDescriptorFinder.this;
                return new DeserializedClassDescriptor(storageManager, _this.annotationDeserializer, _this, packageFragmentProvider, classData.getNameResolver(), classData.getClassProto());
            }
        });
    }

    @Override
    @Nullable
    public ClassDescriptor findClass(@NotNull ClassId classId) {
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/jet/descriptors/serialization/AbstractDescriptorFinder", "findClass"));
        }
        return (ClassDescriptor)this.findClass.invoke(classId);
    }

    @Nullable
    protected abstract ClassData getClassData(@NotNull ClassId var1);
}

