/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Function0;
import kotlin.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.DescriptorDeserializer;
import org.jetbrains.jet.descriptors.serialization.Flags;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.StorageManager;
import org.jetbrains.jet.utils.Printer;

public abstract class DeserializedMemberScope
implements JetScope {
    private static final Filter<ProtoBuf.Callable.CallableKind> FUNCTION = new Filter<ProtoBuf.Callable.CallableKind>(){

        @Override
        public boolean accept(ProtoBuf.Callable.CallableKind value) {
            return value == ProtoBuf.Callable.CallableKind.FUN;
        }
    };
    private static final Filter<ProtoBuf.Callable.CallableKind> PROPERTY = new Filter<ProtoBuf.Callable.CallableKind>(){

        @Override
        public boolean accept(ProtoBuf.Callable.CallableKind value) {
            return value == ProtoBuf.Callable.CallableKind.VAL || value == ProtoBuf.Callable.CallableKind.VAR;
        }
    };
    private final DeclarationDescriptor containingDeclaration;
    private final DescriptorDeserializer deserializer;
    private final Map<Name, List<ProtoBuf.Callable>> membersProtos;
    private final MemoizedFunctionToNotNull<Name, Collection<FunctionDescriptor>> functions;
    private final MemoizedFunctionToNotNull<Name, Collection<VariableDescriptor>> properties;
    private final NotNullLazyValue<Collection<DeclarationDescriptor>> allDescriptors;

    public DeserializedMemberScope(@NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull DescriptorDeserializer deserializer, @NotNull List<ProtoBuf.Callable> membersList) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "<init>"));
        }
        if (deserializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deserializer", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "<init>"));
        }
        if (membersList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersList", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "<init>"));
        }
        this.containingDeclaration = containingDeclaration;
        this.deserializer = deserializer;
        this.membersProtos = this.groupByName(membersList);
        this.functions = storageManager.createMemoizedFunction(new Function1<Name, Collection<FunctionDescriptor>>(){

            @Override
            public Collection<FunctionDescriptor> invoke(Name name) {
                return DeserializedMemberScope.this.computeFunctions(name);
            }
        });
        this.properties = storageManager.createMemoizedFunction(new Function1<Name, Collection<VariableDescriptor>>(){

            @Override
            public Collection<VariableDescriptor> invoke(Name name) {
                return DeserializedMemberScope.this.computeProperties(name);
            }
        });
        this.allDescriptors = storageManager.createLazyValue(new Function0<Collection<DeclarationDescriptor>>(){

            @Override
            public Collection<DeclarationDescriptor> invoke() {
                return DeserializedMemberScope.this.computeAllDescriptors();
            }
        });
    }

    @NotNull
    private Map<Name, List<ProtoBuf.Callable>> groupByName(@NotNull Collection<ProtoBuf.Callable> membersList) {
        if (membersList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersList", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "groupByName"));
        }
        HashMap<Name, List<ProtoBuf.Callable>> map = new HashMap<Name, List<ProtoBuf.Callable>>();
        for (ProtoBuf.Callable memberProto : membersList) {
            Name name = this.deserializer.getNameResolver().getName(memberProto.getName());
            ArrayList<ProtoBuf.Callable> protos = (ArrayList<ProtoBuf.Callable>)map.get(name);
            if (protos == null) {
                protos = new ArrayList<ProtoBuf.Callable>(1);
                map.put(name, protos);
            }
            protos.add(memberProto);
        }
        HashMap<Name, List<ProtoBuf.Callable>> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "groupByName"));
        }
        return hashMap;
    }

    @NotNull
    private <D extends CallableMemberDescriptor> Collection<D> computeMembersByName(Name name, Filter<ProtoBuf.Callable.CallableKind> callableKind) {
        List<ProtoBuf.Callable> memberProtos = this.membersProtos.get(name);
        LinkedHashSet<CallableMemberDescriptor> descriptors = new LinkedHashSet<CallableMemberDescriptor>(memberProtos != null ? memberProtos.size() : 0);
        if (memberProtos != null) {
            for (ProtoBuf.Callable memberProto : memberProtos) {
                if (!callableKind.accept(Flags.CALLABLE_KIND.get(memberProto.getFlags()))) continue;
                descriptors.add(this.deserializer.loadCallable(memberProto));
            }
        }
        LinkedHashSet<CallableMemberDescriptor> linkedHashSet = descriptors;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeMembersByName"));
        }
        return linkedHashSet;
    }

    @NotNull
    private Collection<FunctionDescriptor> computeFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeFunctions"));
        }
        Collection<FunctionDescriptor> descriptors = this.computeMembersByName(name, FUNCTION);
        this.computeNonDeclaredFunctions(name, descriptors);
        Collection<FunctionDescriptor> collection = descriptors;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeFunctions"));
        }
        return collection;
    }

    protected void computeNonDeclaredFunctions(@NotNull Name name, @NotNull Collection<FunctionDescriptor> functions2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeNonDeclaredFunctions"));
        }
        if (functions2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeNonDeclaredFunctions"));
        }
    }

    @Override
    @NotNull
    public final Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getFunctions"));
        }
        Collection collection = (Collection)this.functions.invoke(name);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getFunctions"));
        }
        return collection;
    }

    @NotNull
    private Collection<VariableDescriptor> computeProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeProperties"));
        }
        Collection<VariableDescriptor> descriptors = this.computeMembersByName(name, PROPERTY);
        this.computeNonDeclaredProperties(name, descriptors);
        Collection<VariableDescriptor> collection = descriptors;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeProperties"));
        }
        return collection;
    }

    protected void computeNonDeclaredProperties(@NotNull Name name, @NotNull Collection<PropertyDescriptor> descriptors) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeNonDeclaredProperties"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "computeNonDeclaredProperties"));
        }
    }

    @Override
    @NotNull
    public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getProperties"));
        }
        Collection collection = (Collection)this.properties.invoke(name);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getProperties"));
        }
        return collection;
    }

    @Override
    @Nullable
    public final ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getClassifier"));
        }
        return this.getClassDescriptor(name);
    }

    @Nullable
    protected abstract ClassifierDescriptor getClassDescriptor(@NotNull Name var1);

    protected abstract void addAllClassDescriptors(@NotNull Collection<DeclarationDescriptor> var1);

    @Override
    @Nullable
    public PackageViewDescriptor getPackage(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getPackage"));
        }
        return null;
    }

    @Override
    @Nullable
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getLocalVariable"));
        }
        return null;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = this.containingDeclaration;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getDeclarationsByLabel"));
        }
        throw new UnsupportedOperationException("Should not be called");
    }

    private Collection<DeclarationDescriptor> computeAllDescriptors() {
        LinkedHashSet<DeclarationDescriptor> result = new LinkedHashSet<DeclarationDescriptor>(0);
        for (Name name : this.membersProtos.keySet()) {
            result.addAll(this.getFunctions(name));
            result.addAll(this.getProperties(name));
        }
        this.addNonDeclaredDescriptors(result);
        this.addAllClassDescriptors(result);
        return result;
    }

    protected abstract void addNonDeclaredDescriptors(@NotNull Collection<DeclarationDescriptor> var1);

    @Override
    @NotNull
    public final Collection<DeclarationDescriptor> getAllDescriptors() {
        Collection collection = (Collection)this.allDescriptors.invoke();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getAllDescriptors"));
        }
        return collection;
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        ReceiverParameterDescriptor receiver = this.getImplicitReceiver();
        if (receiver != null) {
            List<ReceiverParameterDescriptor> list = Collections.singletonList(receiver);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getImplicitReceiversHierarchy"));
            }
            return list;
        }
        List<ReceiverParameterDescriptor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getImplicitReceiversHierarchy"));
        }
        return list;
    }

    @Nullable
    protected abstract ReceiverParameterDescriptor getImplicitReceiver();

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        Collection<DeclarationDescriptor> collection = this.getAllDescriptors();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "getOwnDeclaredDescriptors"));
        }
        return collection;
    }

    @Override
    public void printScopeStructure(@NotNull Printer p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedMemberScope", "printScopeStructure"));
        }
        p.println(this.getClass().getSimpleName(), " {");
        p.pushIndent();
        p.println("containingDeclaration = " + this.containingDeclaration);
        p.popIndent();
        p.println("}");
    }

    private static interface Filter<T> {
        public boolean accept(T var1);
    }
}

