/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.ChainedTemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.util.DelegatingCall;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;

public class CallTransformer<D extends CallableDescriptor, F extends D> {
    public static CallTransformer<VariableDescriptor, VariableDescriptor> PROPERTY_CALL_TRANSFORMER = new CallTransformer();
    public static CallTransformer<CallableDescriptor, FunctionDescriptor> FUNCTION_CALL_TRANSFORMER = new CallTransformer<CallableDescriptor, FunctionDescriptor>(){

        @Override
        @NotNull
        public Collection<CallCandidateResolutionContext<CallableDescriptor>> createCallContexts(@NotNull ResolutionCandidate<CallableDescriptor> candidate, @NotNull ResolutionTask<CallableDescriptor, FunctionDescriptor> task, @NotNull TemporaryBindingTrace candidateTrace) {
            if (candidate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1", "createCallContexts"));
            }
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1", "createCallContexts"));
            }
            if (candidateTrace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateTrace", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1", "createCallContexts"));
            }
            if (candidate.getDescriptor() instanceof FunctionDescriptor) {
                Collection<CallCandidateResolutionContext<CallableDescriptor>> collection = super.createCallContexts(candidate, task, candidateTrace);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1", "createCallContexts"));
                }
                return collection;
            }
            assert (candidate.getDescriptor() instanceof VariableDescriptor);
            boolean hasReceiver = candidate.getReceiverArgument().exists();
            Call variableCall = this.stripCallArguments(task);
            if (!hasReceiver) {
                CallCandidateResolutionContext<CallableDescriptor> context = CallCandidateResolutionContext.create(ResolvedCallImpl.create(candidate, candidateTrace, task.tracing, task.dataFlowInfoForArguments), task, candidateTrace, task.tracing, variableCall);
                Set<CallCandidateResolutionContext<CallableDescriptor>> set = Collections.singleton(context);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1", "createCallContexts"));
                }
                return set;
            }
            Call variableCallWithoutReceiver = this.stripReceiver(variableCall);
            CallCandidateResolutionContext<CallableDescriptor> contextWithReceiver = this.createContextWithChainedTrace(candidate, variableCall, candidateTrace, task);
            ResolutionCandidate<CallableDescriptor> candidateWithoutReceiver = ResolutionCandidate.create(candidate.getDescriptor(), candidate.getThisObject(), ReceiverValue.NO_RECEIVER, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, false);
            CallCandidateResolutionContext<CallableDescriptor> contextWithoutReceiver = this.createContextWithChainedTrace(candidateWithoutReceiver, variableCallWithoutReceiver, candidateTrace, task);
            contextWithoutReceiver.receiverForVariableAsFunctionSecondCall = variableCall.getExplicitReceiver();
            ArrayList<CallCandidateResolutionContext<CallableDescriptor>> arrayList = Lists.newArrayList(contextWithReceiver, contextWithoutReceiver);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1", "createCallContexts"));
            }
            return arrayList;
        }

        private CallCandidateResolutionContext<CallableDescriptor> createContextWithChainedTrace(ResolutionCandidate<CallableDescriptor> candidate, Call call, TemporaryBindingTrace temporaryTrace, ResolutionTask<CallableDescriptor, FunctionDescriptor> task) {
            ChainedTemporaryBindingTrace chainedTrace = ChainedTemporaryBindingTrace.create(temporaryTrace, "chained trace to resolve candidate", candidate);
            ResolvedCallImpl<CallableDescriptor> resolvedCall = ResolvedCallImpl.create(candidate, chainedTrace, task.tracing, task.dataFlowInfoForArguments);
            return CallCandidateResolutionContext.create(resolvedCall, task, chainedTrace, task.tracing, call);
        }

        private Call stripCallArguments(@NotNull ResolutionTask<CallableDescriptor, FunctionDescriptor> task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1", "stripCallArguments"));
            }
            return new DelegatingCall(task.call){

                @Override
                public JetValueArgumentList getValueArgumentList() {
                    return null;
                }

                @Override
                @NotNull
                public List<? extends ValueArgument> getValueArguments() {
                    List list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1$1", "getValueArguments"));
                    }
                    return list;
                }

                @Override
                @NotNull
                public List<JetExpression> getFunctionLiteralArguments() {
                    List<JetExpression> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1$1", "getFunctionLiteralArguments"));
                    }
                    return list;
                }

                @Override
                @NotNull
                public List<JetTypeProjection> getTypeArguments() {
                    List<JetTypeProjection> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1$1", "getTypeArguments"));
                    }
                    return list;
                }

                @Override
                public JetTypeArgumentList getTypeArgumentList() {
                    return null;
                }
            };
        }

        private Call stripReceiver(@NotNull Call variableCall) {
            if (variableCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableCall", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1", "stripReceiver"));
            }
            return new DelegatingCall(variableCall){

                @Override
                @NotNull
                public ReceiverValue getExplicitReceiver() {
                    ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
                    if (receiverValue == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1$2", "getExplicitReceiver"));
                    }
                    return receiverValue;
                }
            };
        }

        @Override
        @NotNull
        public Collection<ResolvedCallWithTrace<FunctionDescriptor>> transformCall(@NotNull CallCandidateResolutionContext<CallableDescriptor> context, @NotNull CallResolver callResolver, @NotNull ResolutionTask<CallableDescriptor, FunctionDescriptor> task) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1", "transformCall"));
            }
            if (callResolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1", "transformCall"));
            }
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1", "transformCall"));
            }
            Object descriptor = context.candidateCall.getCandidateDescriptor();
            if (descriptor instanceof FunctionDescriptor) {
                Collection<ResolvedCallWithTrace<FunctionDescriptor>> collection = super.transformCall(context, callResolver, task);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1", "transformCall"));
                }
                return collection;
            }
            assert (descriptor instanceof VariableDescriptor);
            JetType returnType = descriptor.getReturnType();
            if (returnType == null) {
                List<ResolvedCallWithTrace<FunctionDescriptor>> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1", "transformCall"));
                }
                return list;
            }
            final ResolvedCallImpl variableResolvedCall = context.candidateCall;
            CallForImplicitInvoke functionCall = new CallForImplicitInvoke(context.receiverForVariableAsFunctionSecondCall, task, returnType);
            DelegatingBindingTrace variableCallTrace = context.candidateCall.getTrace();
            BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(((CallCandidateResolutionContext)context.replaceBindingTrace(variableCallTrace)).replaceContextDependency(ContextDependency.DEPENDENT), functionCall, context.checkArguments, context.dataFlowInfoForArguments);
            OverloadResolutionResults<FunctionDescriptor> results = callResolver.resolveCallWithGivenName(basicCallResolutionContext, task.reference, Name.identifier("invoke"), false);
            Collection calls = ((OverloadResolutionResultsImpl)results).getResultingCalls();
            Collection<ResolvedCallWithTrace<FunctionDescriptor>> collection = Collections2.transform(calls, new Function<ResolvedCallWithTrace<FunctionDescriptor>, ResolvedCallWithTrace<FunctionDescriptor>>(){

                @Override
                public ResolvedCallWithTrace<FunctionDescriptor> apply(ResolvedCallWithTrace<FunctionDescriptor> functionResolvedCall) {
                    return new VariableAsFunctionResolvedCall(functionResolvedCall, variableResolvedCall);
                }
            });
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$1", "transformCall"));
            }
            return collection;
        }
    };

    private CallTransformer() {
    }

    @NotNull
    public Collection<CallCandidateResolutionContext<D>> createCallContexts(@NotNull ResolutionCandidate<D> candidate, @NotNull ResolutionTask<D, F> task, @NotNull TemporaryBindingTrace candidateTrace) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/jet/lang/resolve/calls/CallTransformer", "createCallContexts"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/jet/lang/resolve/calls/CallTransformer", "createCallContexts"));
        }
        if (candidateTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateTrace", "org/jetbrains/jet/lang/resolve/calls/CallTransformer", "createCallContexts"));
        }
        ResolvedCallImpl<D> candidateCall = ResolvedCallImpl.create(candidate, candidateTrace, task.tracing, task.dataFlowInfoForArguments);
        Set<CallCandidateResolutionContext<D>> set = Collections.singleton(CallCandidateResolutionContext.create(candidateCall, task, candidateTrace, task.tracing));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer", "createCallContexts"));
        }
        return set;
    }

    @NotNull
    public Collection<ResolvedCallWithTrace<F>> transformCall(@NotNull CallCandidateResolutionContext<D> callCandidateResolutionContext, @NotNull CallResolver callResolver, @NotNull ResolutionTask<D, F> task) {
        if (callCandidateResolutionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callCandidateResolutionContext", "org/jetbrains/jet/lang/resolve/calls/CallTransformer", "transformCall"));
        }
        if (callResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/jet/lang/resolve/calls/CallTransformer", "transformCall"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/jet/lang/resolve/calls/CallTransformer", "transformCall"));
        }
        Set<ResolvedCallWithTrace<F>> set = Collections.singleton(callCandidateResolutionContext.candidateCall);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer", "transformCall"));
        }
        return set;
    }

    public static class CallForImplicitInvoke
    extends DelegatingCall {
        final Call outerCall;
        final ReceiverValue receiverForVariableAsFunctionSecondCall;
        final ExpressionReceiver receiverFromVariable;
        final JetSimpleNameExpression invokeExpression;

        private CallForImplicitInvoke(ReceiverValue receiverForVariableAsFunctionSecondCall, ResolutionTask<CallableDescriptor, FunctionDescriptor> task, JetType returnType) {
            super(task.call);
            this.outerCall = task.call;
            this.receiverForVariableAsFunctionSecondCall = receiverForVariableAsFunctionSecondCall;
            this.receiverFromVariable = new ExpressionReceiver(task.reference, returnType);
            this.invokeExpression = (JetSimpleNameExpression)JetPsiFactory.createExpression(task.call.getCallElement().getProject(), "invoke");
        }

        @Override
        @NotNull
        public ReceiverValue getExplicitReceiver() {
            ReceiverValue receiverValue = this.receiverForVariableAsFunctionSecondCall;
            if (receiverValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$CallForImplicitInvoke", "getExplicitReceiver"));
            }
            return receiverValue;
        }

        @Override
        @NotNull
        public ReceiverValue getThisObject() {
            ExpressionReceiver expressionReceiver = this.receiverFromVariable;
            if (expressionReceiver == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$CallForImplicitInvoke", "getThisObject"));
            }
            return expressionReceiver;
        }

        @Override
        public JetExpression getCalleeExpression() {
            return this.invokeExpression;
        }

        @Override
        @NotNull
        public PsiElement getCallElement() {
            JetValueArgumentList list;
            if (this.outerCall.getCallElement() instanceof JetCallElement && (list = ((JetCallElement)this.outerCall.getCallElement()).getValueArgumentList()) != null) {
                JetValueArgumentList jetValueArgumentList = list;
                if (jetValueArgumentList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$CallForImplicitInvoke", "getCallElement"));
                }
                return jetValueArgumentList;
            }
            JetSimpleNameExpression jetSimpleNameExpression = this.invokeExpression;
            if (jetSimpleNameExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$CallForImplicitInvoke", "getCallElement"));
            }
            return jetSimpleNameExpression;
        }

        @Override
        @NotNull
        public Call.CallType getCallType() {
            Call.CallType callType = Call.CallType.INVOKE;
            if (callType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$CallForImplicitInvoke", "getCallType"));
            }
            return callType;
        }

        @NotNull
        public Call getOuterCall() {
            Call call = this.outerCall;
            if (call == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CallTransformer$CallForImplicitInvoke", "getOuterCall"));
            }
            return call;
        }
    }
}

