/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.analyzer.AnalyzerFacade;
import org.jetbrains.jet.analyzer.AnalyzerFacadeForEverything;
import org.jetbrains.jet.context.ContextPackage;
import org.jetbrains.jet.context.GlobalContext;
import org.jetbrains.jet.context.GlobalContextImpl;
import org.jetbrains.jet.di.InjectorForLazyResolveWithJava;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerForJvm;
import org.jetbrains.jet.lang.descriptors.DependencyKind;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.CachedBodiesResolveContext;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public enum AnalyzerFacadeForJVM implements AnalyzerFacade
{
    INSTANCE;

    public static final List<ImportPath> DEFAULT_IMPORTS;

    @Override
    @NotNull
    public AnalyzeExhaust analyzeFiles(@NotNull Project project, @NotNull Collection<JetFile> files, @NotNull List<AnalyzerScriptParameter> scriptParameters, @NotNull Predicate<PsiFile> filesToAnalyzeCompletely) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFiles"));
        }
        if (scriptParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptParameters", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFiles"));
        }
        if (filesToAnalyzeCompletely == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToAnalyzeCompletely", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFiles"));
        }
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, scriptParameters, filesToAnalyzeCompletely, true);
        if (analyzeExhaust == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFiles"));
        }
        return analyzeExhaust;
    }

    @Override
    @NotNull
    public AnalyzeExhaust analyzeBodiesInFiles(@NotNull Project project, @NotNull List<AnalyzerScriptParameter> scriptParameters, @NotNull Predicate<PsiFile> filesForBodiesResolve, @NotNull BindingTrace headersTraceContext, @NotNull BodiesResolveContext bodiesResolveContext, @NotNull ModuleDescriptor module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeBodiesInFiles"));
        }
        if (scriptParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptParameters", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeBodiesInFiles"));
        }
        if (filesForBodiesResolve == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesForBodiesResolve", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeBodiesInFiles"));
        }
        if (headersTraceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headersTraceContext", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeBodiesInFiles"));
        }
        if (bodiesResolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodiesResolveContext", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeBodiesInFiles"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeBodiesInFiles"));
        }
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForEverything.analyzeBodiesInFilesWithJavaIntegration(project, scriptParameters, filesForBodiesResolve, headersTraceContext, bodiesResolveContext, module);
        if (analyzeExhaust == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeBodiesInFiles"));
        }
        return analyzeExhaust;
    }

    @Override
    @NotNull
    public ResolveSession getLazyResolveSession(@NotNull Project fileProject, @NotNull Collection<JetFile> files) {
        if (fileProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileProject", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "getLazyResolveSession"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "getLazyResolveSession"));
        }
        ResolveSession resolveSession = AnalyzerFacadeForJVM.createLazyResolveSession(fileProject, files, new BindingTraceContext(), true);
        if (resolveSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "getLazyResolveSession"));
        }
        return resolveSession;
    }

    @NotNull
    public static ResolveSession createLazyResolveSession(@NotNull Project project, @NotNull Collection<JetFile> files, @NotNull BindingTrace trace, boolean addBuiltIns) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createLazyResolveSession"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createLazyResolveSession"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createLazyResolveSession"));
        }
        GlobalContextImpl globalContext = ContextPackage.GlobalContext();
        FileBasedDeclarationProviderFactory declarationProviderFactory = new FileBasedDeclarationProviderFactory(globalContext.getStorageManager(), files);
        InjectorForLazyResolveWithJava resolveWithJava = new InjectorForLazyResolveWithJava(project, globalContext, declarationProviderFactory, trace);
        resolveWithJava.getModule().addFragmentProvider(DependencyKind.BINARIES, resolveWithJava.getJavaDescriptorResolver().getPackageFragmentProvider());
        if (addBuiltIns) {
            resolveWithJava.getModule().addFragmentProvider(DependencyKind.BUILT_INS, KotlinBuiltIns.getInstance().getBuiltInsModule().getPackageFragmentProvider());
        }
        ResolveSession resolveSession = resolveWithJava.getResolveSession();
        if (resolveSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createLazyResolveSession"));
        }
        return resolveSession;
    }

    @NotNull
    public static AnalyzeExhaust analyzeOneFileWithJavaIntegrationAndCheckForErrors(JetFile file, List<AnalyzerScriptParameter> scriptParameters) {
        AnalyzingUtils.checkForSyntacticErrors(file);
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJVM.analyzeOneFileWithJavaIntegration(file, scriptParameters);
        AnalyzingUtils.throwExceptionOnErrors(analyzeExhaust.getBindingContext());
        AnalyzeExhaust analyzeExhaust2 = analyzeExhaust;
        if (analyzeExhaust2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeOneFileWithJavaIntegrationAndCheckForErrors"));
        }
        return analyzeExhaust2;
    }

    @NotNull
    public static AnalyzeExhaust analyzeOneFileWithJavaIntegration(JetFile file, List<AnalyzerScriptParameter> scriptParameters) {
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(file.getProject(), Collections.singleton(file), scriptParameters, Predicates.<PsiFile>alwaysTrue());
        if (analyzeExhaust == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeOneFileWithJavaIntegration"));
        }
        return analyzeExhaust;
    }

    @NotNull
    public static AnalyzeExhaust analyzeFilesWithJavaIntegrationAndCheckForErrors(Project project, Collection<JetFile> files, List<AnalyzerScriptParameter> scriptParameters, Predicate<PsiFile> filesToAnalyzeCompletely) {
        for (JetFile file : files) {
            AnalyzingUtils.checkForSyntacticErrors(file);
        }
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, scriptParameters, filesToAnalyzeCompletely, false);
        AnalyzingUtils.throwExceptionOnErrors(analyzeExhaust.getBindingContext());
        AnalyzeExhaust analyzeExhaust2 = analyzeExhaust;
        if (analyzeExhaust2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationAndCheckForErrors"));
        }
        return analyzeExhaust2;
    }

    @NotNull
    public static AnalyzeExhaust analyzeFilesWithJavaIntegration(Project project, Collection<JetFile> files, List<AnalyzerScriptParameter> scriptParameters, Predicate<PsiFile> filesToAnalyzeCompletely) {
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, scriptParameters, filesToAnalyzeCompletely, false);
        if (analyzeExhaust == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        return analyzeExhaust;
    }

    @NotNull
    public static AnalyzeExhaust analyzeFilesWithJavaIntegration(Project project, Collection<JetFile> files, List<AnalyzerScriptParameter> scriptParameters, Predicate<PsiFile> filesToAnalyzeCompletely, boolean storeContextForBodiesResolve) {
        BindingTraceContext bindingTraceContext = new BindingTraceContext();
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, bindingTraceContext, scriptParameters, filesToAnalyzeCompletely, storeContextForBodiesResolve);
        if (analyzeExhaust == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        return analyzeExhaust;
    }

    @NotNull
    public static AnalyzeExhaust analyzeFilesWithJavaIntegration(Project project, Collection<JetFile> files, BindingTrace trace, List<AnalyzerScriptParameter> scriptParameters, Predicate<PsiFile> filesToAnalyzeCompletely, boolean storeContextForBodiesResolve) {
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(project, files, trace, scriptParameters, filesToAnalyzeCompletely, storeContextForBodiesResolve, AnalyzerFacadeForJVM.createJavaModule("<module>"));
        if (analyzeExhaust == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        return analyzeExhaust;
    }

    @NotNull
    public static AnalyzeExhaust analyzeFilesWithJavaIntegration(Project project, Collection<JetFile> files, BindingTrace trace, List<AnalyzerScriptParameter> scriptParameters, Predicate<PsiFile> filesToAnalyzeCompletely, boolean storeContextForBodiesResolve, ModuleDescriptorImpl module) {
        GlobalContextImpl globalContext = ContextPackage.GlobalContext();
        AnalyzeExhaust analyzeExhaust = AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegrationInGlobalContext(project, files, trace, scriptParameters, filesToAnalyzeCompletely, storeContextForBodiesResolve, module, globalContext);
        if (analyzeExhaust == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegration"));
        }
        return analyzeExhaust;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static AnalyzeExhaust analyzeFilesWithJavaIntegrationInGlobalContext(Project project, Collection<JetFile> files, BindingTrace trace, List<AnalyzerScriptParameter> scriptParameters, Predicate<PsiFile> filesToAnalyzeCompletely, boolean storeContextForBodiesResolve, ModuleDescriptorImpl module, GlobalContext globalContext) {
        TopDownAnalysisParameters topDownAnalysisParameters = new TopDownAnalysisParameters(globalContext.getStorageManager(), globalContext.getExceptionTracker(), filesToAnalyzeCompletely, false, false, scriptParameters);
        InjectorForTopDownAnalyzerForJvm injector = new InjectorForTopDownAnalyzerForJvm(project, topDownAnalysisParameters, trace, module);
        module.addFragmentProvider(DependencyKind.BINARIES, injector.getJavaDescriptorResolver().getPackageFragmentProvider());
        TopDownAnalysisContext topDownAnalysisContext = injector.getTopDownAnalyzer().analyzeFiles(topDownAnalysisParameters, files);
        CachedBodiesResolveContext bodiesResolveContext = storeContextForBodiesResolve ? new CachedBodiesResolveContext(topDownAnalysisContext) : null;
        AnalyzeExhaust analyzeExhaust = AnalyzeExhaust.success(trace.getBindingContext(), bodiesResolveContext, module);
        AnalyzeExhaust analyzeExhaust2 = analyzeExhaust;
        if (analyzeExhaust2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "analyzeFilesWithJavaIntegrationInGlobalContext"));
        }
        return analyzeExhaust2;
        finally {
            injector.destroy();
        }
    }

    @NotNull
    public static ModuleDescriptorImpl createJavaModule(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createJavaModule"));
        }
        ModuleDescriptorImpl moduleDescriptorImpl = new ModuleDescriptorImpl(Name.special(name), DEFAULT_IMPORTS, JavaToKotlinClassMap.getInstance());
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/AnalyzerFacadeForJVM", "createJavaModule"));
        }
        return moduleDescriptorImpl;
    }

    static {
        DEFAULT_IMPORTS = ImmutableList.of(new ImportPath("java.lang.*"), new ImportPath("kotlin.*"), new ImportPath("kotlin.io.*"));
    }
}

