/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import com.google.common.collect.Lists;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.SubstitutingScope;
import org.jetbrains.jet.lang.types.CompositeTypeSubstitution;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitution;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class TypeSubstitutor {
    public static final TypeSubstitutor EMPTY = TypeSubstitutor.create(TypeSubstitution.EMPTY);
    @NotNull
    private final TypeSubstitution substitution;

    public static TypeSubstitutor create(@NotNull TypeSubstitution substitution) {
        if (substitution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitution", "org/jetbrains/jet/lang/types/TypeSubstitutor", "create"));
        }
        return new TypeSubstitutor(substitution);
    }

    public static TypeSubstitutor create(TypeSubstitution ... substitutions) {
        if (substitutions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutions", "org/jetbrains/jet/lang/types/TypeSubstitutor", "create"));
        }
        return TypeSubstitutor.create((TypeSubstitution)new CompositeTypeSubstitution(substitutions));
    }

    public static TypeSubstitutor createUnsafe(@NotNull Map<TypeConstructor, TypeProjection> substitutionContext) {
        if (substitutionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutionContext", "org/jetbrains/jet/lang/types/TypeSubstitutor", "createUnsafe"));
        }
        Map<TypeConstructor, TypeProjection> cleanContext = SubstitutionUtils.removeTrivialSubstitutions(substitutionContext);
        return TypeSubstitutor.create((TypeSubstitution)new MapToTypeSubstitutionAdapter(cleanContext));
    }

    public static TypeSubstitutor create(@NotNull Map<TypeConstructor, TypeProjection> substitutionContext) {
        if (substitutionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutionContext", "org/jetbrains/jet/lang/types/TypeSubstitutor", "create"));
        }
        Map<TypeConstructor, TypeProjection> cleanContext = SubstitutionUtils.removeTrivialSubstitutions(substitutionContext);
        return TypeSubstitutor.createUnsafe(cleanContext);
    }

    public static TypeSubstitutor create(@NotNull JetType context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/TypeSubstitutor", "create"));
        }
        return TypeSubstitutor.create(SubstitutionUtils.buildSubstitutionContext(context));
    }

    protected TypeSubstitutor(@NotNull TypeSubstitution substitution) {
        if (substitution == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitution", "org/jetbrains/jet/lang/types/TypeSubstitutor", "<init>"));
        }
        this.substitution = substitution;
    }

    public boolean inRange(@NotNull TypeConstructor typeConstructor) {
        if (typeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/jet/lang/types/TypeSubstitutor", "inRange"));
        }
        return this.substitution.get(typeConstructor) != null;
    }

    public boolean isEmpty() {
        return this.substitution.isEmpty();
    }

    @NotNull
    public TypeSubstitution getSubstitution() {
        TypeSubstitution typeSubstitution = this.substitution;
        if (typeSubstitution == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "getSubstitution"));
        }
        return typeSubstitution;
    }

    @NotNull
    public JetType safeSubstitute(@NotNull JetType type, @NotNull Variance howThisTypeIsUsed) {
        JetType jetType;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeSubstitutor", "safeSubstitute"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "org/jetbrains/jet/lang/types/TypeSubstitutor", "safeSubstitute"));
        }
        if (this.isEmpty()) {
            JetType jetType2 = type;
            if (jetType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "safeSubstitute"));
            }
            return jetType2;
        }
        try {
            jetType = this.unsafeSubstitute(new TypeProjectionImpl(howThisTypeIsUsed, type), 0).getType();
        }
        catch (SubstitutionException e) {
            JetType jetType3 = ErrorUtils.createErrorType(e.getMessage());
            if (jetType3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "safeSubstitute"));
            }
            return jetType3;
        }
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "safeSubstitute"));
        }
        return jetType;
    }

    @Nullable
    public JetType substitute(@NotNull JetType type, @NotNull Variance howThisTypeIsUsed) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/types/TypeSubstitutor", "substitute"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "org/jetbrains/jet/lang/types/TypeSubstitutor", "substitute"));
        }
        TypeProjection projection = this.substitute(new TypeProjectionImpl(howThisTypeIsUsed, type));
        return projection == null ? null : projection.getType();
    }

    @Nullable
    public TypeProjection substitute(@NotNull TypeProjection typeProjection) {
        if (typeProjection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjection", "org/jetbrains/jet/lang/types/TypeSubstitutor", "substitute"));
        }
        if (this.isEmpty()) {
            return typeProjection;
        }
        try {
            return this.unsafeSubstitute(typeProjection, 0);
        }
        catch (SubstitutionException e) {
            return null;
        }
    }

    @NotNull
    private TypeProjection unsafeSubstitute(@NotNull TypeProjection originalProjection, int recursionDepth) throws SubstitutionException {
        if (originalProjection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalProjection", "org/jetbrains/jet/lang/types/TypeSubstitutor", "unsafeSubstitute"));
        }
        TypeSubstitutor.assertRecursionDepth(recursionDepth, originalProjection, this.substitution);
        JetType type = originalProjection.getType();
        if (KotlinBuiltIns.getInstance().isNothing(type) || type.isError()) {
            TypeProjection typeProjection = originalProjection;
            if (typeProjection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "unsafeSubstitute"));
            }
            return typeProjection;
        }
        TypeProjection replacement = this.substitution.get(type.getConstructor());
        if (replacement != null) {
            TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)type.getConstructor().getDeclarationDescriptor();
            switch (TypeSubstitutor.conflictType(originalProjection.getProjectionKind(), replacement.getProjectionKind())) {
                case OUT_IN_IN_POSITION: {
                    throw new SubstitutionException("Out-projection in in-position");
                }
                case IN_IN_OUT_POSITION: {
                    TypeProjection typeProjection = SubstitutionUtils.makeStarProjection(typeParameter);
                    if (typeProjection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "unsafeSubstitute"));
                    }
                    return typeProjection;
                }
                case NO_CONFLICT: {
                    boolean resultingIsNullable = type.isNullable() || replacement.getType().isNullable();
                    JetType substitutedType = TypeUtils.makeNullableAsSpecified(replacement.getType(), resultingIsNullable);
                    Variance resultingProjectionKind = TypeSubstitutor.combine(originalProjection.getProjectionKind(), replacement.getProjectionKind());
                    TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(resultingProjectionKind, substitutedType);
                    if (typeProjectionImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "unsafeSubstitute"));
                    }
                    return typeProjectionImpl;
                }
            }
            throw new IllegalStateException();
        }
        List<TypeProjection> substitutedArguments = this.substituteTypeArguments(type.getConstructor().getParameters(), type.getArguments(), recursionDepth);
        JetTypeImpl substitutedType = new JetTypeImpl(type.getAnnotations(), type.getConstructor(), type.isNullable(), substitutedArguments, new SubstitutingScope(type.getMemberScope(), this));
        TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(originalProjection.getProjectionKind(), substitutedType);
        if (typeProjectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/TypeSubstitutor", "unsafeSubstitute"));
        }
        return typeProjectionImpl;
    }

    private List<TypeProjection> substituteTypeArguments(List<TypeParameterDescriptor> typeParameters, List<TypeProjection> typeArguments, int recursionDepth) throws SubstitutionException {
        ArrayList<TypeProjection> substitutedArguments = Lists.newArrayList();
        for (int i = 0; i < typeParameters.size(); ++i) {
            TypeParameterDescriptor typeParameter = typeParameters.get(i);
            TypeProjection typeArgument = typeArguments.get(i);
            TypeProjection substitutedTypeArgument = this.unsafeSubstitute(typeArgument, recursionDepth + 1);
            switch (TypeSubstitutor.conflictType(typeParameter.getVariance(), substitutedTypeArgument.getProjectionKind())) {
                case NO_CONFLICT: {
                    if (typeParameter.getVariance() == Variance.INVARIANT) break;
                    substitutedTypeArgument = new TypeProjectionImpl(Variance.INVARIANT, substitutedTypeArgument.getType());
                    break;
                }
                case OUT_IN_IN_POSITION: 
                case IN_IN_OUT_POSITION: {
                    substitutedTypeArgument = SubstitutionUtils.makeStarProjection(typeParameter);
                }
            }
            substitutedArguments.add(substitutedTypeArgument);
        }
        return substitutedArguments;
    }

    private static Variance combine(Variance typeParameterVariance, Variance projectionKind) {
        if (typeParameterVariance == Variance.INVARIANT) {
            return projectionKind;
        }
        if (projectionKind == Variance.INVARIANT) {
            return typeParameterVariance;
        }
        if (typeParameterVariance == projectionKind) {
            return projectionKind;
        }
        return Variance.IN_VARIANCE;
    }

    private static VarianceConflictType conflictType(Variance position, Variance argument) {
        if (position == Variance.IN_VARIANCE && argument == Variance.OUT_VARIANCE) {
            return VarianceConflictType.OUT_IN_IN_POSITION;
        }
        if (position == Variance.OUT_VARIANCE && argument == Variance.IN_VARIANCE) {
            return VarianceConflictType.IN_IN_OUT_POSITION;
        }
        return VarianceConflictType.NO_CONFLICT;
    }

    private static void assertRecursionDepth(int recursionDepth, TypeProjection projection, TypeSubstitution substitution) {
        if (recursionDepth > 100) {
            throw new IllegalStateException("Recursion too deep. Most likely infinite loop while substituting " + TypeSubstitutor.safeToString(projection) + "; substitution: " + TypeSubstitutor.safeToString(substitution));
        }
    }

    private static String safeToString(Object o) {
        try {
            return o.toString();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            return "[Exception while computing toString(): " + e + "]";
        }
    }

    private static enum VarianceConflictType {
        NO_CONFLICT,
        IN_IN_OUT_POSITION,
        OUT_IN_IN_POSITION;

    }

    private static final class SubstitutionException
    extends Exception {
        public SubstitutionException(String message) {
            super(message);
        }
    }

    public static class MapToTypeSubstitutionAdapter
    implements TypeSubstitution {
        @NotNull
        private final Map<TypeConstructor, TypeProjection> substitutionContext;

        public MapToTypeSubstitutionAdapter(@NotNull Map<TypeConstructor, TypeProjection> substitutionContext) {
            if (substitutionContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutionContext", "org/jetbrains/jet/lang/types/TypeSubstitutor$MapToTypeSubstitutionAdapter", "<init>"));
            }
            this.substitutionContext = substitutionContext;
        }

        @Override
        public TypeProjection get(TypeConstructor key) {
            return this.substitutionContext.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.substitutionContext.isEmpty();
        }

        public String toString() {
            return this.substitutionContext.toString();
        }
    }
}

