/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaCodeStyleManager {
    public static final int DO_NOT_ADD_IMPORTS = 4096;
    public static final int UNCOMPLETE_CODE = 8192;

    public static JavaCodeStyleManager getInstance(Project project) {
        return ServiceManager.getService(project, JavaCodeStyleManager.class);
    }

    public abstract boolean addImport(@NotNull PsiJavaFile var1, @NotNull PsiClass var2);

    public abstract PsiElement shortenClassReferences(@NotNull PsiElement var1, int var2) throws IncorrectOperationException;

    @NotNull
    public abstract String getPrefixByVariableKind(VariableKind var1);

    @NotNull
    public abstract String getSuffixByVariableKind(VariableKind var1);

    public abstract int findEntryIndex(@NotNull PsiImportStatementBase var1);

    public abstract PsiElement shortenClassReferences(@NotNull PsiElement var1) throws IncorrectOperationException;

    public abstract void shortenClassReferences(@NotNull PsiElement var1, int var2, int var3) throws IncorrectOperationException;

    public abstract void optimizeImports(@NotNull PsiFile var1) throws IncorrectOperationException;

    public abstract PsiImportList prepareOptimizeImportsResult(@NotNull PsiJavaFile var1);

    public VariableKind getVariableKind(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "getVariableKind"));
        }
        if (variable instanceof PsiField) {
            if (variable.hasModifierProperty("static")) {
                if (variable.hasModifierProperty("final")) {
                    return VariableKind.STATIC_FINAL_FIELD;
                }
                return VariableKind.STATIC_FIELD;
            }
            return VariableKind.FIELD;
        }
        if (variable instanceof PsiParameter) {
            if (((PsiParameter)variable).getDeclarationScope() instanceof PsiForeachStatement) {
                return VariableKind.LOCAL_VARIABLE;
            }
            return VariableKind.PARAMETER;
        }
        return VariableKind.LOCAL_VARIABLE;
    }

    public SuggestedNameInfo suggestVariableName(@NotNull VariableKind kind, @Nullable String propertyName, @Nullable PsiExpression expr, @Nullable PsiType type) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "suggestVariableName"));
        }
        return this.suggestVariableName(kind, propertyName, expr, type, true);
    }

    public SuggestedNameInfo suggestCompiledParameterName(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "suggestCompiledParameterName"));
        }
        return this.suggestVariableName(VariableKind.PARAMETER, null, null, type, true);
    }

    public abstract SuggestedNameInfo suggestVariableName(@NotNull VariableKind var1, @Nullable String var2, @Nullable PsiExpression var3, @Nullable PsiType var4, boolean var5);

    public abstract String variableNameToPropertyName(@NonNls String var1, VariableKind var2);

    public abstract String propertyNameToVariableName(@NonNls String var1, VariableKind var2);

    public abstract String suggestUniqueVariableName(@NonNls String var1, PsiElement var2, boolean var3);

    @NotNull
    public SuggestedNameInfo suggestUniqueVariableName(@NotNull SuggestedNameInfo baseNameInfo, PsiElement place, boolean lookForward) {
        if (baseNameInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "suggestUniqueVariableName"));
        }
        SuggestedNameInfo suggestedNameInfo = this.suggestUniqueVariableName(baseNameInfo, place, false, lookForward);
        if (suggestedNameInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/JavaCodeStyleManager", "suggestUniqueVariableName"));
        }
        return suggestedNameInfo;
    }

    @NotNull
    public abstract SuggestedNameInfo suggestUniqueVariableName(@NotNull SuggestedNameInfo var1, PsiElement var2, boolean var3, boolean var4);

    public abstract PsiElement qualifyClassReferences(@NotNull PsiElement var1);

    public abstract void removeRedundantImports(@NotNull PsiJavaFile var1) throws IncorrectOperationException;

    @Nullable
    public abstract Collection<PsiImportStatementBase> findRedundantImports(PsiJavaFile var1);
}

