/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.ClsStubBuilderFactory;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class ClassFileStubBuilder
implements BinaryFileStubBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.compiled.ClassFileStubBuilder");
    public static final int STUB_VERSION = 10;
    private static final Comparator<Object> CLASS_NAME_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return o1.getClass().getName().compareTo(o2.getClass().getName());
        }
    };

    @Override
    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClassFileStubBuilder", "acceptsFile"));
        }
        return true;
    }

    @Override
    public StubElement buildStubTree(@NotNull FileContent fileContent) {
        if (fileContent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/compiled/ClassFileStubBuilder", "buildStubTree"));
        }
        VirtualFile file = fileContent.getFile();
        byte[] content = fileContent.getContent();
        try {
            ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.find(file);
            if (decompiler instanceof ClassFileDecompilers.Full) {
                return ((ClassFileDecompilers.Full)decompiler).getStubBuilder().buildFileStub(fileContent);
            }
        }
        catch (ClsFormatException e) {
            LOG.debug(e);
        }
        try {
            Project project = fileContent.getProject();
            for (ClsStubBuilderFactory factory : Extensions.getExtensions(ClsStubBuilderFactory.EP_NAME)) {
                PsiFileStub stub;
                if (factory.isInnerClass(file) || !factory.canBeProcessed(file, content) || (stub = factory.buildFileStub(file, content, project)) == null) continue;
                return stub;
            }
        }
        catch (ClsFormatException e) {
            LOG.debug(e);
        }
        try {
            PsiJavaFileStub stub = ClsFileImpl.buildFileStub(file, content);
            if (stub == null && !fileContent.getFileName().contains("$")) {
                LOG.info("No stub built for file " + fileContent);
            }
            return stub;
        }
        catch (ClsFormatException e) {
            LOG.debug(e);
            return null;
        }
    }

    @Override
    public int getStubVersion() {
        int version = 10;
        ArrayList<ClassFileDecompilers.Decompiler> decompilers = ContainerUtil.newArrayList(ClassFileDecompilers.EP_NAME.getExtensions());
        Collections.sort(decompilers, CLASS_NAME_COMPARATOR);
        for (ClassFileDecompilers.Decompiler decompiler : decompilers) {
            if (!(decompiler instanceof ClassFileDecompilers.Full)) continue;
            version = version * 31 + ((ClassFileDecompilers.Full)decompiler).getStubBuilder().getStubVersion() + decompiler.getClass().getName().hashCode();
        }
        ArrayList<ClsStubBuilderFactory> factories = ContainerUtil.newArrayList(Extensions.getExtensions(ClsStubBuilderFactory.EP_NAME));
        Collections.sort(factories, CLASS_NAME_COMPARATOR);
        for (ClsStubBuilderFactory factory : factories) {
            version = version * 31 + factory.getStubVersion() + factory.getClass().getName().hashCode();
        }
        return version;
    }
}

