/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.ModifierFlags;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiModifierListImpl
extends JavaStubPsiElement<PsiModifierListStub>
implements PsiModifierList {
    private static final Map<String, IElementType> NAME_TO_KEYWORD_TYPE_MAP = new THashMap<String, IElementType>();

    public PsiModifierListImpl(PsiModifierListStub stub) {
        super(stub, JavaStubElementTypes.MODIFIER_LIST);
    }

    public PsiModifierListImpl(ASTNode node) {
        super(node);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiModifierListImpl", "hasModifierProperty"));
        }
        PsiModifierListStub stub = (PsiModifierListStub)this.getStub();
        if (stub != null) {
            return ModifierFlags.hasModifierProperty(name, stub.getModifiersMask());
        }
        IElementType type = NAME_TO_KEYWORD_TYPE_MAP.get(name);
        PsiElement parent = this.getParent();
        if (parent instanceof PsiClass) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface()) {
                if (type == JavaTokenType.PUBLIC_KEYWORD) {
                    return true;
                }
                if (type == null) {
                    return false;
                }
                if (type == JavaTokenType.STATIC_KEYWORD) {
                    return true;
                }
            }
            if (((PsiClass)parent).isInterface()) {
                if (type == JavaTokenType.ABSTRACT_KEYWORD) {
                    return true;
                }
                if (grandParent instanceof PsiClass && type == JavaTokenType.STATIC_KEYWORD) {
                    return true;
                }
            }
            if (((PsiClass)parent).isEnum()) {
                if (type == JavaTokenType.STATIC_KEYWORD) {
                    if (!(grandParent instanceof PsiFile)) {
                        return true;
                    }
                } else {
                    if (type == JavaTokenType.FINAL_KEYWORD) {
                        PsiField[] fields2;
                        for (PsiField field : fields2 = ((PsiClass)parent).getFields()) {
                            if (!(field instanceof PsiEnumConstant) || ((PsiEnumConstant)field).getInitializingClass() == null) continue;
                            return false;
                        }
                        return true;
                    }
                    if (type == JavaTokenType.ABSTRACT_KEYWORD) {
                        PsiMethod[] methods;
                        for (PsiMethod method : methods = ((PsiClass)parent).getMethods()) {
                            if (!method.hasModifierProperty("abstract")) continue;
                            return true;
                        }
                        return false;
                    }
                }
            }
        } else if (parent instanceof PsiMethod) {
            PsiClass aClass = ((PsiMethod)parent).getContainingClass();
            if (aClass != null && aClass.isInterface()) {
                if (type == JavaTokenType.PUBLIC_KEYWORD) {
                    return true;
                }
                if (type == null) {
                    return false;
                }
                if (type == JavaTokenType.ABSTRACT_KEYWORD) {
                    return this.getNode().findChildByType(JavaTokenType.DEFAULT_KEYWORD) == null && this.getNode().findChildByType(JavaTokenType.STATIC_KEYWORD) == null;
                }
            }
        } else if (parent instanceof PsiField) {
            if (parent instanceof PsiEnumConstant) {
                return type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.STATIC_KEYWORD || type == JavaTokenType.FINAL_KEYWORD;
            }
            PsiClass aClass = ((PsiField)parent).getContainingClass();
            if (aClass != null && aClass.isInterface()) {
                if (type == JavaTokenType.PUBLIC_KEYWORD) {
                    return true;
                }
                if (type == null) {
                    return false;
                }
                if (type == JavaTokenType.STATIC_KEYWORD) {
                    return true;
                }
                if (type == JavaTokenType.FINAL_KEYWORD) {
                    return true;
                }
            }
        } else if (parent instanceof PsiParameter ? type == JavaTokenType.FINAL_KEYWORD && ((PsiParameter)parent).getType() instanceof PsiDisjunctionType : parent instanceof PsiResourceVariable && type == JavaTokenType.FINAL_KEYWORD) {
            return true;
        }
        if (type == null) {
            return !this.hasModifierProperty("public") && !this.hasModifierProperty("private") && !this.hasModifierProperty("protected");
        }
        return this.getNode().findChildByType(type) != null;
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        IElementType type;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiModifierListImpl", "hasExplicitModifier"));
        }
        CompositeElement tree = (CompositeElement)this.getNode();
        return tree.findChildByType(type = NAME_TO_KEYWORD_TYPE_MAP.get(name)) != null;
    }

    @Override
    public void setModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiModifierListImpl", "setModifierProperty"));
        }
        this.checkSetModifierProperty(name, value);
        PsiElement parent = this.getParent();
        PsiElement grandParent = parent != null ? parent.getParent() : null;
        IElementType type = NAME_TO_KEYWORD_TYPE_MAP.get(name);
        CompositeElement treeElement = (CompositeElement)this.getNode();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            CodeEditUtil.markToReformat(method.getParameterList().getNode(), true);
        }
        if (value) {
            if (type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.PRIVATE_KEYWORD || type == JavaTokenType.PROTECTED_KEYWORD || type == null) {
                if (type != JavaTokenType.PUBLIC_KEYWORD) {
                    this.setModifierProperty("public", false);
                }
                if (type != JavaTokenType.PRIVATE_KEYWORD) {
                    this.setModifierProperty("private", false);
                }
                if (type != JavaTokenType.PROTECTED_KEYWORD) {
                    this.setModifierProperty("protected", false);
                }
                if (type == null) {
                    return;
                }
            }
            if (parent instanceof PsiField && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.STATIC_KEYWORD || type == JavaTokenType.FINAL_KEYWORD : (parent instanceof PsiMethod && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.ABSTRACT_KEYWORD : (parent instanceof PsiClass && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type == JavaTokenType.PUBLIC_KEYWORD : parent instanceof PsiAnnotationMethod && grandParent instanceof PsiClass && ((PsiClass)grandParent).isAnnotationType() && (type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.ABSTRACT_KEYWORD)))) {
                return;
            }
            if (treeElement.findChildByType(type) == null) {
                LeafElement keyword = Factory.createSingleLeafElement(type, name, null, this.getManager());
                treeElement.addInternal(keyword, keyword, null, null);
            }
        } else {
            if (type == null) {
                throw new IncorrectOperationException("Cannot reset package local modifier.");
            }
            ASTNode child = treeElement.findChildByType(type);
            if (child != null) {
                SourceTreeToPsiMap.treeToPsiNotNull(child).delete();
            }
        }
    }

    @Override
    public void checkSetModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiModifierListImpl", "checkSetModifierProperty"));
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] own = (PsiAnnotation[])this.getStubOrPsiChildren(JavaStubElementTypes.ANNOTATION, PsiAnnotation.ARRAY_FACTORY);
        List<PsiAnnotation> ext = PsiAugmentProvider.collectAugments(this, PsiAnnotation.class);
        PsiAnnotation[] psiAnnotationArray = ArrayUtil.mergeArrayAndCollection(own, ext, PsiAnnotation.ARRAY_FACTORY);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiModifierListImpl", "getAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        final PsiAnnotation.TargetType[] targets = PsiImplUtil.getTargetsForLocation(this);
        List<PsiAnnotation> filtered = ContainerUtil.findAll(this.getAnnotations(), new Condition<PsiAnnotation>(){

            @Override
            public boolean value(PsiAnnotation annotation) {
                PsiAnnotation.TargetType target = PsiImplUtil.findApplicableTarget(annotation, targets);
                return target != null && target != PsiAnnotation.TargetType.UNKNOWN;
            }
        });
        PsiAnnotation[] psiAnnotationArray = filtered.toArray(new PsiAnnotation[filtered.size()]);
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiModifierListImpl", "getApplicableAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiModifierListImpl", "findAnnotation"));
        }
        return PsiImplUtil.findAnnotation(this, qualifiedName);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiModifierListImpl", "addAnnotation"));
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)this.addAfter(JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createAnnotationFromText("@" + qualifiedName, this), null);
        if (psiAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiModifierListImpl", "addAnnotation"));
        }
        return psiAnnotation;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiModifierListImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModifierList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiModifierList:" + this.getText();
    }

    static {
        NAME_TO_KEYWORD_TYPE_MAP.put("public", JavaTokenType.PUBLIC_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("protected", JavaTokenType.PROTECTED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("private", JavaTokenType.PRIVATE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("static", JavaTokenType.STATIC_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("abstract", JavaTokenType.ABSTRACT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("final", JavaTokenType.FINAL_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("native", JavaTokenType.NATIVE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("synchronized", JavaTokenType.SYNCHRONIZED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("strictfp", JavaTokenType.STRICTFP_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("transient", JavaTokenType.TRANSIENT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("volatile", JavaTokenType.VOLATILE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("default", JavaTokenType.DEFAULT_KEYWORD);
    }
}

