/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class VariablesProcessor
extends BaseScopeProcessor
implements ElementClassHint {
    private boolean myStaticScopeFlag = false;
    private final boolean myStaticSensitiveFlag;
    private final List<PsiVariable> myResultList;

    public VariablesProcessor(boolean staticSensitive) {
        this(staticSensitive, new SmartList<PsiVariable>());
    }

    public VariablesProcessor(boolean staticSensitive, List<PsiVariable> list) {
        this.myStaticSensitiveFlag = staticSensitive;
        this.myResultList = list;
    }

    protected abstract boolean check(PsiVariable var1, ResolveState var2);

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        return kind == ElementClassHint.DeclarationKind.VARIABLE || kind == ElementClassHint.DeclarationKind.FIELD || kind == ElementClassHint.DeclarationKind.ENUM_CONST;
    }

    @Override
    public boolean execute(@NotNull PsiElement pe, ResolveState state) {
        if (pe == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/processor/VariablesProcessor", "execute"));
        }
        if (pe instanceof PsiVariable) {
            PsiVariable pvar = (PsiVariable)pe;
            if ((!this.myStaticSensitiveFlag || !this.myStaticScopeFlag || pvar.hasModifierProperty("static")) && this.check(pvar, state)) {
                this.myResultList.add(pvar);
            }
        }
        return true;
    }

    @Override
    public final void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStaticScopeFlag = true;
        }
    }

    public int size() {
        return this.myResultList.size();
    }

    public PsiVariable getResult(int i) {
        return this.myResultList.get(i);
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/scope/processor/VariablesProcessor", "getHint"));
        }
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }
}

