/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.java.JetFilesProvider;

public class CliJetFilesProvider
extends JetFilesProvider {
    private final JetCoreEnvironment environment;

    public CliJetFilesProvider(JetCoreEnvironment environment) {
        this.environment = environment;
    }

    @Override
    protected Collection<JetFile> sampleToAllFilesInModule(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/cli/jvm/compiler/CliJetFilesProvider", "sampleToAllFilesInModule"));
        }
        return this.environment.getSourceFiles();
    }

    @NotNull
    public List<JetFile> allInScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/cli/jvm/compiler/CliJetFilesProvider", "allInScope"));
        }
        ArrayList<JetFile> answer = new ArrayList<JetFile>();
        for (JetFile file : this.environment.getSourceFiles()) {
            if (!scope.contains(file.getVirtualFile())) continue;
            answer.add(file);
        }
        ArrayList<JetFile> arrayList = answer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/CliJetFilesProvider", "allInScope"));
        }
        return arrayList;
    }

    @Override
    public boolean isFileInScope(@NotNull JetFile file, @NotNull GlobalSearchScope scope) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/cli/jvm/compiler/CliJetFilesProvider", "isFileInScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/cli/jvm/compiler/CliJetFilesProvider", "isFileInScope"));
        }
        return scope.contains(file.getVirtualFile()) && this.environment.getSourceFiles().contains(file);
    }
}

