/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.org.objectweb.asm.Type;

public interface CallGenerator {
    public void genCall(@NotNull CallableMethod var1, @Nullable ResolvedCall<?> var2, boolean var3, @NotNull ExpressionCodegen var4);

    public void genCallWithoutAssertions(@NotNull CallableMethod var1, @NotNull ExpressionCodegen var2);

    public void afterParameterPut(@NotNull Type var1, StackValue var2, @NotNull ValueParameterDescriptor var3);

    public void genValueAndPut(@NotNull ValueParameterDescriptor var1, @NotNull JetExpression var2, @NotNull Type var3);

    public void putValueIfNeeded(@Nullable ValueParameterDescriptor var1, @NotNull Type var2, @NotNull StackValue var3);

    public void putCapturedValueOnStack(@NotNull StackValue var1, @NotNull Type var2, int var3);

    public void putHiddenParams();

    public static class DefaultCallGenerator
    implements CallGenerator {
        private final ExpressionCodegen codegen;

        public DefaultCallGenerator(ExpressionCodegen codegen) {
            this.codegen = codegen;
        }

        @Override
        public void genCall(@NotNull CallableMethod callableMethod, ResolvedCall<?> resolvedCall, boolean callDefault, @NotNull ExpressionCodegen codegen) {
            if (callableMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableMethod", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "genCall"));
            }
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "genCall"));
            }
            if (!callDefault) {
                callableMethod.invokeWithNotNullAssertion(codegen.v, codegen.getState(), resolvedCall);
            } else {
                callableMethod.invokeDefaultWithNotNullAssertion(codegen.v, codegen.getState(), resolvedCall);
            }
        }

        @Override
        public void genCallWithoutAssertions(@NotNull CallableMethod method, @NotNull ExpressionCodegen codegen) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "genCallWithoutAssertions"));
            }
            if (codegen == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "genCallWithoutAssertions"));
            }
            method.invokeWithoutAssertions(codegen.v);
        }

        @Override
        public void afterParameterPut(@NotNull Type type, StackValue stackValue, @NotNull ValueParameterDescriptor valueParameterDescriptor) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "afterParameterPut"));
            }
            if (valueParameterDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "afterParameterPut"));
            }
        }

        @Override
        public void putHiddenParams() {
        }

        @Override
        public void genValueAndPut(@NotNull ValueParameterDescriptor valueParameterDescriptor, @NotNull JetExpression argumentExpression, @NotNull Type parameterType) {
            if (valueParameterDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "genValueAndPut"));
            }
            if (argumentExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExpression", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "genValueAndPut"));
            }
            if (parameterType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "genValueAndPut"));
            }
            StackValue value = this.codegen.gen(argumentExpression);
            value.put(parameterType, this.codegen.v);
        }

        @Override
        public void putCapturedValueOnStack(@NotNull StackValue stackValue, @NotNull Type valueType, int paramIndex) {
            if (stackValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackValue", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "putCapturedValueOnStack"));
            }
            if (valueType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueType", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "putCapturedValueOnStack"));
            }
            stackValue.put(stackValue.type, this.codegen.v);
        }

        @Override
        public void putValueIfNeeded(@Nullable ValueParameterDescriptor valueParameterDescriptor, @NotNull Type parameterType, @NotNull StackValue value) {
            if (parameterType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "putValueIfNeeded"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/codegen/CallGenerator$DefaultCallGenerator", "putValueIfNeeded"));
            }
            value.put(value.type, this.codegen.v);
        }
    }
}

