/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Maps;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.SamType;
import org.jetbrains.jet.codegen.SamWrapperCodegen;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.org.objectweb.asm.Type;

public class SamWrapperClasses {
    private final GenerationState state;
    private final Map<Pair<SamType, JetFile>, Type> samInterfaceToWrapperClass;

    public SamWrapperClasses(@NotNull GenerationState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/SamWrapperClasses", "<init>"));
        }
        this.samInterfaceToWrapperClass = Maps.newHashMap();
        this.state = state;
    }

    @NotNull
    public Type getSamWrapperClass(final @NotNull SamType samType, final @NotNull JetFile file) {
        if (samType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samType", "org/jetbrains/jet/codegen/SamWrapperClasses", "getSamWrapperClass"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/SamWrapperClasses", "getSamWrapperClass"));
        }
        Type type = ContainerUtil.getOrCreate(this.samInterfaceToWrapperClass, Pair.create(samType, file), new Factory<Type>(){

            @Override
            public Type create() {
                return new SamWrapperCodegen(SamWrapperClasses.this.state, samType).genWrapper(file);
            }
        });
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/SamWrapperClasses", "getSamWrapperClass"));
        }
        return type;
    }
}

