/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.JvmCodegenUtil;
import org.jetbrains.jet.codegen.SamType;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaClassDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class SamWrapperCodegen {
    private final GenerationState state;
    private final JetTypeMapper typeMapper;
    private final SamType samType;

    public SamWrapperCodegen(@NotNull GenerationState state, @NotNull SamType samType) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/SamWrapperCodegen", "<init>"));
        }
        if (samType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samType", "org/jetbrains/jet/codegen/SamWrapperCodegen", "<init>"));
        }
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.samType = samType;
    }

    public Type genWrapper(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/SamWrapperCodegen", "genWrapper"));
        }
        Type asmType = Type.getObjectType(this.getWrapperName(file));
        JetType functionType = this.samType.getKotlinFunctionType();
        SimpleFunctionDescriptor erasedInterfaceFunction = this.samType.getAbstractMethod().getOriginal();
        ClassBuilder cv = this.state.getFactory().newVisitor(asmType, file);
        cv.defineClass(file, 50, 16, asmType.getInternalName(), null, AsmTypeConstants.OBJECT_TYPE.getInternalName(), new String[]{this.typeMapper.mapType(this.samType.getType()).getInternalName()});
        cv.visitSource(file.getName(), null);
        AsmUtil.writeKotlinSyntheticClassAnnotation(cv, JvmAnnotationNames.KotlinSyntheticClass.Kind.SAM_WRAPPER);
        Type functionAsmType = this.typeMapper.mapType(functionType);
        cv.newField(null, 4114, "function", functionAsmType.getDescriptor(), null, null);
        this.generateConstructor(asmType, functionAsmType, cv);
        this.generateMethod(asmType, functionAsmType, cv, erasedInterfaceFunction, functionType);
        cv.done();
        return asmType;
    }

    private void generateConstructor(Type ownerType, Type functionType, ClassBuilder cv) {
        MethodVisitor mv = cv.newMethod(null, 0, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, functionType), null, null);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, AsmTypeConstants.OBJECT_TYPE);
            iv.invokespecial(AsmTypeConstants.OBJECT_TYPE.getInternalName(), "<init>", "()V");
            iv.load(0, AsmTypeConstants.OBJECT_TYPE);
            iv.load(1, functionType);
            iv.putfield(ownerType.getInternalName(), "function", functionType.getDescriptor());
            iv.visitInsn(177);
            FunctionCodegen.endVisit(iv, "constructor of SAM wrapper", null);
        }
    }

    private void generateMethod(Type ownerType, Type functionType, ClassBuilder cv, SimpleFunctionDescriptor erasedInterfaceFunction, JetType functionJetType) {
        FunctionCodegen codegen = new FunctionCodegen(CodegenContext.STATIC, cv, this.state, null);
        FunctionDescriptor invokeFunction = functionJetType.getMemberScope().getFunctions(Name.identifier("invoke")).iterator().next().getOriginal();
        StackValue.Field functionField = StackValue.field(functionType, ownerType, "function", false);
        codegen.genDelegate(erasedInterfaceFunction, invokeFunction, functionField);
    }

    @NotNull
    private String getWrapperName(@NotNull JetFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/jet/codegen/SamWrapperCodegen", "getWrapperName"));
        }
        FqName packageClassFqName = PackageClassUtils.getPackageClassFqName(containingFile.getPackageFqName());
        String packageInternalName = JvmClassName.byFqNameWithoutInnerClasses(packageClassFqName).getInternalName();
        JavaClassDescriptor descriptor = this.samType.getJavaClassDescriptor();
        String string = packageInternalName + "$sam$" + descriptor.getName().asString() + "$" + Integer.toHexString(JvmCodegenUtil.getPathHashCode(containingFile.getVirtualFile()) * 31 + DescriptorUtils.getFqNameSafe(descriptor).hashCode());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/SamWrapperCodegen", "getWrapperName"));
        }
        return string;
    }
}

