/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.context;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.binding.MutableClosure;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.LocalLookup;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.resolve.java.JvmAbi;

public abstract class FieldOwnerContext<T extends DeclarationDescriptor>
extends CodegenContext<T> {
    private final Map<String, Map<PropertyDescriptor, String>> fieldNames;

    public FieldOwnerContext(@NotNull T contextDescriptor, @NotNull OwnerKind contextKind, @Nullable CodegenContext parentContext, @Nullable MutableClosure closure, @Nullable ClassDescriptor thisDescriptor, @Nullable LocalLookup expressionCodegen) {
        if (contextDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDescriptor", "org/jetbrains/jet/codegen/context/FieldOwnerContext", "<init>"));
        }
        if (contextKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextKind", "org/jetbrains/jet/codegen/context/FieldOwnerContext", "<init>"));
        }
        super(contextDescriptor, contextKind, parentContext, closure, thisDescriptor, expressionCodegen);
        this.fieldNames = new HashMap<String, Map<PropertyDescriptor, String>>();
    }

    @NotNull
    public String getFieldName(@NotNull PropertyDescriptor descriptor, boolean isDelegated) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/context/FieldOwnerContext", "getFieldName"));
        }
        assert (descriptor.getKind().isReal()) : "Only declared properties can have backing fields: " + descriptor;
        boolean isExtension = descriptor.getReceiverParameter() != null;
        String string = this.getFieldName(descriptor.getOriginal(), isDelegated, isExtension);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/context/FieldOwnerContext", "getFieldName"));
        }
        return string;
    }

    @NotNull
    private String getFieldName(@NotNull PropertyDescriptor descriptor, boolean isDelegated, boolean isExtension) {
        String actualName;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/context/FieldOwnerContext", "getFieldName"));
        }
        String defaultPropertyName = JvmAbi.getDefaultPropertyName(descriptor.getName(), isDelegated, isExtension);
        Map<PropertyDescriptor, String> descriptor2Name = this.fieldNames.get(defaultPropertyName);
        if (descriptor2Name == null) {
            descriptor2Name = new HashMap<PropertyDescriptor, String>();
            this.fieldNames.put(defaultPropertyName, descriptor2Name);
        }
        if ((actualName = descriptor2Name.get(descriptor)) != null) {
            String string = actualName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/context/FieldOwnerContext", "getFieldName"));
            }
            return string;
        }
        String newName = descriptor2Name.isEmpty() ? defaultPropertyName : defaultPropertyName + "$" + descriptor2Name.size();
        descriptor2Name.put(descriptor, newName);
        String string = newName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/context/FieldOwnerContext", "getFieldName"));
        }
        return string;
    }
}

