/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitorWithResult;
import org.jetbrains.jet.lang.cfg.pseudocode.JetElementInstructionImpl;
import org.jetbrains.jet.lang.cfg.pseudocode.JumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.LexicalScope;
import org.jetbrains.jet.lang.psi.JetElement;

public class NondeterministicJumpInstruction
extends JetElementInstructionImpl
implements JumpInstruction {
    private Instruction next;
    private final List<Label> targetLabels;
    private final Map<Label, Instruction> resolvedTargets;

    public NondeterministicJumpInstruction(@NotNull JetElement element, List<Label> targetLabels, LexicalScope lexicalScope) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/pseudocode/NondeterministicJumpInstruction", "<init>"));
        }
        super(element, lexicalScope);
        this.targetLabels = Lists.newArrayList(targetLabels);
        this.resolvedTargets = Maps.newLinkedHashMap();
    }

    public NondeterministicJumpInstruction(@NotNull JetElement element, Label targetLabel, LexicalScope lexicalScope) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/pseudocode/NondeterministicJumpInstruction", "<init>"));
        }
        this(element, Lists.newArrayList(targetLabel), lexicalScope);
    }

    public List<Label> getTargetLabels() {
        return this.targetLabels;
    }

    public Map<Label, Instruction> getResolvedTargets() {
        return this.resolvedTargets;
    }

    public void setResolvedTarget(Label label, Instruction resolvedTarget) {
        Instruction target = this.outgoingEdgeTo(resolvedTarget);
        this.resolvedTargets.put(label, target);
    }

    public Instruction getNext() {
        return this.next;
    }

    public void setNext(Instruction next) {
        this.next = this.outgoingEdgeTo(next);
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/cfg/pseudocode/NondeterministicJumpInstruction", "accept"));
        }
        visitor.visitNondeterministicJump(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<R> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/cfg/pseudocode/NondeterministicJumpInstruction", "accept"));
        }
        return visitor.visitNondeterministicJump(this);
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        ArrayList<Instruction> targetInstructions = Lists.newArrayList(this.getResolvedTargets().values());
        targetInstructions.add(this.getNext());
        ArrayList<Instruction> arrayList = targetInstructions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/NondeterministicJumpInstruction", "getNextInstructions"));
        }
        return arrayList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("jmp?(");
        Iterator<Label> iterator2 = this.targetLabels.iterator();
        while (iterator2.hasNext()) {
            Label targetLabel = iterator2.next();
            sb.append(targetLabel.getName());
            if (!iterator2.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    @NotNull
    protected Instruction createCopy() {
        Instruction instruction = this.createCopy(this.getTargetLabels());
        if (instruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/NondeterministicJumpInstruction", "createCopy"));
        }
        return instruction;
    }

    @NotNull
    public final Instruction copy(@NotNull List<Label> newTargetLabels) {
        if (newTargetLabels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTargetLabels", "org/jetbrains/jet/lang/cfg/pseudocode/NondeterministicJumpInstruction", "copy"));
        }
        Instruction instruction = this.updateCopyInfo(this.createCopy(newTargetLabels));
        if (instruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/NondeterministicJumpInstruction", "copy"));
        }
        return instruction;
    }

    private Instruction createCopy(@NotNull List<Label> newTargetLabels) {
        if (newTargetLabels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTargetLabels", "org/jetbrains/jet/lang/cfg/pseudocode/NondeterministicJumpInstruction", "createCopy"));
        }
        return new NondeterministicJumpInstruction(this.getElement(), newTargetLabels, this.lexicalScope);
    }
}

